/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.overlays.NpcDialogueFeature;
import com.wynntils.handlers.chat.type.NpcDialogueType;
import com.wynntils.models.npcdialogue.event.NpcDialogueProcessingEvent;
import com.wynntils.models.npcdialogue.event.NpcDialogueRemoved;
import com.wynntils.models.npcdialogue.type.NpcDialogue;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

public class NpcDialogueOverlay
extends Overlay {
    private static final StyledText PRESS_SNEAK_TO_CONTINUE = StyledText.fromString("\u00a7cPress SNEAK to continue");
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.NORMAL);
    @Persisted
    private final Config<Float> backgroundOpacity = new Config<Float>(Float.valueOf(0.2f));
    @Persisted
    private final Config<Boolean> stripColors = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> showHelperTexts = new Config<Boolean>(true);
    private TextRenderSetting renderSetting;
    private Component selectionComponents = null;

    public NpcDialogueOverlay() {
        super(new OverlayPosition(0.0f, 0.0f, VerticalAlignment.TOP, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(400.0f, 50.0f), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
        this.updateTextRenderSettings();
    }

    @SubscribeEvent
    public void onNpcDialoguePost(NpcDialogueProcessingEvent.Post event) {
        NpcDialogue dialogue = event.getDialogue();
        if (dialogue.dialogueType() == NpcDialogueType.SELECTION) {
            if (this.selectionComponents != null) {
                return;
            }
            MutableComponent clickMsg = Component.literal((String)"Click on an option in chat to continue:\n").withStyle(ChatFormatting.AQUA);
            event.getPostProcessedDialogue().forEach(line -> clickMsg.append((Component)Component.literal((String)"\n").append((Component)line.getComponent())));
            McUtils.sendMessageToClient((Component)clickMsg);
            this.selectionComponents = clickMsg;
        }
    }

    @SubscribeEvent
    public void onNpcDialogueRemoved(NpcDialogueRemoved event) {
        if (event.getRemovedDialogue().dialogueType() == NpcDialogueType.SELECTION && this.selectionComponents != null) {
            McUtils.removeMessageFromChat(this.selectionComponents);
            this.selectionComponents = null;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        NpcDialogue currentDialogue = Models.NpcDialogue.getCurrentDialogue();
        List<NpcDialogue> confirmationlessDialogues = Models.NpcDialogue.getConfirmationlessDialogues();
        if (currentDialogue.isEmpty() && confirmationlessDialogues.isEmpty()) {
            return;
        }
        LinkedList<Pair> unsortedDialogues = new LinkedList<Pair>();
        if (!currentDialogue.isEmpty()) {
            unsortedDialogues.add(Pair.of(currentDialogue.addTime(), currentDialogue.currentDialogue()));
        }
        confirmationlessDialogues.forEach(d -> unsortedDialogues.add(Pair.of(d.addTime(), d.currentDialogue())));
        unsortedDialogues.sort(Comparator.comparingLong(Pair::a));
        LinkedList<StyledText> allDialogues = new LinkedList<StyledText>();
        unsortedDialogues.forEach(pair -> {
            allDialogues.addAll((Collection)pair.b());
            allDialogues.add(StyledText.EMPTY);
        });
        allDialogues.removeLast();
        this.renderDialogue(guiGraphics.pose(), bufferSource, allDialogues, currentDialogue.dialogueType(), currentDialogue.isProtected());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        List<StyledText> fakeDialogue = List.of(StyledText.fromString("\u00a77[1/2] \u00a72Random Citizen: \u00a7aDid you know that Wynntils is the best Wynncraft mod you'll probably find?"), StyledText.EMPTY, StyledText.fromString("\u00a77[2/2] \u00a72Random Citizen: \u00a7aIt's got so many features, it's hard to keep track of them all!"));
        this.updateTextRenderSettings();
        this.renderDialogue(guiGraphics.pose(), bufferSource, fakeDialogue, NpcDialogueType.NORMAL, true);
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateTextRenderSettings();
    }

    private void updateTextRenderSettings() {
        this.renderSetting = TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth() - 5.0f).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withTextShadow((TextShadow)this.textShadow.get());
    }

    private void renderDialogue(PoseStack poseStack, MultiBufferSource bufferSource, List<StyledText> currentDialogue, NpcDialogueType dialogueType, boolean isProtected) {
        List<TextRenderTask> dialogueRenderTasks = currentDialogue.stream().map(s -> new TextRenderTask((StyledText)s, this.renderSetting)).toList();
        if (((Boolean)this.stripColors.get()).booleanValue()) {
            dialogueRenderTasks.forEach(dialogueRenderTask -> dialogueRenderTask.setText(dialogueRenderTask.getText().getStringWithoutFormatting()));
        }
        float textHeight = (float)dialogueRenderTasks.stream().map(dialogueRenderTask -> Float.valueOf(FontRenderer.getInstance().calculateRenderHeight(dialogueRenderTask.getText(), dialogueRenderTask.getSetting().maxWidth()))).mapToDouble(f -> f.floatValue()).sum();
        float rectHeight = textHeight + 10.0f;
        float rectRenderY = switch (this.getRenderVerticalAlignment()) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> this.getRenderY();
            case VerticalAlignment.MIDDLE -> this.getRenderY() + (this.getHeight() - rectHeight) / 2.0f;
            case VerticalAlignment.BOTTOM -> this.getRenderY() + this.getHeight() - rectHeight;
        };
        int colorAlphaRect = Math.round(MathUtils.clamp(255.0f * ((Float)this.backgroundOpacity.get()).floatValue(), 0.0f, 255.0f));
        BufferedRenderUtils.drawRect(poseStack, bufferSource, CommonColors.BLACK.withAlpha(colorAlphaRect), this.getRenderX(), rectRenderY, 0.0f, this.getWidth(), rectHeight);
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(poseStack, bufferSource, this.getRenderX(), this.getRenderY(), dialogueRenderTasks, this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
        if (((Boolean)this.showHelperTexts.get()).booleanValue()) {
            StyledText protection;
            LinkedList<TextRenderTask> helperRenderTasks = new LinkedList<TextRenderTask>();
            StyledText styledText = protection = isProtected ? StyledText.fromString("\u00a7f<protected> \u00a7r") : StyledText.EMPTY;
            if (dialogueType == NpcDialogueType.NORMAL) {
                TextRenderTask pressSneakMessage = new TextRenderTask(PRESS_SNEAK_TO_CONTINUE.prepend(protection), this.renderSetting);
                helperRenderTasks.add(pressSneakMessage);
            } else if (dialogueType == NpcDialogueType.SELECTION) {
                String msg = isProtected ? "Select an option to continue (Press the number key to select it)" : "Open chat and click on the option to select it";
                TextRenderTask pressSneakMessage = new TextRenderTask(protection.append("\u00a7c" + msg), this.renderSetting);
                helperRenderTasks.add(pressSneakMessage);
            }
            NpcDialogueFeature feature = Managers.Feature.getFeatureInstance(NpcDialogueFeature.class);
            if (feature.getScheduledAutoProgressKeyPress() != null && !feature.getScheduledAutoProgressKeyPress().isCancelled()) {
                long timeUntilProgress = feature.getScheduledAutoProgressKeyPress().getDelay(TimeUnit.MILLISECONDS);
                TextRenderTask autoProgressMessage = new TextRenderTask(String.valueOf(ChatFormatting.GREEN) + "Auto-progress: " + Math.max(0, Math.round((float)timeUntilProgress / 1000.0f)) + " seconds (Press " + StyledText.fromComponent(feature.cancelAutoProgressKeybind.getKeyMapping().getTranslatedKeyMessage()).getStringWithoutFormatting() + " to cancel)", this.renderSetting);
                helperRenderTasks.add(autoProgressMessage);
            }
            BufferedFontRenderer.getInstance().renderTextsWithAlignment(poseStack, bufferSource, this.getRenderX(), this.getRenderY() + 20.0f + textHeight, helperRenderTasks, this.getWidth(), this.getHeight() - 20.0f, this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
        }
    }
}

