/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.activities.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.activities.type.ActivityTrackingState;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.screens.activities.ContentBookHolder;
import com.wynntils.screens.activities.WynntilsContentBookScreen;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class ContentBookWidget
extends AbstractWidget
implements TooltipProvider {
    private static final CustomColor UNAVAILABLE_COLOR = CustomColor.fromHexString("#AD976C");
    private final ContentBookHolder holder;
    private final ActivityInfo activityInfo;
    private final ItemStack itemStack;
    private final Integer slot;
    private final List<Component> tooltip;
    private final boolean searchMatch;
    private Style nameStyle = Style.EMPTY;

    public ContentBookWidget(int x, int y, Pair<ItemStack, ActivityInfo> activityInfoPair, int slot, ContentBookHolder holder, boolean searchMatch) {
        super(x, y, 132, 16, (Component)Component.literal((String)"Content Book Activity Button"));
        this.itemStack = activityInfoPair.a();
        this.activityInfo = activityInfoPair.b();
        this.slot = slot;
        this.holder = holder;
        this.searchMatch = searchMatch;
        ArrayList<Component> addons = new ArrayList<Component>();
        addons.add((Component)Component.empty());
        if (this.canSetCompass()) {
            addons.add((Component)Component.translatable((String)"screens.wynntils.contentBook.leftClickToSetCompass").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GREEN));
        }
        if (this.canOpenMap()) {
            addons.add((Component)Component.translatable((String)"screens.wynntils.contentBook.middleClickToOpenOnMap").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.YELLOW));
        }
        addons.add((Component)Component.translatable((String)"screens.wynntils.contentBook.rightClickToOpenWiki").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD));
        this.tooltip = LoreUtils.appendTooltip(this.itemStack, LoreUtils.getTooltipLines(this.itemStack), addons);
        if (this.activityInfo.trackingState() == ActivityTrackingState.TRACKED) {
            this.nameStyle = this.nameStyle.withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true));
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        CustomColor gradientColor = this.activityInfo.status() == ActivityStatus.UNAVAILABLE ? UNAVAILABLE_COLOR : this.activityInfo.type().getColor();
        RenderUtils.fillSidewaysGradient(guiGraphics.pose(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0, gradientColor, gradientColor.withAlpha(0));
        guiGraphics.renderItem(this.itemStack, this.getX(), this.getY());
        this.nameStyle = this.nameStyle.withBold(Boolean.valueOf(this.isHovered || this.activityInfo.trackingState() == ActivityTrackingState.TRACKED));
        FontRenderer.getInstance().renderScrollingText(guiGraphics.pose(), StyledText.fromComponent((Component)Component.literal((String)this.activityInfo.name()).withStyle(this.nameStyle)), this.getX() + 18, this.getY() + 8, this.width - 18, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.holder.inTutorial) {
            RenderUtils.drawRotatingBorderSegment(guiGraphics.pose(), CommonColors.RED, this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 1.0f, 2.0f, 0.25f);
        }
        if (this.searchMatch) {
            return;
        }
        RenderUtils.drawRect(guiGraphics.pose(), CommonColors.BLACK.withAlpha(100), this.getX(), this.getY(), 1.0f, this.width, this.height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.canSetCompass()) {
                Models.Activity.placeCompassOnActivity(this.activityInfo);
            } else {
                Screen screen;
                this.holder.pressSlot(this.slot);
                if (this.activityInfo.trackingState() == ActivityTrackingState.TRACKED && (screen = McUtils.screen()) instanceof WynntilsContentBookScreen) {
                    WynntilsContentBookScreen contentBookScreen = (WynntilsContentBookScreen)screen;
                    contentBookScreen.removeTrackedActivity();
                }
            }
        } else if (button == 2 && this.canOpenMap()) {
            Models.Activity.openMapOnActivity(this.activityInfo);
        } else if (button == 1) {
            if (this.activityInfo.type() == ActivityType.WORLD_EVENT && this.activityInfo.status() == ActivityStatus.AVAILABLE && KeyboardUtils.isShiftDown()) {
                this.holder.pressSlot(this.slot, button);
            } else {
                Models.Activity.openActivityOnWiki(this.activityInfo);
            }
        }
        return true;
    }

    @Override
    public List<Component> getTooltipLines() {
        return Collections.unmodifiableList(this.tooltip);
    }

    private boolean canSetCompass() {
        return switch (this.activityInfo.type()) {
            case ActivityType.SECRET_DISCOVERY -> true;
            case ActivityType.WORLD_DISCOVERY, ActivityType.TERRITORIAL_DISCOVERY, ActivityType.BOSS_ALTAR -> {
                if (this.activityInfo.status() != ActivityStatus.AVAILABLE && this.activityInfo.trackingState() != ActivityTrackingState.TRACKED) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean canOpenMap() {
        return switch (this.activityInfo.type()) {
            case ActivityType.QUEST, ActivityType.STORYLINE_QUEST -> {
                if (this.activityInfo.status() == ActivityStatus.STARTED || this.activityInfo.status() == ActivityStatus.AVAILABLE) {
                    yield true;
                }
                yield false;
            }
            case ActivityType.MINI_QUEST -> {
                if (this.activityInfo.status() != ActivityStatus.COMPLETED && this.activityInfo.trackingState() != ActivityTrackingState.UNTRACKABLE) {
                    yield true;
                }
                yield false;
            }
            case ActivityType.WORLD_EVENT -> false;
            default -> true;
        };
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

