/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class SearchWidget
extends TextInputBoxWidget {
    private static final Component DEFAULT_TEXT = Component.translatable((String)"screens.wynntils.searchWidget.defaultSearchText");
    protected static final float VERTICAL_OFFSET = 6.5f;

    public SearchWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"Search Box"), onUpdateConsumer, textboxScreen);
        this.textPadding = 5;
    }

    @Override
    protected void doRenderWidget(PoseStack poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, Font font, int firstWidth, int highlightedWidth, int lastWidth) {
        boolean defaultText = Objects.equals(this.textBoxInput, "");
        this.renderBackground(poseStack);
        this.renderText(poseStack, renderedText, renderedTextStart, firstPortion, highlightedPortion, lastPortion, font, firstWidth, highlightedWidth, lastWidth, defaultText);
    }

    protected void renderText(PoseStack poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, Font font, int firstWidth, int highlightedWidth, int lastWidth, boolean defaultText) {
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(defaultText ? DEFAULT_TEXT.getString() : firstPortion), (float)(this.getX() + this.textPadding), (float)(this.getX() + this.width - this.textPadding - lastWidth - highlightedWidth), (float)this.getY() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        if (!defaultText) {
            FontRenderer.getInstance().renderAlignedHighlightedTextInBox(poseStack, StyledText.fromString(highlightedPortion), this.getX() + this.textPadding + firstWidth, this.getX() + this.width - this.textPadding - lastWidth, (float)this.getY() + 6.5f, (float)this.getY() + 6.5f, 0.0f, CommonColors.BLUE, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(lastPortion), (float)(this.getX() + this.textPadding + firstWidth + highlightedWidth), (float)(this.getX() + this.width - this.textPadding), (float)this.getY() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        }
        this.drawCursor(poseStack, this.getX() + font.width(renderedText.substring(0, Math.min(this.cursorPosition, renderedText.length()))) + this.textPadding - 2, (float)this.getY() + 6.5f, VerticalAlignment.TOP, false);
    }

    protected void renderBackground(PoseStack poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.BLACK, this.getX(), this.getY(), 0.0f, this.width, this.height);
        RenderUtils.drawRectBorders(poseStack, this.isHovered ? CommonColors.LIGHT_GRAY : CommonColors.GRAY, this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0.0f, 1.0f);
    }

    @Override
    protected int getMaxTextWidth() {
        return this.width - 18;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height)) {
            McUtils.playSoundUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
            if (button == 1) {
                this.setTextBoxInput("");
                this.setCursorAndHighlightPositions(0);
            } else {
                this.setCursorAndHighlightPositions(this.getIndexAtPosition(mouseX));
            }
            this.isDragging = true;
            this.textboxScreen.setFocusedTextInput(this);
            return true;
        }
        this.textboxScreen.setFocusedTextInput(null);
        return false;
    }

    @Override
    protected void removeFocus() {
        this.setTextBoxInput("");
        super.removeFocus();
    }

    public void opened() {
        this.setCursorPosition(this.textBoxInput.length());
        this.setHighlightPosition(0);
    }
}

