/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.bulkbuy.widgets;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.ui.BulkBuyFeature;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.AnimationPercentage;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class BulkBuyWidget
extends AbstractWidget {
    private static final MultiBufferSource.BufferSource BUFFER_SOURCE = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    private static final int BULK_BUY_WIDGET_CENTER = 89;
    private final int originalX;
    private final AnimationPercentage animationPercentage;
    private BulkBuyFeature.BulkBoughtItem bulkBoughtItem = null;

    public BulkBuyWidget(int x, int y, int width, int height, int animationDuration) {
        super(x, y, width, height, (Component)Component.literal((String)"Bulk Buy Widget"));
        this.originalX = x;
        this.animationPercentage = new AnimationPercentage(() -> this.bulkBoughtItem != null, Duration.of(animationDuration, ChronoUnit.MILLIS));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.setX(this.originalX - (int)((double)this.getWidth() * this.animationPercentage.getAnimation()));
        RenderUtils.createRectMask(guiGraphics.pose(), this.originalX - this.getWidth(), this.getY(), this.getWidth(), this.getHeight());
        RenderUtils.drawTexturedRect(guiGraphics.pose(), Texture.BULK_BUY_PANEL, this.getX(), this.getY());
        if (this.bulkBoughtItem == null) {
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(I18n.get((String)"feature.wynntils.bulkBuy.widget.bulkBuy", (Object[])new Object[0])), this.getX() + 89, this.getY() + 54, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(I18n.get((String)"feature.wynntils.bulkBuy.widget.idle", (Object[])new Object[0])), this.getX() + 89, this.getY() + 65, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        } else {
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(I18n.get((String)"feature.wynntils.bulkBuy.widget.currentlyBuying", (Object[])new Object[0])), this.getX() + 89, this.getY() + 29, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            GuiGraphics itemRenderGuiGraphics = new GuiGraphics(McUtils.mc(), BUFFER_SOURCE);
            itemRenderGuiGraphics.renderItem(this.bulkBoughtItem.itemStack(), this.getX() + 89 - 8, this.getY() + 34);
            FontRenderer.getInstance().renderScrollingText(guiGraphics.pose(), StyledText.fromString(this.bulkBoughtItem.itemStack().getHoverName().getString()), this.getX() + 89, this.getY() + 63, this.getWidth() - 20, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(I18n.get((String)"feature.wynntils.bulkBuy.widget.amount", (Object[])new Object[]{this.bulkBoughtItem.amount()})), this.getX() + 89, this.getY() + 79, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(I18n.get((String)"feature.wynntils.bulkBuy.widget.totalPrice", (Object[])new Object[]{this.bulkBoughtItem.amount() * this.bulkBoughtItem.price()})), this.getX() + 89, this.getY() + 89, CommonColors.LIGHT_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(I18n.get((String)"feature.wynntils.bulkBuy.widget.closeCancel", (Object[])new Object[0])), this.getX() + 89, this.getY() + 99, CommonColors.GRAY, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        }
        RenderUtils.clearMask();
    }

    public void setBulkBoughtItem(BulkBuyFeature.BulkBoughtItem bulkBoughtItem) {
        this.bulkBoughtItem = bulkBoughtItem;
    }

    public AnimationPercentage getAnimationPercentage() {
        return this.animationPercentage;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

