/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.changelog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsPagedScreen;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.changelog.widgets.ExitFlagButton;
import com.wynntils.services.athena.type.ChangelogMap;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public final class ChangelogScreen
extends WynntilsScreen
implements WynntilsPagedScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int SCISSOR_HEIGHT = 165;
    private static final int SCROLLBAR_RENDER_X = 268;
    private static final int SCROLL_AREA_HEIGHT = 120;
    private static final int SCROLLBAR_HEIGHT = 20;
    private static final int SCROLLBAR_WIDTH = 6;
    private final ChangelogMap changelog;
    private final Screen previousScreen;
    private List<List<TextRenderTask>> changelogTasks;
    private boolean draggingScroll = false;
    private int currentPage = 0;
    private int offsetX;
    private int offsetY;
    private int scrollOffset = 0;
    private int scrollRenderY;

    private ChangelogScreen(ChangelogMap changelog, Screen previousScreen) {
        super((Component)Component.translatable((String)"screens.wynntils.changelog.name"));
        this.changelog = changelog;
        this.previousScreen = previousScreen;
    }

    public static Screen create(ChangelogMap changelog, Screen previousScreen) {
        return new ChangelogScreen(changelog, previousScreen);
    }

    public static Screen create(ChangelogMap changelog) {
        return new ChangelogScreen(changelog, null);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.width - Texture.SCROLL_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.height - Texture.SCROLL_BACKGROUND.height()) / 2.0f);
        this.calculateRenderTasks();
        this.setCurrentPage(0);
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton((int)(80.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.SCROLL_BACKGROUND.height() - 17 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton(Texture.SCROLL_BACKGROUND.width() - 80 + this.offsetX, Texture.SCROLL_BACKGROUND.height() - 17 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
        this.addRenderableWidget((GuiEventListener)new ExitFlagButton(this.offsetX - 35, this.offsetY + 24, this::onClose));
    }

    public void onClose() {
        super.onClose();
        if (this.previousScreen != null) {
            McUtils.setScreen(this.previousScreen);
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BACKGROUND, this.offsetX, this.offsetY);
        RenderUtils.enableScissor(guiGraphics, this.offsetX + 40, this.offsetY + 11, 220, 165);
        FontRenderer.getInstance().renderTexts(poseStack, 45 + this.offsetX, 15 + this.offsetY - this.scrollOffset, this.changelogTasks.get(this.currentPage));
        RenderUtils.disableScissor(guiGraphics);
        if (this.getMaxScrollOffset() != 0) {
            this.renderScrollBar(poseStack);
        }
        this.renderPageInfo(poseStack, this.getCurrentPage() + 1, this.getMaxPage() + 1);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderPageInfo(PoseStack poseStack, int currentPage, int maxPage) {
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(currentPage + " / " + maxPage), (float)(80 + this.offsetX), (float)(Texture.SCROLL_BACKGROUND.width() - 80 + this.offsetX), (float)(Texture.SCROLL_BACKGROUND.height() - 17 + this.offsetY), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, TextShadow.OUTLINE);
    }

    private void renderScrollBar(PoseStack poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, this.offsetX + 268, this.offsetY + 14, 0.0f, 6.0f, 120.0f);
        this.scrollRenderY = (int)((float)(this.offsetY + 14) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 100.0f));
        RenderUtils.drawRect(poseStack, this.draggingScroll ? CommonColors.BLACK : CommonColors.GRAY, this.offsetX + 268, this.scrollRenderY, 0.0f, 6.0f, 20.0f);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX + 268, this.offsetX + 268 + 6, this.scrollRenderY, this.scrollRenderY + 20)) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = this.offsetY + 14 + 10;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + 120 - 20, 0.0f, this.getMaxScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.getMaxScrollOffset()));
        this.scroll(newOffset);
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
    }

    private int getMaxScrollOffset() {
        float totalHeight = FontRenderer.getInstance().calculateRenderHeight(this.changelogTasks.get(this.currentPage));
        if (totalHeight <= 165.0f) {
            return 0;
        }
        return (int)(totalHeight - 165.0f);
    }

    private void calculateRenderTasks() {
        TextRenderSetting setting = TextRenderSetting.DEFAULT.withMaxWidth(Texture.SCROLL_BACKGROUND.width() - 85).withCustomColor(CommonColors.WHITE).withTextShadow(TextShadow.OUTLINE);
        this.changelogTasks = this.changelog.allChangelogs().stream().map(content -> Arrays.stream(content.split("\n")).map(StringUtils::convertMarkdownToColorCode).map(s -> new TextRenderTask((String)s, setting)).toList()).toList();
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.scrollOffset = 0;
        this.currentPage = MathUtils.clamp(currentPage, 0, this.getMaxPage());
    }

    @Override
    public int getMaxPage() {
        return Math.max(0, this.changelogTasks.size() - 1);
    }
}

