/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.container.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.container.widgets.PersonalStorageUtilitiesWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class QuickJumpButton
extends WynntilsButton {
    private final int destination;
    private final CustomColor lockedColor;
    private final CustomColor selectedColor;
    private final PersonalStorageUtilitiesWidget parent;

    public QuickJumpButton(int x, int y, int destination, CustomColor lockedColor, CustomColor selectedColor, PersonalStorageUtilitiesWidget parent) {
        super(x, y, 16, 16, (Component)Component.literal((String)"Container Quick Jump Button"));
        this.destination = destination;
        this.lockedColor = lockedColor;
        this.selectedColor = selectedColor;
        this.parent = parent;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawHoverableTexturedRect(poseStack, Texture.QUICK_JUMP_BUTTON, this.getX(), this.getY(), this.isHovered);
        CustomColor color = CommonColors.WHITE;
        MutableComponent tooltip = Component.translatable((String)"feature.wynntils.personalStorageUtilities.jumpTo", (Object[])new Object[]{Models.Bank.getPageName(this.destination)});
        if (Models.Bank.getCurrentPage() == this.destination) {
            color = this.selectedColor;
            tooltip = Component.translatable((String)"feature.wynntils.personalStorageUtilities.youAreHere");
        } else if (this.destination > Models.Bank.getFinalPage()) {
            color = this.lockedColor;
            tooltip = Component.translatable((String)"feature.wynntils.personalStorageUtilities.unavailable", (Object[])new Object[]{this.destination});
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(this.destination)), this.getX() + 8, this.getY() + 8, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.isHovered) {
            McUtils.screen().setTooltipForNextRenderPass(Lists.transform(List.of(tooltip), Component::getVisualOrderText));
        }
    }

    public void onPress() {
        this.parent.jumpToPage(this.destination);
    }
}

