/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.downloads;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.net.DownloadDependencyGraph;
import com.wynntils.core.net.QueuedDownload;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.ui.WynncraftButtonFeature;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.downloads.widgets.DownloadWidget;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;

public final class DownloadScreen
extends WynntilsGridLayoutScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int WIDGET_TOP_Y = 11;
    private static final int WIDGETS_PER_PAGE = 15;
    private final Screen previousScreen;
    private final ServerData serverData;
    private final Component infoText;
    private List<DownloadWidget> downloadWidgets = new ArrayList<DownloadWidget>();
    private int scrollY;
    private int scrollOffset = 0;
    private int widgetHeight;
    private boolean draggingScroll = false;

    private DownloadScreen(Screen previousScreen, ServerData serverData) {
        super((Component)Component.translatable((String)"screens.wynntils.downloads.name"));
        this.previousScreen = previousScreen;
        this.serverData = serverData;
        this.infoText = Component.translatable((String)"screens.wynntils.downloads.description1").append("\n\n").append((Component)Component.translatable((String)"screens.wynntils.downloads.description2")).append("\n\n").append((Component)Component.translatable((String)"screens.wynntils.downloads.description3")).append("\n\n").append((Component)Component.translatable((String)"screens.wynntils.downloads.description4"));
    }

    public static Screen create(Screen previousScreen, ServerData serverData) {
        return new DownloadScreen(previousScreen, serverData);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.downloads.back"), button -> this.onClose()).pos((int)(this.dividedWidth * 5.0f), (int)(this.dividedHeight * 37.0f)).size((int)(this.dividedWidth * 6.0f), 20).build());
        if (this.serverData != null) {
            this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.downloads.connect"), button -> this.connectToServer()).pos((int)this.dividedWidth, (int)(this.dividedHeight * 31.0f)).size((int)(this.dividedWidth * 14.0f), 20).build());
            this.addRenderableWidget((GuiEventListener)new WynntilsCheckbox((int)(this.dividedWidth * 2.0f), (int)(this.dividedHeight * 25.0f), 20, (Component)Component.translatable((String)"screens.wynntils.downloads.dontShowAgain"), false, (int)(this.dividedWidth * 10.0f), (c, b) -> this.toggleShowAgain((boolean)b)));
        }
        this.widgetHeight = (int)(this.dividedHeight * 3.5f);
        this.updateDownloadWidgets();
    }

    public void onClose() {
        McUtils.setScreen(this.previousScreen);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.downloads.name").withStyle(ChatFormatting.UNDERLINE)), this.dividedWidth * 32.0f, this.dividedHeight * 6.5f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f);
        RenderUtils.enableScissor(guiGraphics, (int)(this.dividedWidth * 16.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 32.0f), 15 * this.widgetHeight);
        for (Renderable renderable : this.downloadWidgets) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, this.dividedWidth * 48.0f, (int)(this.dividedHeight * 11.0f), 0.0f, 6.0f, 15 * this.widgetHeight);
        this.scrollY = (int)(this.dividedHeight * 11.0f + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 15 * this.widgetHeight - 20));
        RenderUtils.drawRect(poseStack, this.draggingScroll ? CommonColors.BLACK : CommonColors.GRAY, this.dividedWidth * 48.0f, this.scrollY, 0.0f, 6.0f, 20.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.downloads.info").withStyle(ChatFormatting.UNDERLINE)), this.dividedWidth * 56.0f, this.dividedHeight * 11.0f - 18.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL, 1.5f);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent(this.infoText), this.dividedWidth * 50.0f, this.dividedWidth * 63.0f, this.dividedHeight * 11.0f, this.dividedHeight * 11.0f + (float)(15 * this.widgetHeight), this.dividedWidth * 13.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 0.8f);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && MathUtils.isInside((int)mouseX, (int)mouseY, (int)(this.dividedWidth * 48.0f), (int)(this.dividedWidth * 48.0f + 6.0f), this.scrollY, this.scrollY + 20)) {
            this.draggingScroll = true;
            return true;
        }
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseClicked(mouseX, mouseY, button);
        }
        for (DownloadWidget downloadWidget : this.downloadWidgets) {
            if (!downloadWidget.isMouseOver(mouseX, mouseY)) continue;
            return downloadWidget.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = (int)(this.dividedHeight * 11.0f + 10.0f);
            int scrollAreaHeight = 14 * this.widgetHeight;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.getMaxScrollOffset()));
        this.scroll(newOffset);
        return true;
    }

    private void connectToServer() {
        ConnectScreen.startConnecting((Screen)this, (Minecraft)McUtils.mc(), (ServerAddress)ServerAddress.parseString((String)this.serverData.ip), (ServerData)this.serverData, (boolean)false, null);
    }

    private void toggleShowAgain(boolean show) {
        Managers.Feature.getFeatureInstance(WynncraftButtonFeature.class).ignoreFailedDownloads.store(show);
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
        for (DownloadWidget widget : this.downloadWidgets) {
            int newY = (int)(this.dividedHeight * 11.0f + (float)(this.downloadWidgets.indexOf((Object)widget) * this.widgetHeight) - (float)this.scrollOffset);
            widget.setY(newY);
            widget.visible = (float)newY >= this.dividedHeight * 11.0f - (float)this.widgetHeight && (float)newY <= this.dividedHeight * 11.0f + (float)(16 * this.widgetHeight);
        }
    }

    private void updateDownloadWidgets() {
        for (AbstractWidget abstractWidget : this.downloadWidgets) {
            this.removeWidget((GuiEventListener)abstractWidget);
        }
        this.downloadWidgets = new ArrayList<DownloadWidget>();
        int y = (int)(this.dividedHeight * 11.0f);
        for (QueuedDownload download : Managers.Download.registeredDownloads()) {
            DownloadDependencyGraph.DownloadDependencyGraphState downloadState = Managers.Download.graphState();
            this.downloadWidgets.add(new DownloadWidget((int)(this.dividedWidth * 16.0f), y, (int)(this.dividedWidth * 32.0f), this.widgetHeight, download));
            y += this.widgetHeight;
        }
        this.scroll(this.scrollOffset);
    }

    private int getMaxScrollOffset() {
        return (this.downloadWidgets.size() - 15) * this.widgetHeight;
    }
}

