/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.emeraldpouch;

import com.wynntils.core.components.Services;
import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.screens.guides.GuideItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;

public final class GuideEmeraldPouchItemStack
extends GuideItemStack {
    private final int tier;
    private final List<Component> generatedTooltip;

    public GuideEmeraldPouchItemStack(int tier) {
        super(new ItemStack((ItemLike)Items.DIAMOND_AXE), new EmeraldPouchItem(tier, 0), "Emerald Pouch");
        this.setDamageValue(97);
        this.tier = tier;
        this.set(DataComponents.UNBREAKABLE, new Unbreakable(false));
        this.generatedTooltip = GuideEmeraldPouchItemStack.generatePouchLore(tier);
    }

    private static List<Component> generatePouchLore(int tier) {
        int upTo = (tier - 1) / 3;
        int rows = 0;
        Object totalString = "";
        switch (tier % 3) {
            case 0: {
                rows = 6;
                totalString = "54";
                break;
            }
            case 1: {
                rows = 1;
                totalString = "9";
                break;
            }
            case 2: {
                rows = 3;
                totalString = "27";
            }
        }
        if (tier >= 10) {
            rows = 6;
        }
        totalString = tier >= 7 ? tier - 6 + "stx" : (tier >= 4 ? (String)totalString + EmeraldUnits.LIQUID_EMERALD.getSymbol() : (String)totalString + EmeraldUnits.EMERALD_BLOCK.getSymbol());
        ArrayList<Component> itemLore = new ArrayList<Component>();
        itemLore.add((Component)Component.empty());
        itemLore.add((Component)Component.literal((String)"Emerald Pouches allows the wearer to easily ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"store ").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"and ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"convert ").withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"picked emeralds without spending extra inventory slots.").withStyle(ChatFormatting.GRAY)));
        itemLore.add((Component)Component.empty());
        itemLore.add((Component)Component.literal((String)(" - " + rows + " Rows ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("(" + (String)totalString + " Total)"))).withStyle(ChatFormatting.DARK_GRAY));
        switch (upTo) {
            case 0: {
                itemLore.add((Component)Component.literal((String)"No Auto-Conversions").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 1: {
                itemLore.add((Component)Component.literal((String)"Converts up to").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)" Emerald Blocks").withStyle(ChatFormatting.WHITE)));
                break;
            }
            default: {
                itemLore.add((Component)Component.literal((String)"Converts up to").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)" Liquid Emeralds").withStyle(ChatFormatting.WHITE)));
            }
        }
        return itemLore;
    }

    public Component getHoverName() {
        return Component.literal((String)"Emerald Pouch ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)("[Tier " + this.tier + "]")).withStyle(ChatFormatting.DARK_GREEN));
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, Player player, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getHoverName());
        tooltip.addAll(this.generatedTooltip);
        tooltip.add((Component)Component.empty());
        if (Services.Favorites.isFavorite(this)) {
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").withStyle(ChatFormatting.GREEN));
        }
        return tooltip;
    }

    public int getTier() {
        return this.tier;
    }
}

