/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.gear;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.guides.gear.GuideGearItemStack;
import com.wynntils.screens.guides.gear.WynntilsItemGuideScreen;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuideGearItemStackButton
extends WynntilsButton {
    private final GuideGearItemStack itemStack;

    public GuideGearItemStackButton(int x, int y, int width, int height, GuideGearItemStack itemStack, WynntilsItemGuideScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Guide GearItemStack Button"));
        this.itemStack = itemStack;
        itemStack.buildTooltip();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        CustomColor color = CustomColor.fromChatFormatting(this.itemStack.getGearInfo().tier().getChatFormatting());
        RenderUtils.drawTexturedRectWithColor(poseStack, Texture.HIGHLIGHT.resource(), color.withAlpha(1.0f), this.getX() - 1, this.getY() - 1, 0.0f, 18.0f, 18.0f, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderUtils.renderItem(guiGraphics, this.itemStack, this.getX(), this.getY());
        if (Services.Favorites.isFavorite(this.itemStack)) {
            RenderUtils.drawScalingTexturedRect(poseStack, Texture.FAVORITE_ICON.resource(), this.getX() + 12, this.getY() - 4, 200.0f, 9.0f, 9.0f, Texture.FAVORITE_ICON.width(), Texture.FAVORITE_ICON.height());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!KeyboardUtils.isKeyDown(340) && !KeyboardUtils.isKeyDown(344)) {
            return false;
        }
        String unformattedName = StyledText.fromComponent(this.itemStack.getHoverName()).getStringWithoutFormatting();
        if (button == 1) {
            Managers.Net.openLink(UrlId.LINK_WYNNCRAFT_ITEM_LOOKUP, Map.of("itemname", unformattedName));
            return true;
        }
        if (button == 0) {
            Services.Favorites.toggleFavorite(unformattedName);
        }
        return true;
    }

    public void onPress() {
    }

    public GuideGearItemStack getItemStack() {
        return this.itemStack;
    }
}

