/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.filters;

import com.google.common.collect.Lists;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public abstract class GuideFilterButton<T extends ItemStatProvider<?>>
extends AbstractWidget {
    protected final Texture texture;
    protected boolean state;

    protected GuideFilterButton(int x, int y, Texture texture) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.texture = texture;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawTexturedRect(guiGraphics.pose(), this.texture, this.getX(), this.getY());
        if (!this.isHovered && !this.state) {
            return;
        }
        RenderUtils.drawRect(guiGraphics.pose(), (this.state ? CommonColors.ORANGE : CommonColors.WHITE).withAlpha(this.isHovered ? 0.7f : 0.5f), this.getX(), this.getY(), 0.0f, this.getWidth(), this.getHeight());
        if (this.isHovered) {
            McUtils.screen().setTooltipForNextRenderPass(Lists.transform(ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.wynntilsGuides.filterWidget.tooltip", (Object[])new Object[]{this.getFilterName()})), 200), Component::getVisualOrderText));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.state = !this.state;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected abstract void updateStateFromQuery(ItemSearchQuery var1);

    protected abstract StatProviderAndFilterPair getFilterPair(T var1);

    protected abstract String getFilterName();

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

