/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.screens.base.widgets.ColorPickerWidget;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.maps.AbstractMapScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.screens.maps.widgets.IconButton;
import com.wynntils.services.map.PoiService;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public final class PoiCreationScreen
extends AbstractMapScreen {
    private static final Pattern COORDINATE_PATTERN = Pattern.compile("[-+]?\\d{1,8}");
    private static final float GRID_DIVISIONS = 64.0f;
    private static final int ICONS_PER_PAGE = 5;
    private final List<IconButton> iconButtons = new ArrayList<IconButton>();
    private Button saveButton;
    private TextInputBoxWidget nameInput;
    private TextInputBoxWidget xInput;
    private TextInputBoxWidget yInput;
    private TextInputBoxWidget zInput;
    private TextInputBoxWidget colorInput;
    private TextInputBoxWidget focusedTextInput;
    private float dividedWidth;
    private float dividedHeight;
    private final Screen returnScreen;
    private boolean firstSetup;
    private int iconScrollOffset = 0;
    private Location setupLocation;
    private CustomPoi oldPoi;
    private CustomColor colorCache = CommonColors.WHITE;
    private Integer parsedXInput;
    private Integer parsedYInput;
    private Integer parsedZInput;
    private Texture selectedIcon;
    private CustomPoi.Visibility selectedVisiblity = CustomPoi.Visibility.DEFAULT;

    private PoiCreationScreen(MainMapScreen oldMapScreen) {
        this.returnScreen = oldMapScreen;
        this.firstSetup = true;
    }

    private PoiCreationScreen(MainMapScreen oldMapScreen, Location setupLocation) {
        this(oldMapScreen);
        this.setupLocation = setupLocation;
        this.firstSetup = true;
    }

    private PoiCreationScreen(MainMapScreen oldMapScreen, CustomPoi poi) {
        this(oldMapScreen);
        this.oldPoi = poi;
        this.firstSetup = true;
    }

    private PoiCreationScreen(PoiManagementScreen managementScreen, CustomPoi poi) {
        this.returnScreen = managementScreen;
        this.oldPoi = poi;
        this.firstSetup = true;
    }

    public static Screen create(MainMapScreen oldMapScreen) {
        return new PoiCreationScreen(oldMapScreen);
    }

    public static Screen create(MainMapScreen oldMapScreen, Location setupLocation) {
        return new PoiCreationScreen(oldMapScreen, setupLocation);
    }

    public static Screen create(MainMapScreen oldMapScreen, CustomPoi poi) {
        return new PoiCreationScreen(oldMapScreen, poi);
    }

    public static Screen create(PoiManagementScreen managementScreen, CustomPoi poi) {
        return new PoiCreationScreen(managementScreen, poi);
    }

    @Override
    protected void doInit() {
        this.dividedWidth = (float)this.width / 64.0f;
        this.dividedHeight = (float)this.height / 64.0f;
        if (this.firstSetup) {
            this.updateMapCenter(McUtils.player().getBlockX(), McUtils.player().getBlockZ());
        }
        this.renderX = this.dividedWidth * 32.0f;
        this.renderWidth = this.dividedWidth * 29.0f;
        this.renderY = this.dividedHeight * 5.0f;
        this.renderHeight = this.dividedHeight * 54.0f;
        float borderScaleX = (float)this.width / (float)Texture.FULLSCREEN_MAP_BORDER.width();
        float borderScaleY = (float)this.height / (float)Texture.FULLSCREEN_MAP_BORDER.height();
        this.renderedBorderXOffset = 3.0f * borderScaleX;
        this.renderedBorderYOffset = 3.0f * borderScaleY;
        this.mapWidth = this.renderWidth - this.renderedBorderXOffset * 2.0f + 1.0f;
        this.centerX = this.renderX + this.renderedBorderXOffset + this.mapWidth / 2.0f;
        this.mapHeight = this.renderHeight - this.renderedBorderYOffset * 2.0f;
        this.centerZ = this.renderY + this.renderedBorderYOffset + this.mapHeight / 2.0f;
        this.nameInput = new TextInputBoxWidget((int)(this.dividedWidth * 4.0f), (int)(this.dividedHeight * 14.0f), (int)(this.dividedWidth * 12.0f), 20, s -> this.updateSaveStatus(), this, this.nameInput);
        this.addRenderableWidget((GuiEventListener)this.nameInput);
        if (this.oldPoi != null && this.firstSetup) {
            this.nameInput.setTextBoxInput(this.oldPoi.getName());
        }
        if (this.firstSetup) {
            this.setFocusedTextInput(this.nameInput);
        }
        this.colorInput = new TextInputBoxWidget((int)(this.dividedWidth * 19.0f), (int)(this.dividedHeight * 14.0f), (int)(this.dividedWidth * 6.0f), 20, s -> {
            CustomColor color = CustomColor.fromHexString(s);
            if (color == CustomColor.NONE) {
                this.colorCache = CommonColors.WHITE;
                this.colorInput.setRenderColor(CommonColors.RED);
            } else {
                this.colorCache = color;
                this.colorInput.setRenderColor(CommonColors.GREEN);
            }
            this.updateSaveStatus();
        }, this, this.colorInput);
        this.addRenderableWidget((GuiEventListener)this.colorInput);
        if (this.oldPoi != null && this.firstSetup) {
            this.colorInput.setTextBoxInput(String.valueOf(this.oldPoi.getColor().toHexString()));
        } else if (this.colorInput.getTextBoxInput().isEmpty()) {
            this.colorInput.setTextBoxInput("#FFFFFF");
        }
        this.addRenderableWidget((GuiEventListener)new ColorPickerWidget((int)(this.dividedWidth * 26.0f), (int)(this.dividedHeight * 14.0f), 20, 20, this.colorInput));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"<"), button -> {
            this.iconScrollOffset = this.iconScrollOffset - 1 < 0 ? PoiService.POI_ICONS.size() - 1 : --this.iconScrollOffset;
            this.populateIcons();
        }).pos((int)(this.dividedWidth * 8.0f), (int)(this.dividedHeight * 25.0f)).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)">"), button -> {
            this.iconScrollOffset = this.iconScrollOffset + 1 >= PoiService.POI_ICONS.size() ? 0 : ++this.iconScrollOffset;
            this.populateIcons();
        }).pos((int)(this.dividedWidth * 20.0f), (int)(this.dividedHeight * 25.0f)).size(20, 20).build());
        if (this.firstSetup) {
            if (this.oldPoi != null) {
                Optional<Texture> oldIcon = PoiService.POI_ICONS.stream().filter(icon -> icon == this.oldPoi.getIcon()).findFirst();
                oldIcon.ifPresent(icon -> {
                    this.selectedIcon = icon;
                });
                this.iconScrollOffset = PoiService.POI_ICONS.indexOf((Object)this.selectedIcon);
            } else {
                this.selectedIcon = PoiService.POI_ICONS.getFirst();
            }
        }
        this.xInput = new TextInputBoxWidget((int)this.dividedWidth, (int)(this.dividedHeight * 36.0f), (int)(this.dividedWidth * 7.0f), 20, s -> {
            if (COORDINATE_PATTERN.matcher((CharSequence)s).matches()) {
                this.parsedXInput = Integer.parseInt(s);
                this.xInput.setRenderColor(CommonColors.GREEN);
                if (this.parsedZInput != null) {
                    this.updateMapCenter(this.parsedXInput.intValue(), this.parsedZInput.intValue());
                }
            } else {
                this.parsedXInput = null;
                this.xInput.setRenderColor(CommonColors.RED);
            }
            this.updateSaveStatus();
        }, this, this.xInput);
        this.addRenderableWidget((GuiEventListener)this.xInput);
        this.yInput = new TextInputBoxWidget((int)(this.dividedWidth * 9.0f), (int)(this.dividedHeight * 36.0f), (int)(this.dividedWidth * 7.0f), 20, s -> {
            if (COORDINATE_PATTERN.matcher((CharSequence)s).matches()) {
                this.parsedYInput = Integer.parseInt(s);
                this.yInput.setRenderColor(CommonColors.GREEN);
            } else {
                this.parsedYInput = 0;
            }
            this.updateSaveStatus();
        }, this, this.yInput);
        this.addRenderableWidget((GuiEventListener)this.yInput);
        this.zInput = new TextInputBoxWidget((int)(this.dividedWidth * 17.0f), (int)(this.dividedHeight * 36.0f), (int)(this.dividedWidth * 7.0f), 20, s -> {
            if (COORDINATE_PATTERN.matcher((CharSequence)s).matches()) {
                this.parsedZInput = Integer.parseInt(s);
                this.zInput.setRenderColor(CommonColors.GREEN);
                if (this.parsedXInput != null) {
                    this.updateMapCenter(this.parsedXInput.intValue(), this.parsedZInput.intValue());
                }
            } else {
                this.parsedZInput = null;
                this.zInput.setRenderColor(CommonColors.RED);
            }
            this.updateSaveStatus();
        }, this, this.zInput);
        this.addRenderableWidget((GuiEventListener)this.zInput);
        if (this.firstSetup) {
            if (this.oldPoi != null) {
                this.xInput.setTextBoxInput(String.valueOf(this.oldPoi.getLocation().getX()));
                int yValue = this.oldPoi.getLocation().getY().isPresent() ? this.oldPoi.getLocation().getY().get() : 0;
                this.yInput.setTextBoxInput(String.valueOf(yValue));
                this.zInput.setTextBoxInput(String.valueOf(this.oldPoi.getLocation().getZ()));
            } else if (this.setupLocation != null) {
                this.xInput.setTextBoxInput(String.valueOf(this.setupLocation.x()));
                this.yInput.setTextBoxInput(String.valueOf(this.setupLocation.y()));
                this.zInput.setTextBoxInput(String.valueOf(this.setupLocation.z()));
            }
        }
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\ud83e\uddcd"), button -> {
            this.xInput.setTextBoxInput(String.valueOf(McUtils.player().getBlockX()));
            this.yInput.setTextBoxInput(String.valueOf(McUtils.player().getBlockY()));
            this.zInput.setTextBoxInput(String.valueOf(McUtils.player().getBlockZ()));
        }).pos((int)(this.dividedWidth * 26.0f), (int)(this.dividedHeight * 36.0f)).size(20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.poiCreation.centerPlayer"))).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\ud83c\udf0d"), button -> {
            this.xInput.setTextBoxInput(String.valueOf(-360));
            this.yInput.setTextBoxInput("0");
            this.zInput.setTextBoxInput(String.valueOf(-3000));
        }).pos((int)(this.dividedWidth * 29.0f), (int)(this.dividedHeight * 36.0f)).size(20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.poiCreation.centerWorld"))).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"<"), button -> {
            this.selectedVisiblity = CustomPoi.Visibility.values()[(this.selectedVisiblity.ordinal() - 1 + CustomPoi.Visibility.values().length) % CustomPoi.Visibility.values().length];
        }).pos((int)(this.dividedWidth * 8.0f), (int)(this.dividedHeight * 47.0f)).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)">"), button -> {
            this.selectedVisiblity = CustomPoi.Visibility.values()[(this.selectedVisiblity.ordinal() + 1 + CustomPoi.Visibility.values().length) % CustomPoi.Visibility.values().length];
        }).pos((int)(this.dividedWidth * 22.0f) - 19, (int)(this.dividedHeight * 47.0f)).size(20, 20).build());
        if (this.oldPoi != null && this.firstSetup) {
            this.selectedVisiblity = this.oldPoi.getVisibility();
        }
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiCreation.cancel"), button -> this.onClose()).pos((int)(this.dividedWidth * 6.0f), (int)(this.dividedHeight * 54.0f)).size((int)(this.dividedWidth * 8.0f), 20).build());
        this.saveButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiCreation.save"), button -> {
            this.savePoi();
            this.onClose();
        }).pos((int)(this.dividedWidth * 18.0f), (int)(this.dividedHeight * 54.0f)).size((int)(this.dividedWidth * 8.0f), 20).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        this.updateSaveStatus();
        this.populateIcons();
        this.firstSetup = false;
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBlurredBackground();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        this.renderMap(guiGraphics);
        RenderUtils.enableScissor(guiGraphics, (int)(this.renderX + this.renderedBorderXOffset), (int)(this.renderY + this.renderedBorderYOffset), (int)this.mapWidth, (int)this.mapHeight);
        if (this.parsedXInput != null && this.parsedZInput != null) {
            CustomPoi poi = new CustomPoi(new PoiLocation(this.parsedXInput, null, this.parsedZInput), this.nameInput.getTextBoxInput(), CustomColor.fromHexString(this.colorInput.getTextBoxInput()) == CustomColor.NONE ? CommonColors.WHITE : CustomColor.fromHexString(this.colorInput.getTextBoxInput()), this.selectedIcon, this.selectedVisiblity);
            MultiBufferSource.BufferSource bufferSource = McUtils.mc().renderBuffers().bufferSource();
            poi.renderAt(poseStack, (MultiBufferSource)bufferSource, MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale), MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale), this.hovered == poi, 1.0f, this.zoomRenderScale, this.zoomLevel, true);
            bufferSource.endBatch();
        }
        this.renderCursor(poseStack, 1.5f, (CustomColor)Managers.Feature.getFeatureInstance(MainMapFeature.class).pointerColor.get(), (PointerType)((Object)Managers.Feature.getFeatureInstance(MainMapFeature.class).pointerType.get()));
        RenderUtils.disableScissor(guiGraphics);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.poiCreation.waypointName", (Object[])new Object[0]) + ":"), (int)(this.dividedWidth * 4.0f), (int)(this.dividedHeight * 12.5f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("X:"), this.dividedWidth, this.dividedHeight * 34.5f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("Y:"), this.dividedWidth * 9.0f, this.dividedHeight * 34.5f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("Z:"), this.dividedWidth * 17.0f, this.dividedHeight * 34.5f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        this.renderIcons(guiGraphics, mouseX, mouseY, partialTick);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.poiCreation.color", (Object[])new Object[0]) + ":"), this.dividedWidth * 19.0f, (int)(this.dividedHeight * 12.5f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.poiCreation.visibility", (Object[])new Object[0]) + ":"), this.dividedWidth * 10.0f, this.dividedHeight * 45.5f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(I18n.get((String)this.selectedVisiblity.getTranslationKey(), (Object[])new Object[0])), this.dividedWidth * 15.0f, this.dividedWidth * 15.0f, this.dividedHeight * 47.0f, this.dividedHeight * 47.0f + 20.0f, 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void setSelectedIcon(Texture selectedIcon) {
        this.selectedIcon = selectedIcon;
        this.populateIcons();
        this.updateSaveStatus();
    }

    private void renderIcons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (IconButton iconButton : this.iconButtons) {
            iconButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (button == 2) {
            int gameX = (int)((mouseX - (double)this.centerX) / (double)this.zoomRenderScale + (double)this.mapCenterX);
            int gameZ = (int)((mouseY - (double)this.centerZ) / (double)this.zoomRenderScale + (double)this.mapCenterZ);
            this.xInput.setTextBoxInput(String.valueOf(gameX));
            this.zInput.setTextBoxInput(String.valueOf(gameZ));
        }
        for (IconButton iconButton : this.iconButtons) {
            if (!iconButton.isMouseOver(mouseX, mouseY)) continue;
            return iconButton.mouseClicked(mouseX, mouseY, button);
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        return this.focusedTextInput != null && this.focusedTextInput.charTyped(codePoint, modifiers) || super.charTyped(codePoint, modifiers);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            Object e;
            int actualIndex;
            int i;
            int index = this.focusedTextInput == null ? 0 : this.children().indexOf((Object)this.focusedTextInput);
            for (i = actualIndex = Math.max(index, 0) + 1; i < this.children().size(); ++i) {
                e = this.children().get(i);
                if (!(e instanceof TextInputBoxWidget)) continue;
                TextInputBoxWidget textInputBoxWidget = (TextInputBoxWidget)((Object)e);
                this.setFocusedTextInput(textInputBoxWidget);
                return true;
            }
            for (i = 0; i < Math.min(actualIndex, this.children().size()); ++i) {
                e = this.children().get(i);
                if (!(e instanceof TextInputBoxWidget)) continue;
                TextInputBoxWidget textInputBoxWidget = (TextInputBoxWidget)((Object)e);
                this.setFocusedTextInput(textInputBoxWidget);
                return true;
            }
        }
        return this.focusedTextInput != null && this.focusedTextInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public TextInputBoxWidget getFocusedTextInput() {
        return this.focusedTextInput;
    }

    @Override
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
        this.focusedTextInput = focusedTextInput;
    }

    public void onClose() {
        McUtils.setScreen(this.returnScreen);
    }

    private void updateSaveStatus() {
        if (this.saveButton == null) {
            return;
        }
        this.saveButton.active = !this.nameInput.getTextBoxInput().isBlank() && CustomColor.fromHexString(this.colorInput.getTextBoxInput()) != CustomColor.NONE && COORDINATE_PATTERN.matcher(this.xInput.getTextBoxInput()).matches() && (COORDINATE_PATTERN.matcher(this.yInput.getTextBoxInput()).matches() || this.yInput.getTextBoxInput().isEmpty()) && COORDINATE_PATTERN.matcher(this.zInput.getTextBoxInput()).matches();
    }

    private void savePoi() {
        CustomPoi poi = new CustomPoi(new PoiLocation(Integer.parseInt(this.xInput.getTextBoxInput()), this.yInput.getTextBoxInput().isEmpty() ? 0 : Integer.parseInt(this.yInput.getTextBoxInput()), Integer.parseInt(this.zInput.getTextBoxInput())), this.nameInput.getTextBoxInput(), CustomColor.fromHexString(this.colorInput.getTextBoxInput()), this.selectedIcon, this.selectedVisiblity);
        HiddenConfig<List<CustomPoi>> customPoiConfig = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        List customPois = (List)customPoiConfig.get();
        if (this.oldPoi != null) {
            customPois.set(customPois.indexOf(this.oldPoi), poi);
        } else {
            customPois.add(poi);
        }
        customPoiConfig.touched();
        Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
    }

    private void populateIcons() {
        this.iconButtons.clear();
        int numIcons = PoiService.POI_ICONS.size();
        int totalWidth = (int)(this.dividedWidth * 20.0f) - (int)(this.dividedWidth * 8.0f + 20.0f);
        int buttonWidth = totalWidth / 5;
        int i = 0;
        while (true) {
            if (i >= Math.min(PoiService.POI_ICONS.size(), 5)) break;
            int iconIndex = (this.iconScrollOffset + i) % numIcons;
            Texture currentIcon = PoiService.POI_ICONS.get(iconIndex);
            int xPos = (int)(this.dividedWidth * 8.0f) + 20 + i * buttonWidth;
            IconButton iconButton = new IconButton(xPos, (int)(this.dividedHeight * 25.0f), buttonWidth, currentIcon, currentIcon == this.selectedIcon);
            this.iconButtons.add(iconButton);
            ++i;
        }
    }
}

