/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.overlays.placement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.Corner;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.Edge;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.consumers.overlays.SectionCoordinates;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;

public final class OverlayManagementScreen
extends WynntilsScreen {
    private static final int ALIGNMENT_LINES_MAX_SECTIONS_PER_AXIS = 4;
    private static final int ALIGNMENT_SNAP_DISTANCE = 1;
    private static final double ALIGNMENT_SNAP_HARDNESS = 6.0;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_SHORT_WIDTH = 20;
    private static final int BUTTON_HEIGHT = 20;
    private static final int MAX_CLICK_DISTANCE = 5;
    private static final int ANIMATION_LENGTH = 30;
    private static final List<Component> HELP_TOOLTIP_LINES = ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.overlayManagement.helpTooltip1"), Component.translatable((String)"screens.wynntils.overlayManagement.helpTooltip2"), Component.translatable((String)"screens.wynntils.overlayManagement.helpTooltip3"), Component.translatable((String)"screens.wynntils.overlayManagement.helpTooltip4"), Component.translatable((String)"screens.wynntils.overlayManagement.helpTooltip5"), Component.translatable((String)"screens.wynntils.overlayManagement.helpTooltip6").withStyle(ChatFormatting.RED)), 200);
    private final Set<Float> verticalAlignmentLinePositions = new HashSet<Float>();
    private final Set<Float> horizontalAlignmentLinePositions = new HashSet<Float>();
    private final Map<Edge, Double> edgeAlignmentSnapMap = new EnumMap<Edge, Double>(Edge.class);
    private final Map<Edge, Float> alignmentLinesToRender = new EnumMap<Edge, Float>(Edge.class);
    private SelectionMode selectionMode = SelectionMode.NONE;
    private Overlay selectedOverlay;
    private final boolean fixedSelection;
    private Corner selectedCorner = null;
    private Edge selectedEdge = null;
    private boolean buttonsAtBottom = true;
    private boolean renderAllOverlays;
    private boolean showPreview = true;
    private boolean snappingEnabled = true;
    private boolean userInteracted = false;
    private int animationLengthRemaining;
    private double snapOffsetX;
    private double snapOffsetY;
    private final Screen previousScreen;

    private OverlayManagementScreen(Screen previousScreen, Overlay overlay) {
        super((Component)Component.translatable((String)"screens.wynntils.overlayManagement.name"));
        this.previousScreen = previousScreen;
        this.selectedOverlay = overlay;
        this.fixedSelection = true;
        this.renderAllOverlays = false;
        this.animationLengthRemaining = 30;
    }

    private OverlayManagementScreen(Screen previousScreen) {
        super((Component)Component.translatable((String)"screens.wynntils.overlayManagement.name"));
        this.previousScreen = previousScreen;
        this.selectedOverlay = null;
        this.fixedSelection = false;
        this.renderAllOverlays = true;
        this.animationLengthRemaining = 0;
    }

    public static Screen create(Screen previousScreen) {
        return new OverlayManagementScreen(previousScreen);
    }

    public static Screen create(Screen previousScreen, Overlay overlay) {
        return new OverlayManagementScreen(previousScreen, overlay);
    }

    @Override
    protected void doInit() {
        this.setupButtons();
        this.calculateAlignmentLinePositions();
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        if (this.selectionMode != SelectionMode.NONE) {
            this.renderAlignmentLines(poseStack);
        } else {
            this.renderSections(poseStack);
        }
        Set overlays = Managers.Overlay.getOverlays().stream().filter(Managers.Overlay::isEnabled).collect(Collectors.toSet());
        boolean renderedTooltip = false;
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver((double)mouseX, (double)mouseY)) continue;
            renderedTooltip = true;
            break;
        }
        for (Overlay overlay : overlays) {
            CustomNameProperty customNameProperty;
            if (!this.renderAllOverlays && overlay != this.selectedOverlay) continue;
            CustomColor color = this.getOverlayColor(overlay);
            RenderUtils.drawRectBorders(poseStack, color, overlay.getRenderX(), overlay.getRenderY(), overlay.getRenderX() + overlay.getWidth(), overlay.getRenderY() + overlay.getHeight(), 1.0f, 1.8f);
            int colorAlphaRect = this.fixedSelection && overlay == this.selectedOverlay ? (int)Math.max(MathUtils.map(this.animationLengthRemaining, 0.0f, 30.0f, 30.0f, 255.0f), 30.0f) : 30;
            RenderUtils.drawRect(poseStack, color.withAlpha(colorAlphaRect), overlay.getRenderX(), overlay.getRenderY(), 0.0f, overlay.getWidth(), overlay.getHeight());
            String overlayName = overlay.getTranslatedName();
            if (overlay instanceof CustomNameProperty && !((String)(customNameProperty = (CustomNameProperty)((Object)overlay)).getCustomName().get()).isEmpty()) {
                overlayName = (String)customNameProperty.getCustomName().get();
            }
            if (!this.showPreview) {
                float yOffset = switch (overlay.getRenderVerticalAlignment()) {
                    default -> throw new MatchException(null, null);
                    case VerticalAlignment.TOP -> 1.8f;
                    case VerticalAlignment.MIDDLE -> 0.0f;
                    case VerticalAlignment.BOTTOM -> -1.8f;
                };
                float xOffset = switch (overlay.getRenderHorizontalAlignment()) {
                    default -> throw new MatchException(null, null);
                    case HorizontalAlignment.LEFT -> 1.8f;
                    case HorizontalAlignment.CENTER -> 0.0f;
                    case HorizontalAlignment.RIGHT -> -1.8f;
                };
                float renderX = overlay.getRenderX() + xOffset;
                float renderY = overlay.getRenderY() + yOffset;
                FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(overlayName), renderX, renderX + overlay.getWidth(), renderY, renderY + overlay.getHeight(), overlay.getWidth(), color, overlay.getRenderHorizontalAlignment(), overlay.getRenderVerticalAlignment(), TextShadow.OUTLINE);
            }
            if (!renderedTooltip && !this.fixedSelection && this.showPreview && overlay != this.selectedOverlay && this.isMouseHoveringOverlay(overlay, mouseX, mouseY) && this.selectionMode == SelectionMode.NONE) {
                McUtils.screen().setTooltipForNextRenderPass(Lists.transform(List.of(Component.literal((String)overlayName)), Component::getVisualOrderText));
                renderedTooltip = true;
                continue;
            }
            if (renderedTooltip || overlay != this.selectedOverlay || !this.isMouseHoveringOverlay(overlay, mouseX, mouseY) || this.selectionMode != SelectionMode.NONE) continue;
            McUtils.screen().setTooltipForNextRenderPass(Lists.transform(HELP_TOOLTIP_LINES, Component::getVisualOrderText));
            renderedTooltip = true;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void tick() {
        if (this.userInteracted) {
            return;
        }
        if (this.animationLengthRemaining <= 0) {
            this.animationLengthRemaining = 30;
        }
        --this.animationLengthRemaining;
    }

    public void onClose() {
        this.reloadConfigForOverlay();
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (super.doMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        this.userInteracted = true;
        this.animationLengthRemaining = 0;
        this.resetSelection();
        if (!this.fixedSelection && this.renderAllOverlays) {
            Set overlays = Managers.Overlay.getOverlays().stream().filter(Managers.Overlay::isEnabled).collect(Collectors.toSet());
            for (Overlay overlay : overlays) {
                if (!this.isMouseHoveringOverlay(overlay, mouseX, mouseY)) continue;
                this.selectedOverlay = overlay;
                break;
            }
        }
        if (this.selectedOverlay == null) {
            return false;
        }
        Overlay selected = this.selectedOverlay;
        this.setupButtons();
        if (button == 2 && KeyboardUtils.isShiftDown()) {
            this.selectedOverlay.getConfigOptionFromString("position").ifPresent(Config::reset);
            this.selectedOverlay.getConfigOptionFromString("size").ifPresent(Config::reset);
            this.selectedOverlay.getConfigOptionFromString("horizontalAlignmentOverride").ifPresent(Config::reset);
            this.selectedOverlay.getConfigOptionFromString("verticalAlignmentOverride").ifPresent(Config::reset);
            return true;
        }
        Vec2 mousePos = new Vec2((float)mouseX, (float)mouseY);
        for (Corner corner : Corner.values()) {
            float distance = selected.getCornerPoints(corner).distanceToSqr(mousePos);
            if (!(distance < 5.0f)) continue;
            this.selectedCorner = corner;
            this.selectionMode = SelectionMode.CORNER;
            return false;
        }
        block8: for (Enum enum_ : Edge.values()) {
            float maxY;
            float minY;
            float maxX;
            float minX;
            switch (1.$SwitchMap$com$wynntils$core$consumers$overlays$Edge[enum_.ordinal()]) {
                case 1: {
                    minX = selected.getRenderX();
                    maxX = selected.getRenderX() + selected.getWidth();
                    minY = selected.getRenderY() - 2.5f;
                    maxY = selected.getRenderY() + 2.5f;
                    break;
                }
                case 2: {
                    minX = selected.getRenderX() - 2.5f;
                    maxX = selected.getRenderX() + 2.5f;
                    minY = selected.getRenderY();
                    maxY = selected.getRenderY() + selected.getHeight();
                    break;
                }
                case 3: {
                    minX = selected.getRenderX() + selected.getWidth() - 2.5f;
                    maxX = selected.getRenderX() + selected.getWidth() + 2.5f;
                    minY = selected.getRenderY();
                    maxY = selected.getRenderY() + selected.getHeight();
                    break;
                }
                case 4: {
                    minX = selected.getRenderX();
                    maxX = selected.getRenderX() + selected.getWidth();
                    minY = selected.getRenderY() + selected.getHeight() - 2.5f;
                    maxY = selected.getRenderY() + selected.getHeight() + 2.5f;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (!(mouseX >= (double)minX) || !(mouseX <= (double)maxX) || !(mouseY >= (double)minY) || !(mouseY <= (double)maxY)) continue;
            this.selectedEdge = enum_;
            this.selectionMode = SelectionMode.EDGE;
            return false;
        }
        if (this.isMouseHoveringOverlay(this.selectedOverlay, mouseX, mouseY)) {
            this.selectionMode = SelectionMode.AREA;
            return false;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.selectedOverlay == null) {
            return false;
        }
        switch (this.selectionMode.ordinal()) {
            case 1: {
                this.handleOverlayCornerDrag(dragX, dragY);
                break;
            }
            case 2: {
                this.handleOverlayEdgeDrag(dragX, dragY);
                break;
            }
            case 3: {
                this.handleOverlayBodyDrag(dragX, dragY);
                break;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        this.resetSelection();
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.userInteracted = true;
        this.animationLengthRemaining = 0;
        if (keyCode == 257) {
            Managers.Config.saveConfig();
            this.onClose();
            McUtils.setScreen(this.previousScreen);
            return true;
        }
        if (keyCode == 256) {
            this.onClose();
            McUtils.setScreen(this.previousScreen);
            return true;
        }
        if (this.selectedOverlay == null) {
            return false;
        }
        if (KeyboardUtils.isShiftDown()) {
            if (keyCode == 265 || keyCode == 264) {
                int index = this.selectedOverlay.getRenderVerticalAlignment().ordinal();
                index = keyCode == 264 ? ++index : --index;
                VerticalAlignment[] values = VerticalAlignment.values();
                int finalIndex = index = (values.length + index) % values.length;
                this.selectedOverlay.getConfigOptionFromString("verticalAlignmentOverride").ifPresent(config -> config.setValue(values[finalIndex]));
            } else if (keyCode == 262 || keyCode == 263) {
                int index = this.selectedOverlay.getRenderHorizontalAlignment().ordinal();
                index = keyCode == 262 ? ++index : --index;
                HorizontalAlignment[] values = HorizontalAlignment.values();
                int finalIndex = index = (values.length + index) % values.length;
                this.selectedOverlay.getConfigOptionFromString("horizontalAlignmentOverride").ifPresent(config -> config.setValue(values[finalIndex]));
            }
        } else {
            int offsetX = 0;
            int offsetY = 0;
            if (keyCode == 265) {
                offsetY = -1;
            } else if (keyCode == 264) {
                offsetY = 1;
            } else if (keyCode == 262) {
                offsetX = 1;
            } else if (keyCode == 263) {
                offsetX = -1;
            }
            int finalOffsetX = offsetX;
            int finalOffsetY = offsetY;
            this.selectedOverlay.getConfigOptionFromString("position").ifPresent(config -> config.setValue(OverlayPosition.getBestPositionFor(this.selectedOverlay, this.selectedOverlay.getRenderX(), this.selectedOverlay.getRenderY(), finalOffsetX, finalOffsetY)));
        }
        if (keyCode == 340 || keyCode == 344) {
            this.snappingEnabled = false;
            this.edgeAlignmentSnapMap.clear();
            this.alignmentLinesToRender.clear();
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            this.snappingEnabled = true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public Overlay getSelectedOverlay() {
        return this.selectedOverlay;
    }

    public boolean shouldRenderAllOverlays() {
        return this.renderAllOverlays;
    }

    public boolean showPreview() {
        return this.showPreview;
    }

    private CustomColor getOverlayColor(Overlay overlay) {
        if (overlay == this.selectedOverlay) {
            return CommonColors.GREEN;
        }
        return this.fixedSelection ? new CustomColor(200, 200, 200, 255) : CommonColors.LIGHT_BLUE;
    }

    private boolean isMouseHoveringOverlay(Overlay overlay, double mouseX, double mouseY) {
        if (overlay == null) {
            return false;
        }
        return (double)overlay.getRenderX() <= mouseX && (double)(overlay.getRenderX() + overlay.getWidth()) >= mouseX && (double)overlay.getRenderY() <= mouseY && (double)(overlay.getRenderY() + overlay.getHeight()) >= mouseY;
    }

    private void reloadConfigForOverlay() {
        Managers.Config.reloadConfiguration(true);
    }

    private void handleOverlayEdgeDrag(double dragX, double dragY) {
        if (this.selectedEdge == null || this.selectedOverlay == null) {
            return;
        }
        Pair<Double, Double> newDrag = this.calculateDragAfterSnapping(dragX, dragY);
        dragX = newDrag.a();
        dragY = newDrag.b();
        Overlay overlay = this.selectedOverlay;
        Edge edge = this.selectedEdge;
        OverlaySize overlaySize = overlay.getSize();
        float renderX = overlay.getRenderX();
        float renderY = overlay.getRenderY();
        switch (edge) {
            case TOP: {
                overlay.setHeight((float)((double)overlaySize.getHeight() - dragY));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, 0.0f, (float)dragY));
                break;
            }
            case LEFT: {
                overlay.setWidth((float)((double)overlaySize.getWidth() - dragX));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, (float)dragX, 0.0f));
                break;
            }
            case RIGHT: {
                overlay.setWidth((float)((double)overlaySize.getWidth() + dragX));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, 0.0f, 0.0f));
                break;
            }
            case BOTTOM: {
                overlay.setHeight((float)((double)overlaySize.getHeight() + dragY));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, 0.0f, 0.0f));
            }
        }
    }

    private void handleOverlayBodyDrag(double dragX, double dragY) {
        if (this.selectedOverlay == null) {
            return;
        }
        Pair<Double, Double> newDrag = this.calculateDragAfterSnapping(dragX, dragY);
        dragX = newDrag.a();
        dragY = newDrag.b();
        Overlay overlay = this.selectedOverlay;
        overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, overlay.getRenderX(), overlay.getRenderY(), (float)dragX, (float)dragY));
    }

    private void handleOverlayCornerDrag(double dragX, double dragY) {
        if (this.selectedCorner == null || this.selectedOverlay == null) {
            return;
        }
        Pair<Double, Double> newDrag = this.calculateDragAfterSnapping(dragX, dragY);
        dragX = newDrag.a();
        dragY = newDrag.b();
        Overlay overlay = this.selectedOverlay;
        Corner corner = this.selectedCorner;
        OverlaySize overlaySize = overlay.getSize();
        float renderX = overlay.getRenderX();
        float renderY = overlay.getRenderY();
        switch (corner) {
            case TOP_LEFT: {
                overlay.setWidth((float)((double)overlaySize.getWidth() - dragX));
                overlay.setHeight((float)((double)overlaySize.getHeight() - dragY));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, (float)dragX, (float)dragY));
                break;
            }
            case TOP_RIGHT: {
                overlay.setWidth((float)((double)overlaySize.getWidth() + dragX));
                overlay.setHeight((float)((double)overlaySize.getHeight() - dragY));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, 0.0f, (float)dragY));
                break;
            }
            case BOTTOM_LEFT: {
                overlay.setWidth((float)((double)overlaySize.getWidth() - dragX));
                overlay.setHeight((float)((double)overlaySize.getHeight() + dragY));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, (float)dragX, 0.0f));
                break;
            }
            case BOTTOM_RIGHT: {
                overlay.setWidth((float)((double)overlaySize.getWidth() + dragX));
                overlay.setHeight((float)((double)overlaySize.getHeight() + dragY));
                overlay.setPosition(OverlayPosition.getBestPositionFor(overlay, renderX, renderY, 0.0f, 0.0f));
            }
        }
    }

    private Pair<Double, Double> calculateDragAfterSnapping(double dragX, double dragY) {
        if (!this.snappingEnabled) {
            return new Pair<Double, Double>(dragX, dragY);
        }
        double originalDragX = dragX += this.snapOffsetX;
        double originalDragY = dragY += this.snapOffsetY;
        List edgesToSnapTo = switch (this.selectionMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> List.of();
            case 1 -> this.selectedCorner.getEdges();
            case 2 -> List.of(this.selectedEdge);
            case 3 -> Arrays.stream(Edge.values()).toList();
        };
        double originalX = dragX;
        double originalY = dragY;
        block6: for (Edge edge2 : edgesToSnapTo.stream().filter(edge -> !this.edgeAlignmentSnapMap.containsKey(edge)).toList()) {
            Pair<Vec2, Vec2> edgePos = edge2.getEdgePos(this.selectedOverlay);
            if (edge2.isVerticalLine()) {
                for (Float alignmentLinePosition : this.verticalAlignmentLinePositions) {
                    if (!(Math.abs((float)this.width * alignmentLinePosition.floatValue() - edgePos.a().x) < 1.0f)) continue;
                    this.edgeAlignmentSnapMap.put(edge2, 6.0);
                    this.alignmentLinesToRender.put(edge2, alignmentLinePosition);
                    continue block6;
                }
                continue;
            }
            for (Float alignmentLinePosition : this.horizontalAlignmentLinePositions) {
                if (!(Math.abs((float)this.height * alignmentLinePosition.floatValue() - edgePos.a().y) < 1.0f)) continue;
                this.edgeAlignmentSnapMap.put(edge2, 6.0);
                this.alignmentLinesToRender.put(edge2, alignmentLinePosition);
                continue block6;
            }
        }
        HashSet<Edge> toBeRemoved = new HashSet<Edge>();
        for (Map.Entry<Edge, Double> entry : this.edgeAlignmentSnapMap.entrySet()) {
            double newSnapValue;
            if (entry.getKey().isVerticalLine()) {
                newSnapValue = entry.getValue() - Math.abs(dragX);
                dragX = 0.0;
            } else {
                newSnapValue = entry.getValue() - Math.abs(dragY);
                dragY = 0.0;
            }
            if (newSnapValue <= 0.0) {
                toBeRemoved.add(entry.getKey());
                if (entry.getKey().isVerticalLine()) {
                    dragX = originalX;
                    continue;
                }
                dragY = originalY;
                continue;
            }
            this.edgeAlignmentSnapMap.put(entry.getKey(), newSnapValue);
        }
        for (Edge edge3 : toBeRemoved) {
            this.edgeAlignmentSnapMap.remove((Object)edge3);
            this.alignmentLinesToRender.remove((Object)edge3);
        }
        this.snapOffsetX = originalDragX - dragX;
        this.snapOffsetY = originalDragY - dragY;
        return new Pair<Double, Double>(dragX, dragY);
    }

    private void renderSections(PoseStack poseStack) {
        for (SectionCoordinates section : Managers.Overlay.getSections()) {
            RenderUtils.drawRectBorders(poseStack, CommonColors.WHITE, section.x1(), section.y1(), section.x2(), section.y2(), 0.0f, 1.0f);
        }
    }

    private void renderAlignmentLines(PoseStack poseStack) {
        for (Map.Entry<Edge, Float> entry : this.alignmentLinesToRender.entrySet()) {
            if (entry.getKey().isVerticalLine()) {
                RenderUtils.drawLine(poseStack, CommonColors.ORANGE, (float)this.width * entry.getValue().floatValue(), 0.0f, (float)this.width * entry.getValue().floatValue(), this.height, 1.0f, 1.0f);
                continue;
            }
            RenderUtils.drawLine(poseStack, CommonColors.ORANGE, 0.0f, (float)this.height * entry.getValue().floatValue(), this.width, (float)this.height * entry.getValue().floatValue(), 1.0f, 1.0f);
        }
    }

    private void calculateAlignmentLinePositions() {
        this.verticalAlignmentLinePositions.clear();
        this.horizontalAlignmentLinePositions.clear();
        this.verticalAlignmentLinePositions.add(Float.valueOf(0.0f));
        this.horizontalAlignmentLinePositions.add(Float.valueOf(0.0f));
        this.verticalAlignmentLinePositions.add(Float.valueOf(1.0f));
        this.horizontalAlignmentLinePositions.add(Float.valueOf(1.0f));
        for (int i = 2; i <= 4; ++i) {
            for (int j = 1; j < i; ++j) {
                this.verticalAlignmentLinePositions.add(Float.valueOf((float)j / (float)i));
                this.horizontalAlignmentLinePositions.add(Float.valueOf((float)j / (float)i));
            }
        }
        for (Overlay overlay : Managers.Overlay.getOverlays().stream().filter(Managers.Overlay::isEnabled).toList()) {
            if (overlay == this.selectedOverlay) continue;
            for (Edge edge : Edge.values()) {
                Pair<Vec2, Vec2> edgePos = edge.getEdgePos(overlay);
                if (edge.isVerticalLine()) {
                    this.verticalAlignmentLinePositions.add(Float.valueOf(edgePos.a().x / (float)this.width));
                    continue;
                }
                this.horizontalAlignmentLinePositions.add(Float.valueOf(edgePos.a().y / (float)this.height));
            }
        }
    }

    private void setupButtons() {
        this.children.stream().toList().forEach(arg_0 -> ((OverlayManagementScreen)this).removeWidget(arg_0));
        int yPos = this.buttonsAtBottom ? this.height - 25 : 5;
        this.addRenderableWidget((GuiEventListener)new WynntilsCheckbox(this.width / 2 - 60 - 12 - 100, yPos, 20, (Component)Component.translatable((String)"screens.wynntils.overlayManagement.showPreview"), this.showPreview, 80, (c, b) -> {
            this.showPreview = !this.showPreview;
        }, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.overlayManagement.showPreviewTooltip")), 150)));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.overlayManagement.close"), button -> {
            this.onClose();
            McUtils.setScreen(this.previousScreen);
        }).pos(this.width / 2 - 60 - 12, yPos).size(60, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.overlayManagement.closeTooltip"))).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)(this.buttonsAtBottom ? Component.literal((String)"\ud83e\udc1d") : Component.literal((String)"\ud83e\udc1f")), button -> {
            this.buttonsAtBottom = !this.buttonsAtBottom;
            this.setupButtons();
        }).pos(this.width / 2 - 10, yPos).size(20, 20).tooltip(Tooltip.create((Component)(this.buttonsAtBottom ? Component.translatable((String)"screens.wynntils.overlayManagement.moveButtonsUpTooltip") : Component.translatable((String)"screens.wynntils.overlayManagement.moveButtonsDownTooltip")))).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.overlayManagement.apply"), button -> {
            Managers.Config.saveConfig();
            this.onClose();
            McUtils.setScreen(this.previousScreen);
        }).pos(this.width / 2 + 12, yPos).size(60, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.overlayManagement.applyTooltip"))).build());
        if (this.selectedOverlay != null) {
            this.addRenderableWidget((GuiEventListener)new WynntilsCheckbox(this.width / 2 + 12 + 60 + 10, yPos, 20, (Component)Component.translatable((String)"screens.wynntils.overlayManagement.showOthers"), this.renderAllOverlays, 120, (c, b) -> {
                this.renderAllOverlays = b;
            }, ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.overlayManagement.showOthersTooltip")), 150)));
        }
    }

    private void resetSelection() {
        this.selectionMode = SelectionMode.NONE;
        this.selectedCorner = null;
        this.selectedEdge = null;
    }

    private static enum SelectionMode {
        NONE,
        CORNER,
        EDGE,
        AREA;

    }
}

