/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.overlays.selection;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.persisted.config.OverlayGroupHolder;
import com.wynntils.features.overlays.CustomBarsOverlayFeature;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.BarTexture;
import com.wynntils.utils.render.type.HealthTexture;
import com.wynntils.utils.render.type.ManaTexture;
import com.wynntils.utils.render.type.ObjectivesTextures;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.type.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public final class CustomBarSelectionScreen
extends WynntilsScreen {
    private static final List<Pair<Texture, List<BarTexture>>> availableBars = List.of(Pair.of(Texture.UNIVERSAL_BAR, List.of(UniversalTexture.values())), Pair.of(Texture.HEALTH_BAR, List.of(HealthTexture.values())), Pair.of(Texture.MANA_BAR, List.of(ManaTexture.values())), Pair.of(Texture.EXPERIENCE_BAR, List.of(ObjectivesTextures.values())), Pair.of(Texture.BUBBLE_BAR, List.of(ObjectivesTextures.values())));
    private final OverlaySelectionScreen previousScreen;
    private Button textureButton;
    private float barX;
    private float barY;
    private int barTextureIndex = 0;
    private int barTypeIndex = 0;

    private CustomBarSelectionScreen(OverlaySelectionScreen previousScreen) {
        super((Component)Component.translatable((String)"screens.wynntils.customBarSelection.name"));
        this.previousScreen = previousScreen;
    }

    public static Screen create(OverlaySelectionScreen previousScreen) {
        return new CustomBarSelectionScreen(previousScreen);
    }

    @Override
    protected void doInit() {
        this.calculateBarPosition();
        this.textureButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).toString()), b -> {}).pos((int)((float)this.width / 2.0f - 30.0f), (int)(this.barY + 20.0f)).size(60, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.customBarSelection.textureTooltip"))).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\ud83e\udc1c"), button -> this.scrollBars(-1)).pos((int)((float)this.width / 2.0f) - 120, (int)(this.barY + 45.0f)).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.customBarSelection.cancel"), button -> this.onClose()).pos((int)((float)this.width / 2.0f) - 90, (int)(this.barY + 45.0f)).size(80, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.customBarSelection.select"), button -> this.addCustomBar()).pos((int)((float)this.width / 2.0f) + 10, (int)(this.barY + 45.0f)).size(80, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\ud83e\udc1e"), button -> this.scrollBars(1)).pos((int)((float)this.width / 2.0f) + 100, (int)(this.barY + 45.0f)).size(20, 20).build());
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        BufferedRenderUtils.drawProgressBar(poseStack, (MultiBufferSource)guiGraphics.bufferSource, availableBars.get(this.barTypeIndex).a(), this.barX, this.barY, this.barX + (float)availableBars.get(this.barTypeIndex).a().width(), this.barY + (float)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getHeight(), 0, availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getTextureY1(), availableBars.get(this.barTypeIndex).a().width(), availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getTextureY2(), 0.5f);
    }

    public void onClose() {
        McUtils.setScreen(this.previousScreen);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            if (listener == this.textureButton) {
                if (button == 0) {
                    this.scrollTextures(1);
                    McUtils.playSoundUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
                    return true;
                }
                if (button == 1) {
                    this.scrollTextures(-1);
                    McUtils.playSoundUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
                    return true;
                }
                return false;
            }
            return listener.mouseClicked(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scrollBars((int)scrollValue);
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void calculateBarPosition() {
        this.barX = (float)(this.width - availableBars.get(this.barTypeIndex).a().width()) / 2.0f;
        this.barY = (float)(this.height - availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getHeight()) / 2.0f;
    }

    private void scrollBars(int direction) {
        this.barTypeIndex = this.barTypeIndex + direction > availableBars.size() - 1 ? 0 : (this.barTypeIndex + direction < 0 ? availableBars.size() - 1 : (this.barTypeIndex += direction));
        this.barTextureIndex = 0;
        this.textureButton.setMessage((Component)Component.literal((String)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).toString()));
        this.calculateBarPosition();
    }

    private void scrollTextures(int direction) {
        this.barTextureIndex = this.barTextureIndex + direction > availableBars.get(this.barTypeIndex).b().size() - 1 ? 0 : (this.barTextureIndex + direction < 0 ? availableBars.get(this.barTypeIndex).b().size() - 1 : (this.barTextureIndex += direction));
        this.textureButton.setMessage((Component)Component.literal((String)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).toString()));
        this.calculateBarPosition();
    }

    private void addCustomBar() {
        CustomBarsOverlayFeature customBarsFeature = Managers.Feature.getFeatureInstance(CustomBarsOverlayFeature.class);
        List<OverlayGroupHolder> groupHolders = Managers.Overlay.getFeatureOverlayGroups(customBarsFeature);
        OverlayGroupHolder barGroup = groupHolders.get(this.barTypeIndex);
        int id = Managers.Overlay.extendOverlayGroup(barGroup);
        Managers.Config.reloadConfiguration(false);
        Managers.Config.saveConfig();
        Managers.Config.reloadConfiguration(true);
        this.previousScreen.populateOverlays();
        this.previousScreen.selectOverlay(barGroup.getOverlays().getLast());
        McUtils.sendMessageToClient((Component)Component.translatable((String)"screens.wynntils.overlaySelection.createdOverlay", (Object[])new Object[]{barGroup.getOverlayClass().getSimpleName(), barGroup.getFieldName(), id}).withStyle(ChatFormatting.GREEN));
        this.onClose();
    }
}

