/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.overlays.selection.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.text.StyledText;
import com.wynntils.overlays.custombars.CustomBarOverlayBase;
import com.wynntils.overlays.infobox.InfoBoxOverlay;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class OverlayButton
extends WynntilsButton {
    private static final CustomColor ENABLED_COLOR = new CustomColor(0, 220, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER = new CustomColor(0, 116, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER_HOVERED = new CustomColor(0, 66, 0, 255);
    private static final CustomColor DISABLED_COLOR = new CustomColor(0, 0, 0, 255);
    private static final CustomColor DISABLED_COLOR_BORDER = new CustomColor(60, 60, 60, 255);
    private static final CustomColor DISABLED_COLOR_BORDER_HOVERED = new CustomColor(10, 10, 10, 255);
    private static final CustomColor DISABLED_FEATURE_COLOR = new CustomColor(255, 0, 0, 255);
    private static final CustomColor DISABLED_FEATURE_COLOR_BORDER = new CustomColor(120, 0, 0, 255);
    private static final CustomColor DISABLED_FEATURE_COLOR_BORDER_HOVERED = new CustomColor(70, 0, 0, 255);
    private static final List<Component> EDIT_NAME_TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.overlaySelection.editName"));
    private static final List<Component> SAVE_NAME_TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.overlaySelection.stopEdit"));
    private static final List<Component> VIEW_TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.overlaySelection.viewTooltip"));
    private final List<Component> descriptionTooltip;
    private final Overlay overlay;
    private final OverlaySelectionScreen selectionScreen;
    private String textToRender;
    private TextInputBoxWidget editInput;

    public OverlayButton(int x, int y, int width, int height, Overlay overlay, OverlaySelectionScreen selectionScreen) {
        super(x, y, width, height, (Component)Component.literal((String)overlay.getTranslatedName()));
        CustomNameProperty customNameProperty;
        this.overlay = overlay;
        this.selectionScreen = selectionScreen;
        this.textToRender = overlay instanceof CustomNameProperty ? (!((String)(customNameProperty = (CustomNameProperty)((Object)overlay)).getCustomName().get()).isEmpty() ? (String)customNameProperty.getCustomName().get() : overlay.getTranslatedName()) : overlay.getTranslatedName();
        this.descriptionTooltip = overlay instanceof InfoBoxOverlay ? ComponentUtils.wrapTooltips(Streams.concat((Stream[])new Stream[]{VIEW_TOOLTIP.stream(), EDIT_NAME_TOOLTIP.stream()}).toList(), 150) : (overlay instanceof CustomBarOverlayBase ? ComponentUtils.wrapTooltips(Streams.concat((Stream[])new Stream[]{VIEW_TOOLTIP.stream(), EDIT_NAME_TOOLTIP.stream()}).toList(), 150) : ComponentUtils.wrapTooltips(VIEW_TOOLTIP, 150));
        if (overlay instanceof CustomNameProperty) {
            CustomNameProperty customNameOverlay = (CustomNameProperty)((Object)overlay);
            this.editInput = new TextInputBoxWidget(x, y, width, height, null, selectionScreen);
            this.editInput.visible = false;
            String currentName = (String)customNameOverlay.getCustomName().get();
            if (currentName.isEmpty()) {
                this.editInput.setTextBoxInput(overlay.getTranslatedName());
            } else {
                this.editInput.setTextBoxInput(currentName);
            }
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        boolean enabled = Managers.Overlay.isEnabled(this.overlay);
        RenderUtils.drawRect(poseStack, this.getRectColor(enabled).withAlpha(100), this.getX(), this.getY(), 0.0f, this.width, this.height);
        RenderUtils.drawRectBorders(poseStack, this.getBorderColor(enabled), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 1.0f, 2.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.textToRender), this.getX() + 2, (float)this.getY() + (float)this.height / 2.0f, this.width - 4, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        if (this.editInput != null) {
            this.editInput.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.isHovered && (mouseY <= this.selectionScreen.getConfigMaskTopY() || mouseY >= this.selectionScreen.getConfigMaskBottomY())) {
            this.isHovered = false;
        }
        if (this.isHovered) {
            if (!this.overlay.isParentEnabled()) {
                McUtils.screen().setTooltipForNextRenderPass(Lists.transform(ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.overlaySelection.parentDisabled", (Object[])new Object[]{this.overlay.getParentTranslatedName()})), 200), Component::getVisualOrderText));
            } else {
                McUtils.screen().setTooltipForNextRenderPass(Lists.transform(this.editInput != null && this.editInput.visible ? SAVE_NAME_TOOLTIP : this.descriptionTooltip, Component::getVisualOrderText));
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.selectionScreen.getConfigMaskTopY() || mouseY >= (double)this.selectionScreen.getConfigMaskBottomY()) {
            return false;
        }
        if (this.editInput != null && this.editInput.visible && this.editInput.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            if (this.isSelected() && this.editInput != null) {
                this.editInput.visible = true;
                this.selectionScreen.setFocusedTextInput(this.editInput);
            } else {
                this.selectionScreen.selectOverlay(this.overlay);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.selectionScreen.getConfigMaskTopY() || mouseY >= (double)this.selectionScreen.getConfigMaskBottomY()) {
            return false;
        }
        if (this.editInput != null) {
            this.editInput.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onPress() {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.editInput != null && this.editInput.visible) {
            this.editInput.visible = false;
            Overlay overlay = this.overlay;
            if (overlay instanceof CustomNameProperty) {
                CustomNameProperty customNameOverlay = (CustomNameProperty)((Object)overlay);
                customNameOverlay.setCustomName(this.editInput.getTextBoxInput());
                this.textToRender = this.editInput.getTextBoxInput().isEmpty() ? this.overlay.getTranslatedName() : this.editInput.getTextBoxInput();
            }
            return true;
        }
        return false;
    }

    public void setY(int y) {
        super.setY(y);
        if (this.editInput != null) {
            this.editInput.setY(y);
        }
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void hideEditInput() {
        if (this.editInput != null) {
            this.editInput.visible = false;
        }
    }

    private CustomColor getRectColor(boolean enabled) {
        if (this.isSelected()) {
            return CommonColors.GRAY;
        }
        if (!this.overlay.isParentEnabled()) {
            return DISABLED_FEATURE_COLOR;
        }
        return enabled ? ENABLED_COLOR : DISABLED_COLOR;
    }

    private CustomColor getBorderColor(boolean enabled) {
        if (this.isSelected()) {
            return this.isHovered ? CommonColors.LIGHT_GRAY : CommonColors.WHITE;
        }
        if (!this.overlay.isParentEnabled()) {
            return this.isHovered ? DISABLED_FEATURE_COLOR_BORDER_HOVERED : DISABLED_FEATURE_COLOR_BORDER;
        }
        return enabled ? (this.isHovered ? ENABLED_COLOR_BORDER_HOVERED : ENABLED_COLOR_BORDER) : (this.isHovered ? DISABLED_COLOR_BORDER_HOVERED : DISABLED_COLOR_BORDER);
    }

    private boolean isSelected() {
        return this.selectionScreen.getSelectedOverlay() == this.overlay;
    }
}

