/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets.quicksorts;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.territorymanagement.TerritoryManagementScreen;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public abstract class TerritoryQuickSortWidget
extends AbstractWidget {
    private final TerritoryManagementScreen screen;
    protected SortDirection sortDirection = null;

    protected TerritoryQuickSortWidget(int x, int y, int width, int height, TerritoryManagementScreen screen) {
        super(x, y, width, height, (Component)Component.empty());
        this.screen = screen;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean isHovered = this.isMouseOver(mouseX, mouseY);
        FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromComponent((Component)Component.literal((String)this.getSortName()).withStyle(isHovered ? ChatFormatting.BOLD : ChatFormatting.RESET).append(" ").append(this.sortDirection == null ? "-" : (this.sortDirection == SortDirection.ASCENDING ? "\u25b2" : "\u25bc"))), this.getX() + 5, this.getY() + 5, this.getSortColor(), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked;
        if (!this.active || !this.visible) {
            return false;
        }
        if (this.isValidClickButton(button) && (clicked = this.isMouseOver(mouseX, mouseY))) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            if (button == 0) {
                this.forwardClick();
            } else if (button == 1) {
                this.backwardClick();
            } else if (button == 2) {
                this.resetClick();
            }
            this.screen.updateSearchFromQuickFilters();
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0 || button == 1 || button == 2;
    }

    public final String getItemSearchQuery() {
        if (this.sortDirection == null) {
            return "";
        }
        return Services.ItemFilter.getItemFilterString(Map.of(), this.getSortInfos(), List.of());
    }

    private void forwardClick() {
        this.sortDirection = this.sortDirection == null ? SortDirection.ASCENDING : (this.sortDirection == SortDirection.ASCENDING ? SortDirection.DESCENDING : null);
    }

    private void backwardClick() {
        this.sortDirection = this.sortDirection == null ? SortDirection.DESCENDING : (this.sortDirection == SortDirection.DESCENDING ? SortDirection.ASCENDING : null);
    }

    private void resetClick() {
        this.sortDirection = null;
    }

    protected abstract String getSortName();

    protected abstract CustomColor getSortColor();

    protected abstract List<SortInfo> getSortInfos();
}

