/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.wynntilsmenu.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WynntilsMenuButton
extends AbstractWidget {
    private static final CustomColor BUTTON_COLOR = new CustomColor(181, 174, 151);
    private static final CustomColor BUTTON_COLOR_HOVERED = new CustomColor(121, 116, 101);
    private final Texture buttonTexture;
    private final boolean dynamicTexture;
    private final Runnable clickAction;
    private final List<Component> tooltipList;

    public WynntilsMenuButton(int x, int y, int size, Texture buttonTexture, boolean dynamicTexture, Runnable clickAction, List<Component> tooltipList) {
        super(x, y, size, size, (Component)Component.empty());
        this.buttonTexture = buttonTexture;
        this.dynamicTexture = dynamicTexture;
        this.clickAction = clickAction;
        this.tooltipList = tooltipList;
    }

    public WynntilsMenuButton(int x, int y, int size, Texture buttonTexture, boolean dynamicTexture, Screen openedScreen, List<Component> tooltipList) {
        this(x, y, size, buttonTexture, dynamicTexture, () -> McUtils.setScreen(openedScreen), tooltipList);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, this.isHovered ? BUTTON_COLOR_HOVERED : BUTTON_COLOR, this.getX(), this.getY(), 0.0f, this.width, this.height);
        if (!this.dynamicTexture) {
            RenderUtils.drawTexturedRect(poseStack, this.buttonTexture.resource(), (float)this.getX() + (float)(this.width - this.buttonTexture.width()) / 2.0f, (float)this.getY() + (float)(this.height - this.buttonTexture.height()) / 2.0f, 1.0f, this.buttonTexture.width(), this.buttonTexture.height(), 0, 0, this.buttonTexture.width(), this.buttonTexture.height(), this.buttonTexture.width(), this.buttonTexture.height());
            return;
        }
        if (this.isHovered) {
            RenderUtils.drawTexturedRect(poseStack, this.buttonTexture.resource(), (float)this.getX() + (float)(this.width - this.buttonTexture.width()) / 2.0f, (float)this.getY() + ((float)this.height - (float)this.buttonTexture.height() / 2.0f) / 2.0f, 1.0f, this.buttonTexture.width(), (float)this.buttonTexture.height() / 2.0f, 0, this.buttonTexture.height() / 2, this.buttonTexture.width(), this.buttonTexture.height() / 2, this.buttonTexture.width(), this.buttonTexture.height());
        } else {
            RenderUtils.drawTexturedRect(poseStack, this.buttonTexture.resource(), (float)this.getX() + (float)(this.width - this.buttonTexture.width()) / 2.0f, (float)this.getY() + ((float)this.height - (float)this.buttonTexture.height() / 2.0f) / 2.0f, 1.0f, this.buttonTexture.width(), (float)this.buttonTexture.height() / 2.0f, 0, 0, this.buttonTexture.width(), this.buttonTexture.height() / 2, this.buttonTexture.width(), this.buttonTexture.height());
        }
    }

    public Runnable getClickAction() {
        return this.clickAction;
    }

    public List<Component> getTooltipList() {
        return this.tooltipList;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

