/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.filters;

import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatFilterFactory;
import com.wynntils.services.itemfilter.type.StatValue;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RangedStatFilters {

    private static abstract class RangedStatFilterFactory<T>
    extends StatFilterFactory<T> {
        private static final Pattern SINGLE_VALUE_PATTERN = Pattern.compile("[-+]?\\d+");
        private static final Pattern RANGE_PATTERN = Pattern.compile("([-+]?\\d+)-([-+]?\\d+)");
        private static final Pattern GREATER_THAN_PATTERN = Pattern.compile(">(=)?[-+]?\\d+");
        private static final Pattern LESS_THAN_PATTERN = Pattern.compile("<(=)?[-+]?\\d+");

        private RangedStatFilterFactory() {
        }

        @Override
        public Optional<T> create(String inputString) {
            Matcher matcher = SINGLE_VALUE_PATTERN.matcher(inputString);
            try {
                if (matcher.matches()) {
                    int value = Integer.parseInt(inputString);
                    return Optional.of(this.getRangedStatFilter(value, value, true));
                }
                matcher = RANGE_PATTERN.matcher(inputString);
                if (matcher.matches()) {
                    int min = Integer.parseInt(matcher.group(1));
                    int max = Integer.parseInt(matcher.group(2));
                    return Optional.of(this.getRangedStatFilter(min, max, true));
                }
                matcher = GREATER_THAN_PATTERN.matcher(inputString);
                if (matcher.matches()) {
                    boolean equal = inputString.charAt(1) == '=';
                    int value = Integer.parseInt(inputString.substring(equal ? 2 : 1));
                    return Optional.of(this.getRangedStatFilter(equal ? value : value + 1, Integer.MAX_VALUE, equal));
                }
                matcher = LESS_THAN_PATTERN.matcher(inputString);
                if (matcher.matches()) {
                    boolean equal = inputString.charAt(1) == '=';
                    int value = Integer.parseInt(inputString.substring(equal ? 2 : 1));
                    return Optional.of(this.getRangedStatFilter(Integer.MIN_VALUE, equal ? value : value - 1, equal));
                }
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
            return Optional.empty();
        }

        protected abstract T getRangedStatFilter(int var1, int var2, boolean var3);
    }

    public static abstract class AbstractRangedStatFilter<T>
    extends StatFilter<T> {
        protected final int min;
        protected final int max;
        protected final boolean equalsInString;

        protected AbstractRangedStatFilter(int min, int max, boolean equalsInString) {
            this.min = min;
            this.max = max;
            this.equalsInString = equalsInString;
        }

        @Override
        public String asString() {
            if (this.min == this.max) {
                return Integer.toString(this.min);
            }
            if (this.min == Integer.MIN_VALUE) {
                return this.equalsInString ? "<=" + this.max : "<" + (this.max + 1);
            }
            if (this.max == Integer.MAX_VALUE) {
                return this.equalsInString ? ">=" + this.min : ">" + (this.min - 1);
            }
            return this.min + "-" + this.max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean isEqualsInString() {
            return this.equalsInString;
        }
    }

    public static class RangedStatValueStatFilter
    extends AbstractRangedStatFilter<StatValue> {
        protected RangedStatValueStatFilter(int min, int max, boolean equalsInString) {
            super(min, max, equalsInString);
        }

        @Override
        public boolean matches(StatValue value) {
            if (value.statActualValue() != null) {
                return value.statActualValue().value() >= this.min && value.statActualValue().value() <= this.max;
            }
            return MathUtils.rangesIntersect(this.min, this.max, value.possibleValues().range().low(), value.possibleValues().range().high());
        }

        public static class RangedStatValueStatFilterFactory
        extends RangedStatFilterFactory<RangedStatValueStatFilter> {
            @Override
            protected RangedStatValueStatFilter getRangedStatFilter(int min, int max, boolean equalsInString) {
                return new RangedStatValueStatFilter(min, max, equalsInString);
            }
        }
    }

    public static class RangedCappedValueStatFilter
    extends AbstractRangedStatFilter<CappedValue> {
        protected RangedCappedValueStatFilter(int min, int max, boolean equalsInString) {
            super(min, max, equalsInString);
        }

        @Override
        public boolean matches(CappedValue value) {
            return value.current() >= this.min && value.current() <= this.max;
        }

        public static class RangedCappedValueStatFilterFactory
        extends RangedStatFilterFactory<RangedCappedValueStatFilter> {
            @Override
            protected RangedCappedValueStatFilter getRangedStatFilter(int min, int max, boolean equalsInString) {
                return new RangedCappedValueStatFilter(min, max, equalsInString);
            }
        }
    }

    public static class RangedIntegerStatFilter
    extends AbstractRangedStatFilter<Integer> {
        protected RangedIntegerStatFilter(int min, int max, boolean equalsInString) {
            super(min, max, equalsInString);
        }

        @Override
        public boolean matches(Integer value) {
            return value >= this.min && value <= this.max;
        }

        public static class RangedIntegerStatFilterFactory
        extends RangedStatFilterFactory<RangedIntegerStatFilter> {
            @Override
            protected RangedIntegerStatFilter getRangedStatFilter(int min, int max, boolean equalsInString) {
                return new RangedIntegerStatFilter(min, max, equalsInString);
            }
        }
    }
}

