/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.type;

import com.google.common.base.CaseFormat;
import com.wynntils.core.persisted.Translatable;
import com.wynntils.models.items.WynnItem;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import java.lang.reflect.ParameterizedType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;

public abstract class ItemStatProvider<T extends Comparable<T>>
implements Translatable,
Comparator<WynnItem> {
    private final String name;

    protected ItemStatProvider() {
        String name = this.getClass().getSimpleName().replace("StatProvider", "");
        this.name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name);
    }

    public abstract Optional<T> getValue(WynnItem var1);

    public List<String> getValidInputs() {
        return List.of();
    }

    public abstract List<ItemProviderType> getFilterTypes();

    public Class<T> getType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public List<String> getAliases() {
        return List.of();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getTranslation("name", new Object[0]);
    }

    @Override
    public String getTranslation(String keySuffix, Object ... formatValues) {
        return I18n.get((String)("service.wynntils.itemFilter.stat." + this.name + "." + keySuffix), (Object[])formatValues);
    }

    @Override
    public String getTypeName() {
        return "Service";
    }

    public String getDescription() {
        return this.getTranslation("description", new Object[0]);
    }

    @Override
    public int compare(WynnItem wynnItem1, WynnItem wynnItem2) {
        Optional<T> itemValue1 = this.getValue(wynnItem1);
        Optional<T> itemValue2 = this.getValue(wynnItem2);
        if (itemValue1.isEmpty() && itemValue2.isPresent()) {
            return 1;
        }
        if (itemValue1.isPresent() && itemValue2.isEmpty()) {
            return -1;
        }
        if (itemValue1.isEmpty() && itemValue2.isEmpty()) {
            return 0;
        }
        return -((Comparable)itemValue1.get()).compareTo((Comparable)itemValue2.get());
    }
}

