/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.features.LootrunFeature;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.mc.event.RenderLevelEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.containers.containers.reward.LootChestContainer;
import com.wynntils.services.lootrunpaths.LootrunCompiler;
import com.wynntils.services.lootrunpaths.LootrunPathFileParser;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.LootrunRenderer;
import com.wynntils.services.lootrunpaths.RecordingInformation;
import com.wynntils.services.lootrunpaths.UncompiledLootrunPath;
import com.wynntils.services.lootrunpaths.event.LootrunPathCacheRefreshEvent;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.services.lootrunpaths.type.LootrunSaveResult;
import com.wynntils.services.lootrunpaths.type.LootrunState;
import com.wynntils.services.lootrunpaths.type.LootrunUndoResult;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.PosUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;

public final class LootrunPathsService
extends Service {
    public static final File LOOTRUNS = WynntilsMod.getModStorageDir("lootruns");
    private List<LootrunPathInstance> lootrunPathInstanceCache = new ArrayList<LootrunPathInstance>();
    private UncompiledLootrunPath uncompiled = null;
    private LootrunState state = LootrunState.DISABLED;
    private LootrunPathInstance lootrun = null;
    private LootrunPathInstance recordingCompiled = null;
    private UncompiledLootrunPath recording = null;
    private RecordingInformation recordingInformation = null;

    public LootrunPathsService() {
        super(List.of());
        FileUtils.mkdir(LOOTRUNS);
    }

    public LootrunState getState() {
        return this.state;
    }

    public int addNote(Component text) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return 0;
        }
        Entity root = McUtils.player().getRootVehicle();
        current.notes().add(new LootrunNote((Position)root.position(), text));
        return this.recompileLootrun(true);
    }

    public LootrunPathInstance getCurrentLootrun() {
        return this.lootrun;
    }

    public int recompileLootrun(boolean saveToFile) {
        if (this.recording != null) {
            this.recordingInformation.setDirty(true);
        } else if (this.uncompiled != null) {
            this.lootrun = LootrunCompiler.compile(this.uncompiled, false);
            if (saveToFile && this.uncompiled.file() != null) {
                LootrunSaveResult lootrunSaveResult = this.saveCurrentLootrun(this.uncompiled.file().getName().replace(".json", ""));
                if (lootrunSaveResult == null) {
                    return 0;
                }
                switch (lootrunSaveResult) {
                    case SAVED: {
                        return 1;
                    }
                    case ERROR_SAVING: 
                    case ERROR_ALREADY_EXISTS: {
                        return 0;
                    }
                }
            }
        }
        return 1;
    }

    public void clearCurrentLootrun() {
        this.state = LootrunState.DISABLED;
        this.lootrun = null;
        this.uncompiled = null;
        this.recording = null;
        this.recordingCompiled = null;
        this.recordingInformation = null;
    }

    public void stopRecording() {
        this.state = LootrunState.LOADED;
        this.lootrun = LootrunCompiler.compile(this.recording, false);
        this.uncompiled = this.recording;
        this.recording = null;
        this.recordingCompiled = null;
        this.recordingInformation = null;
    }

    public void startRecording() {
        this.state = LootrunState.RECORDING;
        this.recording = new UncompiledLootrunPath(new LootrunPath(new ArrayList<Vec3>()), new HashSet<BlockPos>(), new ArrayList<LootrunNote>(), null);
        this.recordingInformation = new RecordingInformation();
    }

    public List<LootrunPathInstance> getLootruns() {
        return this.lootrunPathInstanceCache;
    }

    public void refreshLootrunCache() {
        ArrayList<LootrunPathInstance> lootruns = new ArrayList<LootrunPathInstance>();
        File[] files = LOOTRUNS.listFiles();
        for (File file : files != null ? files : new File[]{}) {
            if (!file.getName().endsWith(".json")) continue;
            try {
                FileReader reader = new FileReader(file, StandardCharsets.UTF_8);
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                UncompiledLootrunPath uncompiled = LootrunPathFileParser.readJson(file, json);
                lootruns.add(LootrunCompiler.compile(uncompiled, false));
            }
            catch (Exception e) {
                WynntilsMod.warn("Could not parse lootrun file.", e);
            }
        }
        this.lootrunPathInstanceCache = lootruns;
        WynntilsMod.postEvent(new LootrunPathCacheRefreshEvent());
    }

    private boolean loadFile(String fileName) {
        String lootrunFileName = fileName + ".json";
        File lootrunFile = new File(LOOTRUNS, lootrunFileName);
        if (lootrunFile.exists()) {
            try {
                FileReader file = new FileReader(lootrunFile, StandardCharsets.UTF_8);
                JsonObject json = JsonParser.parseReader((Reader)file).getAsJsonObject();
                this.uncompiled = LootrunPathFileParser.readJson(lootrunFile, json);
                this.lootrun = LootrunCompiler.compile(this.uncompiled, false);
                this.state = LootrunState.LOADED;
                file.close();
                return true;
            }
            catch (Exception e) {
                WynntilsMod.error("Error when trying to load lootrun file.", e);
                return false;
            }
        }
        return false;
    }

    public void tryLoadLootrun(String fileName) {
        if (this.loadFile(fileName)) {
            Position startingPoint = Services.LootrunPaths.getStartingPoint();
            BlockPos start = PosUtils.newBlockPos(startingPoint);
            McUtils.sendMessageToClient((Component)Component.translatable((String)"service.wynntils.lootrunPaths.lootrunStart", (Object[])new Object[]{start.getX(), start.getY(), start.getZ()}).withStyle(ChatFormatting.GREEN));
            if (McUtils.mc().options.graphicsMode().get() == GraphicsStatus.FABULOUS) {
                McUtils.sendMessageToClient((Component)Component.translatable((String)"service.wynntils.lootrunPaths.fabulousWarning").withStyle(ChatFormatting.RED));
            }
        } else {
            McUtils.sendErrorToClient(I18n.get((String)"service.wynntils.lootrunPaths.lootrunCouldNotBeLoaded", (Object[])new Object[]{fileName}));
        }
    }

    public LootrunUndoResult tryUndo() {
        Vec3 position = McUtils.player().position();
        LootrunPath points = this.recording.path();
        LootrunPath removed = new LootrunPath(new ArrayList<Vec3>());
        boolean left = false;
        for (int i = points.points().size() - 1; i >= 0; --i) {
            if (i == 0) {
                if (left) {
                    return LootrunUndoResult.ERROR_STAND_NEAR_POINT;
                }
                return LootrunUndoResult.ERROR_NOT_FAR_ENOUGH;
            }
            if (points.points().get(i).distanceToSqr(position) < 4.0) {
                if (left) {
                    break;
                }
            } else {
                left = true;
            }
            removed.points().add(points.points().get(i));
        }
        points.points().removeAll(removed.points());
        this.recordingInformation.setDirty(true);
        return LootrunUndoResult.SUCCESSFUL;
    }

    public boolean addChest(BlockPos pos) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return false;
        }
        return current.chests().add(pos);
    }

    public boolean removeChest(BlockPos pos) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return false;
        }
        return current.chests().remove(pos);
    }

    public LootrunNote deleteNoteAt(BlockPos pos) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return null;
        }
        List<LootrunNote> notes = current.notes();
        for (int i = 0; i < notes.size(); ++i) {
            LootrunNote note = notes.get(i);
            if (!pos.equals((Object)PosUtils.newBlockPos(note.position()))) continue;
            return notes.remove(i);
        }
        return null;
    }

    public List<LootrunNote> getCurrentNotes() {
        UncompiledLootrunPath activeLootrun = this.getActiveLootrun();
        if (activeLootrun == null) {
            return List.of();
        }
        return activeLootrun.notes();
    }

    public Position getStartingPoint() {
        UncompiledLootrunPath activeLootrun = this.getActiveLootrun();
        if (activeLootrun == null) {
            return null;
        }
        if (activeLootrun.path() == null || activeLootrun.path().points().isEmpty()) {
            return null;
        }
        return (Position)activeLootrun.path().points().getFirst();
    }

    public LootrunSaveResult saveCurrentLootrun(String name) {
        UncompiledLootrunPath activeLootrun = this.getActiveLootrun();
        if (activeLootrun == null) {
            return null;
        }
        File file = new File(LOOTRUNS, name + ".json");
        this.uncompiled = new UncompiledLootrunPath(activeLootrun.path(), activeLootrun.chests(), activeLootrun.notes(), file);
        return LootrunPathFileParser.writeJson(activeLootrun, file);
    }

    @SubscribeEvent
    public void onRenderLastLevel(RenderLevelEvent.Post event) {
        PoseStack poseStack = new PoseStack();
        LootrunRenderer.renderLootrun(poseStack, this.lootrun, ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).activePathColor.get()).asInt());
        LootrunRenderer.renderLootrun(poseStack, this.recordingCompiled, ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).recordingPathColor.get()).asInt());
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.InteractAt event) {
        if (this.state != LootrunState.RECORDING) {
            return;
        }
        Entity entity = event.getEntityHitResult().getEntity();
        if (entity != null && entity.getType() == EntityType.SLIME) {
            this.recordingInformation.setLastChest(entity.blockPosition());
        }
    }

    @SubscribeEvent
    public void onOpen(ScreenOpenedEvent.Post event) {
        if (this.state != LootrunState.RECORDING) {
            return;
        }
        if (this.recordingInformation.getLastChest() == null) {
            return;
        }
        if (!(Models.Container.getCurrentContainer() instanceof LootChestContainer)) {
            return;
        }
        this.recording.chests().add(this.recordingInformation.getLastChest());
        this.recordingInformation.setDirty(true);
        this.recordingInformation.setLastChest(null);
    }

    @SubscribeEvent
    public void recordMovement(TickEvent event) {
        if (this.state != LootrunState.RECORDING) {
            return;
        }
        LocalPlayer player = McUtils.player();
        if (player == null) {
            return;
        }
        Entity root = player.getRootVehicle();
        Vec3 pos = root.position();
        if (this.recordingInformation.getLastLocation() == null || pos.distanceToSqr(this.recordingInformation.getLastLocation()) >= 4.0) {
            this.recording.path().points().add(pos);
            this.recordingInformation.setLastLocation(pos);
            this.recordingInformation.setDirty(true);
        }
        if (this.recordingInformation.isDirty()) {
            this.recordingCompiled = LootrunCompiler.compile(this.recording, true);
            this.recordingInformation.setDirty(false);
        }
    }

    private UncompiledLootrunPath getActiveLootrun() {
        UncompiledLootrunPath instance = null;
        if (this.recording != null) {
            instance = this.recording;
        } else if (this.uncompiled != null) {
            instance = this.uncompiled;
        }
        return instance;
    }
}

