/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wynntils.core.components.Managers;
import com.wynntils.features.LootrunFeature;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.type.BlockValidness;
import com.wynntils.services.lootrunpaths.type.ColoredPath;
import com.wynntils.services.lootrunpaths.type.ColoredPosition;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.PosUtils;
import com.wynntils.utils.render.buffered.CustomRenderType;
import com.wynntils.utils.type.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class LootrunRenderer {
    private static final MultiBufferSource.BufferSource BUFFER_SOURCE = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));

    public static void renderLootrun(PoseStack poseStack, LootrunPathInstance lootrun, int color) {
        if (lootrun == null) {
            return;
        }
        ClientLevel level = McUtils.mc().level;
        if (level == null) {
            return;
        }
        poseStack.pushPose();
        Camera camera = McUtils.mc().gameRenderer.getMainCamera();
        poseStack.mulPose(Axis.XP.rotationDegrees(camera.getXRot()));
        poseStack.mulPose(Axis.YP.rotationDegrees(camera.getYRot() + 180.0f));
        poseStack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
        Long2ObjectMap<List<ColoredPath>> points = lootrun.points();
        int renderDistance = (Integer)McUtils.options().renderDistance().get();
        BlockPos pos = camera.getBlockPosition();
        ChunkPos origin = new ChunkPos(pos);
        for (int i = 0; i <= renderDistance; ++i) {
            for (int j = 0; j <= renderDistance; ++j) {
                int x = j + origin.x - renderDistance / 2;
                int z = i + origin.z - renderDistance / 2;
                ChunkPos chunk = new ChunkPos(x, z);
                if (!level.hasChunk(chunk.x, chunk.z)) continue;
                long chunkLong = chunk.toLong();
                if (points.containsKey(chunkLong)) {
                    LootrunRenderer.renderPoints(poseStack, points, chunkLong);
                }
                if (lootrun.chests().containsKey(chunkLong)) {
                    LootrunRenderer.renderChests(poseStack, lootrun, color, chunkLong);
                }
                if (!((Boolean)Managers.Feature.getFeatureInstance(LootrunFeature.class).showNotes.get()).booleanValue() || !lootrun.notes().containsKey(chunkLong)) continue;
                LootrunRenderer.renderNotes(poseStack, lootrun, color, chunkLong);
            }
        }
        poseStack.popPose();
    }

    private static void renderNotes(PoseStack poseStack, LootrunPathInstance lootrun, int color, long chunkLong) {
        List notes = (List)lootrun.notes().get(chunkLong);
        Font font = McUtils.mc().font;
        for (LootrunNote note : notes) {
            Position position = note.position();
            poseStack.pushPose();
            poseStack.translate(position.x(), position.y() + 2.0, position.z());
            poseStack.mulPose(McUtils.mc().gameRenderer.getMainCamera().rotation());
            poseStack.scale(0.025f, -0.025f, 0.025f);
            Matrix4f pose = poseStack.last().pose();
            List lines = font.split((FormattedText)note.component(), 200);
            Objects.requireNonNull(font);
            int offsetY = -(9 * lines.size()) / 2;
            for (FormattedCharSequence line : lines) {
                int offsetX = -font.width(line) / 2;
                font.drawInBatch(line, (float)offsetX, (float)offsetY, color, false, pose, (MultiBufferSource)BUFFER_SOURCE, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, 0xF000F0);
                Objects.requireNonNull(font);
                offsetY += 9 + 2;
            }
            poseStack.popPose();
        }
    }

    private static void renderChests(PoseStack poseStack, LootrunPathInstance lootrun, int color, long chunkLong) {
        VertexConsumer consumer = BUFFER_SOURCE.getBuffer(RenderType.lines());
        Set chests = (Set)lootrun.chests().get(chunkLong);
        float red = (float)ARGB.red((int)color) / 255.0f;
        float green = (float)ARGB.green((int)color) / 255.0f;
        float blue = (float)ARGB.blue((int)color) / 255.0f;
        for (BlockPos chest : chests) {
            BlockState block = McUtils.mc().level.getBlockState(chest);
            if (block.is(Blocks.BARRIER) || block.is(Blocks.AIR)) continue;
            ShapeRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)new AABB(chest), (float)red, (float)green, (float)blue, (float)1.0f);
        }
        BUFFER_SOURCE.endBatch();
    }

    private static void renderPoints(PoseStack poseStack, Long2ObjectMap<List<ColoredPath>> points, long chunkLong) {
        List locations = (List)points.get(chunkLong);
        ClientLevel level = McUtils.mc().level;
        if (level == null) {
            return;
        }
        switch ((LootrunFeature.PathType)((Object)Managers.Feature.getFeatureInstance(LootrunFeature.class).pathType.get())) {
            case TEXTURED: {
                LootrunRenderer.renderTexturedLootrunPoints(poseStack, locations, (Level)level, CustomRenderType.LOOTRUN_QUAD);
                break;
            }
            case LINE: {
                LootrunRenderer.renderNonTexturedLootrunPoints(poseStack, locations, (Level)level, CustomRenderType.LOOTRUN_LINE);
            }
        }
    }

    private static void renderNonTexturedLootrunPoints(PoseStack poseStack, List<ColoredPath> locations, Level level, RenderType renderType) {
        for (ColoredPath locationsInRoute : locations) {
            VertexConsumer consumer = BUFFER_SOURCE.getBuffer(renderType);
            Matrix4f lastMatrix = poseStack.last().pose();
            boolean sourceBatchEnded = false;
            ColoredPath toRender = new ColoredPath(new ArrayList<ColoredPosition>());
            boolean pauseDraw = false;
            BlockPos lastBlockPos = null;
            for (ColoredPosition point : locationsInRoute.points()) {
                BlockPos blockPos = PosUtils.newBlockPos((Position)point.position());
                if (blockPos.equals(lastBlockPos)) {
                    if (!toRender.points().isEmpty()) {
                        toRender.points().add(point);
                    }
                } else {
                    BlockValidness blockValidness = BlockValidness.checkBlockValidness(level, point);
                    if (blockValidness == BlockValidness.VALID) {
                        pauseDraw = false;
                        if (sourceBatchEnded) {
                            consumer = BUFFER_SOURCE.getBuffer(renderType);
                            sourceBatchEnded = false;
                        }
                        LootrunRenderer.renderQueuedPoints(consumer, lastMatrix, toRender);
                        toRender.points().clear();
                    } else if (blockValidness == BlockValidness.HAS_BARRIER) {
                        pauseDraw = true;
                        toRender.points().clear();
                    } else {
                        pauseDraw = false;
                        toRender.points().add(point);
                        continue;
                    }
                }
                lastBlockPos = blockPos;
                if (!pauseDraw) {
                    LootrunRenderer.renderPoint(consumer, lastMatrix, point);
                    continue;
                }
                if (sourceBatchEnded) continue;
                BUFFER_SOURCE.endBatch();
                sourceBatchEnded = true;
            }
            if (sourceBatchEnded) continue;
            LootrunRenderer.renderQueuedPoints(consumer, lastMatrix, toRender);
            BUFFER_SOURCE.endBatch();
        }
    }

    private static void renderTexturedLootrunPoints(PoseStack poseStack, List<ColoredPath> locations, Level level, RenderType renderType) {
        Camera camera = McUtils.mc().gameRenderer.getMainCamera();
        poseStack.pushPose();
        poseStack.translate(camera.getPosition().x, camera.getPosition().y, camera.getPosition().z);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ColoredPath locationsInRoute : locations) {
            VertexConsumer consumer = BUFFER_SOURCE.getBuffer(renderType);
            ArrayList<Pair<ColoredPosition, ColoredPosition>> toRender = new ArrayList<Pair<ColoredPosition, ColoredPosition>>();
            boolean sourceBatchEnded = false;
            BlockPos lastBlockPos = null;
            boolean pauseDraw = false;
            for (int i = 0; i < locationsInRoute.points().size() - 1; i += 10) {
                ColoredPosition point = locationsInRoute.points().get(i);
                BlockPos blockPos = PosUtils.newBlockPos((Position)point.position());
                ColoredPosition end = locationsInRoute.points().get(Math.min(locationsInRoute.points().size() - 1, i + 1));
                Pair<ColoredPosition, ColoredPosition> pointPair = new Pair<ColoredPosition, ColoredPosition>(point, end);
                if (blockPos.equals(lastBlockPos)) {
                    if (!toRender.isEmpty()) {
                        toRender.add(pointPair);
                    }
                } else {
                    BlockValidness blockValidness = BlockValidness.checkBlockValidness(level, point);
                    if (blockValidness == BlockValidness.VALID) {
                        pauseDraw = false;
                        if (sourceBatchEnded) {
                            consumer = BUFFER_SOURCE.getBuffer(renderType);
                            sourceBatchEnded = false;
                        }
                        LootrunRenderer.renderTexturedQueuedPoints(toRender, poseStack, consumer);
                        toRender.clear();
                    } else if (blockValidness == BlockValidness.HAS_BARRIER) {
                        pauseDraw = true;
                        toRender.clear();
                    } else {
                        pauseDraw = false;
                        toRender.add(pointPair);
                        continue;
                    }
                }
                lastBlockPos = blockPos;
                if (!pauseDraw) {
                    LootrunRenderer.renderTexturedPoint(pointPair, poseStack, consumer);
                    continue;
                }
                if (sourceBatchEnded) continue;
                BUFFER_SOURCE.endBatch();
                sourceBatchEnded = true;
            }
            if (sourceBatchEnded) continue;
            LootrunRenderer.renderTexturedQueuedPoints(toRender, poseStack, consumer);
            BUFFER_SOURCE.endBatch();
        }
        poseStack.popPose();
    }

    private static void renderQueuedPoints(VertexConsumer consumer, Matrix4f lastMatrix, ColoredPath toRender) {
        for (ColoredPosition position : toRender.points()) {
            LootrunRenderer.renderPoint(consumer, lastMatrix, position);
        }
    }

    private static void renderPoint(VertexConsumer consumer, Matrix4f lastMatrix, ColoredPosition coloredPosition) {
        Vec3 position = coloredPosition.position();
        int pathColor = coloredPosition.color();
        consumer.addVertex(lastMatrix, (float)position.x(), (float)position.y(), (float)position.z()).setColor(pathColor).setNormal(0.0f, 0.0f, 1.0f);
    }

    private static void renderTexturedQueuedPoints(List<Pair<ColoredPosition, ColoredPosition>> pointPairList, PoseStack poseStack, VertexConsumer vertexConsumer) {
        for (Pair<ColoredPosition, ColoredPosition> pointPair : pointPairList) {
            LootrunRenderer.renderTexturedPoint(pointPair.a(), pointPair.b(), poseStack, vertexConsumer);
        }
    }

    private static void renderTexturedPoint(Pair<ColoredPosition, ColoredPosition> pointPair, PoseStack poseStack, VertexConsumer vertexConsumer) {
        LootrunRenderer.renderTexturedPoint(pointPair.a(), pointPair.b(), poseStack, vertexConsumer);
    }

    private static void renderTexturedPoint(ColoredPosition start, ColoredPosition end, PoseStack poseStack, VertexConsumer vertexConsumer) {
        Vector3f camPos = McUtils.mc().gameRenderer.getMainCamera().getPosition().toVector3f();
        Vector3f startVec = start.position().toVector3f();
        Vector3f endVec = end.position().toVector3f();
        int color = start.color();
        Vector3f pos1 = new Vector3f(-0.5f, 0.24f, -0.5f);
        Vector3f pos2 = new Vector3f(0.5f, 0.24f, -0.5f);
        Vector3f pos3 = new Vector3f(0.5f, 0.24f, 0.5f);
        Vector3f pos4 = new Vector3f(-0.5f, 0.24f, 0.5f);
        Vector3f direction = new Vector3f(endVec.x, endVec.y, endVec.z).sub((Vector3fc)startVec).normalize();
        float xAngle = (float)((double)((float)Math.acos(direction.y / direction.length())) - 1.5707963267948966);
        float yAngle = (float)Math.atan2(direction.x, direction.z);
        Quaternionf yRot = new Quaternionf().rotateY(yAngle);
        Vector3f xRotAxis = new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)yRot);
        Quaternionf xRot = new Quaternionf().rotateAxis(xAngle, (Vector3fc)xRotAxis);
        pos1.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos2.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos3.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos4.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos1 = pos1.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        pos2 = pos2.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        pos3 = pos3.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        pos4 = pos4.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        vertexConsumer.addVertex(poseStack.last().pose(), pos1.x, pos1.y, pos1.z).setUv(0.0f, 1.0f).setColor(color);
        vertexConsumer.addVertex(poseStack.last().pose(), pos2.x, pos2.y, pos2.z).setUv(0.0f, 0.0f).setColor(color);
        vertexConsumer.addVertex(poseStack.last().pose(), pos3.x, pos3.y, pos3.z).setUv(1.0f, 0.0f).setColor(color);
        vertexConsumer.addVertex(poseStack.last().pose(), pos4.x, pos4.y, pos4.z).setUv(1.0f, 1.0f).setColor(color);
    }
}

