/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.type.Location;
import java.lang.reflect.Type;
import java.util.Optional;

public class Label {
    private final String name;
    private final int x;
    private final int z;
    private final int layer;
    private final Integer level;

    public Label(String name, int x, int z, int layer, Integer level) {
        this.name = name;
        this.x = x;
        this.z = z;
        this.layer = layer;
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public LabelLayer getLayer() {
        return LabelLayer.values()[this.layer - 1];
    }

    public Optional<Integer> getLevel() {
        return Optional.ofNullable(this.level);
    }

    public Location getLocation() {
        return new Location(this.x, 0, this.z);
    }

    public static enum LabelLayer {
        PROVINCE("province"),
        CITY("city"),
        TOWN_OR_PLACE("place");

        private final String mapDataId;

        private LabelLayer(String mapDataId) {
            this.mapDataId = mapDataId;
        }

        public String getMapDataId() {
            return this.mapDataId;
        }

        public String getName() {
            return StringUtils.capitalized(this.mapDataId);
        }
    }

    public static final class LabelDeserializer
    implements JsonDeserializer<Label> {
        public Label deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement levelObject = jsonObject.get("level");
            Integer level = null;
            if (levelObject != null) {
                String levelString = levelObject.getAsString();
                String minLevel = levelString.split("-")[0];
                minLevel = minLevel.replaceAll("[^0-9]", "");
                level = Integer.parseInt(minLevel);
            }
            return new Label(jsonObject.get("name").getAsString(), jsonObject.get("x").getAsInt(), jsonObject.get("z").getAsInt(), jsonObject.get("layer").getAsInt(), level);
        }
    }
}

