/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.pois;

import com.wynntils.core.components.Managers;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.services.map.pois.StaticIconPoi;
import com.wynntils.services.map.type.DisplayPriority;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.Texture;
import java.util.Objects;

public class CustomPoi
extends StaticIconPoi {
    private final String name;
    private final CustomColor color;
    private final Texture icon;
    private final Visibility visibility;

    public CustomPoi(PoiLocation location, String name, CustomColor color, Texture icon, Visibility visibility) {
        super(location);
        this.name = name;
        this.color = color;
        this.icon = icon;
        this.visibility = visibility;
    }

    @Override
    public Texture getIcon() {
        return this.icon;
    }

    @Override
    public float getMinZoomForRender() {
        return switch (this.getVisibility().ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> -1.0f;
            case 2 -> 2.1474836E9f;
            case 0 -> {
                switch (this.getIcon()) {
                    case CHEST_T1: {
                        yield ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).lootChestTier1PoiMinZoom.get()).floatValue();
                    }
                    case CHEST_T2: {
                        yield ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).lootChestTier2PoiMinZoom.get()).floatValue();
                    }
                    case CHEST_T3: {
                        yield ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).lootChestTier3PoiMinZoom.get()).floatValue();
                    }
                    case CHEST_T4: {
                        yield ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).lootChestTier4PoiMinZoom.get()).floatValue();
                    }
                }
                yield ((Float)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPoiMinZoom.get()).floatValue();
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CustomColor getColor() {
        return this.color;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public CustomColor getIconColor() {
        return this.getColor();
    }

    @Override
    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.LOW;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CustomPoi customPoi = (CustomPoi)other;
        return this.location.equals(customPoi.location) && this.visibility == customPoi.visibility && this.name.equals(customPoi.name) && this.color.equals(customPoi.color) && this.icon == customPoi.icon;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.location, this.name, this.color, this.icon, this.visibility});
    }

    public static enum Visibility {
        DEFAULT("screens.wynntils.poiCreation.visibility.default"),
        ALWAYS("screens.wynntils.poiCreation.visibility.alwaysVisible"),
        HIDDEN("screens.wynntils.poiCreation.visibility.hidden");

        private final String translationKey;

        private Visibility(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

