/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.translation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.wynntils.core.components.Managers;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.services.translation.CachingTranslationProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class GoogleApiTranslationProvider
extends CachingTranslationProvider {
    @Override
    protected void translateNew(List<String> messageList, String toLanguage, Consumer<List<String>> handleTranslation) {
        if (toLanguage == null || toLanguage.isEmpty()) {
            handleTranslation.accept(List.copyOf(messageList));
            return;
        }
        String message = String.join((CharSequence)"{NL}", messageList);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("lang", toLanguage);
        arguments.put("text", message);
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.API_GOOGLE_TRANSLATION, arguments);
        apiResponse.handleJsonArray(json -> {
            StringBuilder builder = new StringBuilder();
            JsonArray array = json.get(0).getAsJsonArray();
            for (JsonElement elem : array) {
                String part = elem.getAsJsonArray().get(0).getAsString();
                builder.append(part);
            }
            String translatedMessage = builder.toString();
            List<String> result = Arrays.stream(translatedMessage.split("\\{NL\\}")).toList();
            this.saveTranslation(toLanguage, messageList, result);
            handleTranslation.accept(result);
        }, onError -> handleTranslation.accept(List.copyOf(messageList)));
    }
}

