/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.translation;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.translation.CachingTranslationProvider;
import com.wynntils.services.translation.GoogleApiTranslationProvider;
import com.wynntils.services.translation.type.TranslationProvider;
import com.wynntils.utils.TaskUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.neoforged.bus.api.SubscribeEvent;

public final class TranslationService
extends Service {
    private TranslationProvider translator = null;
    private Future<?> translationServiceSavingFuture = CompletableFuture.completedFuture(null);

    public TranslationService() {
        super(List.of());
        this.addShutdownHook();
        CachingTranslationProvider.loadTranslationCache();
    }

    @Override
    public void reloadData() {
        CachingTranslationProvider.loadTranslationCache();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.WORLD) {
            return;
        }
        if (!this.translationServiceSavingFuture.isDone() && !this.translationServiceSavingFuture.isCancelled()) {
            return;
        }
        this.translationServiceSavingFuture = TaskUtils.runAsync(CachingTranslationProvider::saveTranslationCache);
    }

    private TranslationProvider getService(TranslationServices service) {
        try {
            Constructor<? extends TranslationProvider> ctor = service.serviceClass.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            WynntilsMod.error("Error when trying to get translation service.", e);
            return null;
        }
    }

    public TranslationProvider getTranslator(TranslationServices translationService) {
        if (this.translator == null) {
            this.translator = this.getService(translationService);
        }
        return this.translator;
    }

    public void resetTranslator() {
        this.translator = null;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            CachingTranslationProvider.saveTranslationCache();
            WynntilsMod.info("Successfully saved translation cache!");
        }));
    }

    public static enum TranslationServices {
        GOOGLEAPI(GoogleApiTranslationProvider.class);

        private final Class<? extends TranslationProvider> serviceClass;

        private TranslationServices(Class<? extends TranslationProvider> serviceClass) {
            this.serviceClass = serviceClass;
        }
    }

    public static class PigLatinTranslationProvider
    implements TranslationProvider {
        @Override
        public void translate(List<String> messageList, String toLanguage, Consumer<List<String>> handleTranslation) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String message : messageList) {
                StringBuilder latinString = new StringBuilder();
                if (!message.isEmpty()) {
                    for (String word : message.split("\\s")) {
                        if (word.isEmpty()) continue;
                        if ("AEIOUaeiou".indexOf(word.charAt(0)) != -1) {
                            latinString.append(word).append("ay ");
                            continue;
                        }
                        latinString.append(word.substring(1)).append(word.charAt(0)).append("ay ");
                    }
                }
                resultList.add(latinString.toString());
            }
            TaskUtils.runAsync(() -> handleTranslation.accept(resultList));
        }
    }
}

