/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.worlds.type.BombInfo;
import com.wynntils.models.worlds.type.BombType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class BombBellCommand
extends Command {
    private static final SuggestionProvider<class_2168> BOMB_TYPE_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Arrays.stream(BombType.values()).map(Enum::name), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "bombbell";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(class_2170.method_9247((String)"list").executes(this::listBombs))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"bombType", (ArgumentType)StringArgumentType.word()).suggests(BOMB_TYPE_SUGGESTION_PROVIDER).executes(this::getBombTypeList)))).executes(this::listBombs);
    }

    private int getBombTypeList(CommandContext<class_2168> context) {
        BombType bombType;
        try {
            bombType = BombType.valueOf((String)context.getArgument("bombType", String.class));
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid bomb type").method_27692(class_124.field_1061));
            return 0;
        }
        Set<BombInfo> bombBells = Models.Bomb.getBombBells().stream().filter(bombInfo -> bombInfo.bomb() == bombType).collect(Collectors.toSet());
        class_5250 component = BombBellCommand.getBombListComponent(bombBells);
        ((class_2168)context.getSource()).method_9226(() -> component, false);
        return 1;
    }

    private int listBombs(CommandContext<class_2168> context) {
        Set<BombInfo> bombBells = Models.Bomb.getBombBells();
        class_5250 component = BombBellCommand.getBombListComponent(bombBells);
        ((class_2168)context.getSource()).method_9226(() -> component, false);
        return 1;
    }

    private static class_5250 getBombListComponent(Set<BombInfo> bombBells) {
        class_5250 response = class_2561.method_43470((String)"Bombs: ").method_27692(class_124.field_1065);
        if (bombBells.isEmpty()) {
            response.method_10852((class_2561)class_2561.method_43470((String)"There are no active bombs at the moment! This might be because there are no bombs currently, or you do not have the ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"CHAMPION").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" rank on Wynncraft, which is necessary to receive bomb alerts from other servers.").method_27692(class_124.field_1061));
            return response;
        }
        for (BombInfo bomb : bombBells.stream().sorted(Comparator.comparing(BombInfo::bomb).reversed().thenComparing(BombInfo::startTime).reversed()).toList()) {
            response.method_10852((class_2561)class_2561.method_43470((String)("\n" + bomb.bomb().getDisplayName())).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" on ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)bomb.server()).method_27692(class_124.field_1068))).method_10852((class_2561)class_2561.method_43470((String)" for: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)bomb.getRemainingString()).method_27692(class_124.field_1068)));
        }
        return response;
    }
}

