/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.GenericFunction;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.consumers.functions.arguments.ListArgument;
import com.wynntils.core.text.StyledText;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class FunctionCommand
extends Command {
    private static final SuggestionProvider<class_2168> FUNCTION_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Stream.concat(Managers.Function.getFunctions().stream().map(Function::getName), Managers.Function.getFunctions().stream().map(Function::getAliasList).flatMap(Collection::stream)), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> CRASHED_FUNCTION_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Managers.Function.getFunctions().stream().filter(Managers.Function::isCrashed).map(Function::getName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> FUNCTION_LIST_TYPES_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(Arrays.stream(ListType.values()).map(Enum::name).map(s -> s.toLowerCase(Locale.ROOT)).toList(), (SuggestionsBuilder)builder);
    private static final Integer LIST_PAGE_LIMIT = 15;

    @Override
    public String getCommandName() {
        return "function";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(this::listFunctions)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::listFunctions))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests(FUNCTION_LIST_TYPES_SUGGESTION_PROVIDER).executes(this::listFunctions)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::listFunctions))))).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"function", (ArgumentType)StringArgumentType.word()).suggests(CRASHED_FUNCTION_SUGGESTION_PROVIDER).executes(this::enableFunction)))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"function", (ArgumentType)StringArgumentType.word()).suggests(FUNCTION_SUGGESTION_PROVIDER).executes(this::getValue)).then(class_2170.method_9244((String)"argument", (ArgumentType)StringArgumentType.greedyString()).executes(this::getValue))))).then(class_2170.method_9247((String)"help").then(class_2170.method_9244((String)"function", (ArgumentType)StringArgumentType.word()).suggests(FUNCTION_SUGGESTION_PROVIDER).executes(this::helpForFunction)))).then((CommandNode)((LiteralArgumentBuilder)class_2170.method_9247((String)"test").then(class_2170.method_9244((String)"template", (ArgumentType)StringArgumentType.greedyString()).executes(this::testExpression))).build())).executes(this::syntaxError);
    }

    private int testExpression(CommandContext<class_2168> context) {
        String template = (String)context.getArgument("template", String.class);
        StyledText[] result = Managers.Function.doFormatLines(template);
        StyledText resultString = StyledText.join(", ", result);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Template calculated: \"%s\u00a7r\" -> [%s\u00a7r]".formatted(template, resultString.getString())), false);
        return 1;
    }

    private int listFunctions(CommandContext<class_2168> context) {
        int page;
        String type;
        try {
            type = (String)context.getArgument("type", String.class);
        }
        catch (Exception e) {
            type = "all";
        }
        try {
            page = (Integer)context.getArgument("page", Integer.class);
        }
        catch (Exception e) {
            page = 1;
        }
        boolean all = type.equalsIgnoreCase("all");
        boolean onlyGeneric = type.equalsIgnoreCase("generic");
        boolean onlyNormal = type.equalsIgnoreCase("normal");
        List<Object> functions = Managers.Function.getFunctions().stream().filter(function -> all || onlyNormal && !(function instanceof GenericFunction) || onlyGeneric && function instanceof GenericFunction).sorted(Comparator.comparing(function -> function instanceof GenericFunction).thenComparing(o -> ((Function)o).getName())).toList();
        int totalPages = (int)Math.ceil((double)functions.size() / (double)LIST_PAGE_LIMIT.intValue());
        if (page > totalPages) {
            page = totalPages;
        }
        int fromIndex = (page - 1) * LIST_PAGE_LIMIT;
        List<Object> paginatedFunctions = functions.size() <= fromIndex ? functions : functions.subList(fromIndex, Math.min(fromIndex + LIST_PAGE_LIMIT, functions.size()));
        class_5250 response = class_2561.method_43470((String)(onlyGeneric ? "Available generic functions: " : "Available functions:")).method_27692(class_124.field_1075);
        for (Function function2 : paginatedFunctions) {
            class_5250 functionComponent = class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080);
            functionComponent.method_10852((class_2561)class_2561.method_43470((String)function2.getName()).method_27692(function2 instanceof GenericFunction ? class_124.field_1065 : class_124.field_1054)).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/function help " + function2.getName())));
            if (!function2.getAliasList().isEmpty()) {
                String aliasList = String.join((CharSequence)", ", function2.getAliasList());
                functionComponent.method_10852((class_2561)class_2561.method_43470((String)" [alias: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)aliasList).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1080));
            }
            functionComponent.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)function2.getDescription()))));
            response.method_10852((class_2561)functionComponent);
        }
        int previousPage = page == 1 ? totalPages : page - 1;
        int n = page == totalPages ? 1 : page + 1;
        String previousPageCommand = "/function list " + type + " " + previousPage;
        String nextPageCommand = "/function list " + type + " " + n;
        class_5250 pageComponent = class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)"< Previous").method_27692(class_124.field_1062).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, previousPageCommand))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Go to previous page"))))).method_10852((class_2561)class_2561.method_43470((String)(" (" + page + "/" + totalPages + ") ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"Next >").method_27692(class_124.field_1062).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, nextPageCommand))).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Go to next page")))));
        response.method_10852((class_2561)pageComponent);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int enableFunction(CommandContext<class_2168> context) {
        String functionName = (String)context.getArgument("function", String.class);
        Optional<Function<?>> functionOptional = Managers.Function.forName(functionName);
        if (functionOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Function not found!").method_27692(class_124.field_1061));
            return 0;
        }
        Function<?> function = functionOptional.get();
        if (!Managers.Function.isCrashed(function)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Function does not need to be enabled").method_27692(class_124.field_1061));
            return 0;
        }
        Managers.Function.enableFunction(function);
        class_5250 response = class_2561.method_43470((String)function.getName()).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" is now enabled").method_27692(class_124.field_1068));
        ((class_2168)context.getSource()).method_9226(() -> FunctionCommand.lambda$enableFunction$15((class_2561)response), false);
        return 1;
    }

    private int getValue(CommandContext<class_2168> context) {
        class_5250 argument;
        try {
            argument = class_2561.method_43470((String)StringArgumentType.getString(context, (String)"argument"));
        }
        catch (IllegalArgumentException e) {
            argument = class_2561.method_43470((String)"");
        }
        String functionName = (String)context.getArgument("function", String.class);
        Optional<Function<?>> functionOptional = Managers.Function.forName(functionName);
        if (functionOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Function not found").method_27692(class_124.field_1061));
            return 0;
        }
        Function<?> function = functionOptional.get();
        class_5250 result = class_2561.method_43470((String)"");
        result.method_10852(Managers.Function.getSimpleValueString(function, argument.getString(), class_124.field_1054, true));
        ((class_2168)context.getSource()).method_9226(() -> result, false);
        return 1;
    }

    private int helpForFunction(CommandContext<class_2168> context) {
        String functionName = (String)context.getArgument("function", String.class);
        Optional<Function<?>> functionOptional = Managers.Function.forName(functionName);
        if (functionOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Function not found").method_27692(class_124.field_1061));
            return 0;
        }
        Function<?> function = functionOptional.get();
        class_5250 helpComponent = class_2561.method_43473();
        boolean isArgumentOptional = function.getArgumentsBuilder() instanceof FunctionArguments.OptionalArgumentBuilder;
        helpComponent.method_27693(String.valueOf(class_124.field_1080) + "Type: " + String.valueOf(class_124.field_1068) + (function instanceof GenericFunction ? "Generic" : "Normal") + "\n");
        helpComponent.method_27693(String.valueOf(class_124.field_1080) + "Description: " + String.valueOf(class_124.field_1068) + function.getDescription() + "\n");
        helpComponent.method_27693(String.valueOf(class_124.field_1080) + "Aliases:" + String.valueOf(class_124.field_1068) + " [" + String.join((CharSequence)", ", function.getAliasList()) + "]\n");
        helpComponent.method_27693(String.valueOf(class_124.field_1080) + "Returns: " + String.valueOf(class_124.field_1068) + function.getReturnTypeName() + "\n");
        helpComponent.method_27693(String.valueOf(class_124.field_1080) + "Arguments:" + String.valueOf(class_124.field_1068) + " (" + (isArgumentOptional ? "Optional" : "Required") + ")");
        for (Argument<?> argument : function.getArgumentsBuilder().getArguments()) {
            Object type = isArgumentOptional ? "(%s, default: %s)".formatted(argument.getType().getSimpleName(), argument.getDefaultValue().toString()) : (argument instanceof ListArgument ? "(List<" + argument.getType().getSimpleName() + ">)" : "(" + argument.getType().getSimpleName() + ")");
            String argumentDescription = "\n - " + String.valueOf(class_124.field_1054) + argument.getName() + " " + (String)type + String.valueOf(class_124.field_1068) + ": " + function.getArgumentDescription(argument.getName());
            helpComponent.method_27693(argumentDescription);
        }
        class_5250 response = class_2561.method_43470((String)"Function Manual: ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)(function.getName() + "\n")).method_27692(class_124.field_1067)).method_10852((class_2561)helpComponent.method_27692(class_124.field_1068));
        ((class_2168)context.getSource()).method_9226(() -> FunctionCommand.lambda$helpForFunction$17((class_2561)response), false);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }

    private static /* synthetic */ class_2561 lambda$helpForFunction$17(class_2561 response) {
        return response;
    }

    private static /* synthetic */ class_2561 lambda$enableFunction$15(class_2561 response) {
        return response;
    }

    private static enum ListType {
        ALL,
        GENERIC,
        NORMAL;

    }
}

