/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions.templates;

import com.wynntils.core.consumers.functions.expressions.Expression;
import com.wynntils.core.consumers.functions.expressions.parser.ExpressionParser;
import com.wynntils.core.consumers.functions.templates.TemplatePart;
import com.wynntils.utils.type.ErrorOr;

public class ExpressionTemplatePart
extends TemplatePart {
    private final ErrorOr<Expression> expression;

    public ExpressionTemplatePart(String part) {
        super(part);
        if (!this.part.startsWith("{") || !this.part.endsWith("}")) {
            throw new IllegalArgumentException("Expression was not wrapped in curly braces.");
        }
        this.expression = ExpressionParser.tryParse(this.part.substring(1, this.part.length() - 1));
    }

    @Override
    public String getValue() {
        if (this.expression.hasError()) {
            return this.expression.getError();
        }
        ErrorOr<String> calculatedValue = this.expression.getValue().calculateFormattedString();
        if (calculatedValue.hasError()) {
            return calculatedValue.getError();
        }
        return calculatedValue.getValue();
    }

    @Override
    public String toString() {
        return "ExpressionTemplatePart{expressionString='" + String.valueOf(this.expression) + "'}";
    }
}

