/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;

public abstract class DynamicOverlay
extends Overlay {
    private final int id;

    protected DynamicOverlay(OverlayPosition position, float width, float height, int id) {
        super(position, width, height);
        this.id = id;
    }

    protected DynamicOverlay(OverlayPosition position, OverlaySize size, int id) {
        super(position, size);
        this.id = id;
    }

    protected DynamicOverlay(OverlayPosition position, OverlaySize size, HorizontalAlignment horizontalAlignmentOverride, VerticalAlignment verticalAlignmentOverride, int id) {
        super(position, size, horizontalAlignmentOverride, verticalAlignmentOverride);
        this.id = id;
    }

    protected DynamicOverlay(int id) {
        super(new OverlayPosition(0.0f, 0.0f, VerticalAlignment.MIDDLE, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.MIDDLE), new OverlaySize(100.0f, 20.0f), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
        this.id = id;
    }

    @Override
    public String getTranslatedName() {
        return this.getTranslation("name", this.id);
    }

    @Override
    public String getJsonName() {
        return super.getJsonName() + this.id;
    }

    @Override
    public boolean shouldBeEnabled() {
        if (!this.isParentEnabled()) {
            return false;
        }
        if (this.isUserEnabled() != null) {
            return this.isUserEnabled();
        }
        return true;
    }

    public int getId() {
        return this.id;
    }
}

