/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.DynamicOverlay;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.RenderState;
import com.wynntils.core.consumers.overlays.SectionCoordinates;
import com.wynntils.core.consumers.overlays.annotations.OverlayGroup;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.mod.CrashReportManager;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.core.persisted.config.OverlayGroupHolder;
import com.wynntils.mc.event.DisplayResizeEvent;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.mc.event.TitleScreenInitEvent;
import com.wynntils.screens.overlays.placement.OverlayManagementScreen;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_10209;
import net.minecraft.class_1041;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class OverlayManager
extends Manager {
    private static final class_4597.class_4598 BUFFER_SOURCE = class_4597.method_22991((class_9799)new class_9799(256));
    private final Map<Feature, List<Overlay>> overlayParentMap = new HashMap<Feature, List<Overlay>>();
    private final Map<Overlay, OverlayInfoContainer> overlayInfoMap = new HashMap<Overlay, OverlayInfoContainer>();
    private final Map<Feature, List<OverlayGroupHolder>> overlayGroupMap = new HashMap<Feature, List<OverlayGroupHolder>>();
    private final Set<Overlay> enabledOverlays = new HashSet<Overlay>();
    private final List<SectionCoordinates> sections = new ArrayList<SectionCoordinates>(9);
    private final Map<Class<?>, Integer> profilingTimes = new HashMap();
    private final Map<Class<?>, Integer> profilingCounts = new HashMap();

    public OverlayManager(CrashReportManager crashReportManager) {
        super(List.of(crashReportManager));
        this.addCrashCallbacks();
    }

    private void registerOverlay(Overlay overlay, Feature parent, RenderEvent.ElementType elementType, RenderState renderAt, boolean enabledByDefault) {
        this.overlayParentMap.putIfAbsent(parent, new LinkedList());
        this.overlayParentMap.get(parent).add(overlay);
        this.overlayInfoMap.put(overlay, new OverlayInfoContainer(parent, elementType, renderAt, enabledByDefault));
    }

    private void unregisterOverlay(Overlay overlay) {
        this.overlayParentMap.get(this.overlayInfoMap.get(overlay).parent()).remove(overlay);
        WynntilsMod.unregisterEventListener(overlay);
        this.overlayInfoMap.remove(overlay);
        this.enabledOverlays.remove(overlay);
    }

    public void disableOverlays(Feature parent) {
        this.overlayParentMap.getOrDefault(parent, List.of()).forEach(this::disableOverlay);
    }

    public void disableOverlay(Overlay disabledOverlay) {
        if (!this.isEnabled(disabledOverlay)) {
            return;
        }
        this.enabledOverlays.remove(disabledOverlay);
        WynntilsMod.unregisterEventListener(disabledOverlay);
        this.enabledOverlays.forEach(overlay -> overlay.getConfigOptionFromString("userEnabled").ifPresent(overlay::callOnConfigUpdate));
    }

    public void enableOverlays(Feature parent) {
        this.overlayParentMap.getOrDefault(parent, List.of()).forEach(this::enableOverlay);
    }

    public void enableOverlay(Overlay enableOverlay) {
        if (!enableOverlay.shouldBeEnabled() || this.isEnabled(enableOverlay)) {
            return;
        }
        this.enabledOverlays.add(enableOverlay);
        WynntilsMod.registerEventListener(enableOverlay);
        this.enabledOverlays.forEach(overlay -> overlay.getConfigOptionFromString("userEnabled").ifPresent(overlay::callOnConfigUpdate));
    }

    public void discoverOverlays(Feature feature) {
        Field[] overlayFields;
        for (Field overlayField : overlayFields = FieldUtils.getFieldsWithAnnotation(feature.getClass(), OverlayInfo.class)) {
            try {
                Object fieldValue = FieldUtils.readField((Field)overlayField, (Object)feature, (boolean)true);
                if (!(fieldValue instanceof Overlay)) {
                    throw new RuntimeException("A non-Overlay class was marked with OverlayInfo annotation.");
                }
                Overlay overlay = (Overlay)fieldValue;
                OverlayInfo annotation = overlayField.getAnnotation(OverlayInfo.class);
                Managers.Overlay.registerOverlay(overlay, feature, annotation.renderType(), annotation.renderAt(), annotation.enabled());
                if ($assertionsDisabled || !overlay.getTranslatedName().startsWith("feature.wynntils.")) continue;
                throw new AssertionError((Object)("Fix i18n for " + overlay.getTranslatedName()));
            }
            catch (IllegalAccessException e) {
                WynntilsMod.error("Unable to get field " + String.valueOf(overlayField), e);
            }
        }
    }

    public void discoverOverlayGroups(Feature feature) {
        List<OverlayGroupHolder> holders = Stream.of(feature.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(OverlayGroup.class)).map(field -> {
            OverlayGroup annotation = field.getAnnotation(OverlayGroup.class);
            return new OverlayGroupHolder((Field)field, feature, annotation.renderType(), annotation.renderAt(), annotation.instances());
        }).toList();
        holders.forEach(this::createOverlayGroupWithDefaults);
        this.overlayGroupMap.put(feature, holders);
    }

    public void createOverlayGroupWithDefaults(OverlayGroupHolder holder) {
        this.recreateGroupOverlaysWithIds(holder, IntStream.rangeClosed(1, holder.getDefaultCount()).boxed().toList());
    }

    public void createOverlayGroupWithIds(OverlayGroupHolder holder, List<Integer> ids) {
        this.recreateGroupOverlaysWithIds(holder, ids);
    }

    public int extendOverlayGroup(OverlayGroupHolder holder) {
        List<Integer> ids = holder.getOverlays().stream().map(overlay -> ((DynamicOverlay)overlay).getId()).collect(Collectors.toList());
        int newId = 1;
        while (ids.contains(newId)) {
            ++newId;
        }
        ids.add(newId);
        this.recreateGroupOverlaysWithIds(holder, ids);
        return newId;
    }

    public void removeIdFromOverlayGroup(OverlayGroupHolder holder, int id) {
        List<Integer> ids = holder.getOverlays().stream().map(overlay -> ((DynamicOverlay)overlay).getId()).collect(Collectors.toList());
        ids.remove((Object)id);
        this.recreateGroupOverlaysWithIds(holder, ids);
    }

    private void recreateGroupOverlaysWithIds(OverlayGroupHolder holder, List<Integer> ids) {
        holder.getOverlays().forEach(this::unregisterOverlay);
        holder.initGroup(ids);
        holder.getOverlays().forEach(overlay -> this.registerOverlay((Overlay)overlay, holder.getParent(), holder.getElementType(), holder.getRenderState(), true));
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        this.enabledOverlays.forEach(overlay -> {
            overlay.tick();
            overlay.updateEnabledCache();
        });
    }

    @SubscribeEvent
    public void onRenderPre(RenderEvent.Pre event) {
        class_10209.method_64146().method_15396("preRenOverlay");
        this.renderOverlays(event, RenderState.PRE);
        class_10209.method_64146().method_15407();
    }

    @SubscribeEvent
    public void onRenderPost(RenderEvent.Post event) {
        class_10209.method_64146().method_15396("postRenOverlay");
        this.renderOverlays(event, RenderState.POST);
        class_10209.method_64146().method_15407();
    }

    private void renderOverlays(RenderEvent event, RenderState renderState) {
        boolean showPreview = false;
        boolean renderNonSelected = true;
        boolean shouldRender = true;
        Overlay selectedOverlay = null;
        class_437 class_4372 = McUtils.mc().field_1755;
        if (class_4372 instanceof OverlayManagementScreen) {
            OverlayManagementScreen screen = (OverlayManagementScreen)class_4372;
            shouldRender = false;
            showPreview = screen.showPreview();
            renderNonSelected = screen.shouldRenderAllOverlays();
            selectedOverlay = screen.getSelectedOverlay();
        } else {
            OverlaySelectionScreen screen;
            class_4372 = McUtils.mc().field_1755;
            if (class_4372 instanceof OverlaySelectionScreen && (screen = (OverlaySelectionScreen)class_4372).renderingPreview()) {
                showPreview = true;
                renderNonSelected = screen.shouldShowOverlays();
                selectedOverlay = screen.getSelectedOverlay();
            }
        }
        LinkedList<Overlay> crashedOverlays = new LinkedList<Overlay>();
        for (Overlay overlay : this.enabledOverlays) {
            OverlayInfoContainer renderInfo = this.overlayInfoMap.get(overlay);
            if (renderInfo.elementType() != event.getType()) continue;
            if (renderInfo.renderState() == RenderState.REPLACE) {
                if (renderState != RenderState.PRE) continue;
                if (event instanceof ICancellableEvent) {
                    ICancellableEvent cancellableEvent = (ICancellableEvent)((Object)event);
                    cancellableEvent.setCanceled(true);
                }
            } else if (renderInfo.renderState() != renderState) continue;
            try {
                if (showPreview) {
                    if (selectedOverlay != null && overlay != selectedOverlay && !renderNonSelected) continue;
                    overlay.renderPreview(event.getGuiGraphics(), (class_4597)BUFFER_SOURCE, event.getDeltaTracker(), event.getWindow());
                    continue;
                }
                if (!shouldRender || !overlay.isRendered()) continue;
                long startTime = System.currentTimeMillis();
                overlay.renderOrErrorMessage(event.getGuiGraphics(), (class_4597)BUFFER_SOURCE, event.getDeltaTracker(), event.getWindow());
                this.logProfilingData(startTime, overlay);
            }
            catch (Throwable t) {
                RenderUtils.disableScissor(event.getGuiGraphics());
                RenderUtils.clearMask();
                crashedOverlays.add(overlay);
                WynntilsMod.reportCrash(CrashType.OVERLAY, overlay.getTranslatedName(), overlay.getClass().getName(), "render", t);
            }
        }
        BUFFER_SOURCE.method_22993();
        for (Overlay overlay : crashedOverlays) {
            overlay.getConfigOptionFromString("userEnabled").ifPresent(config -> config.setValue(false));
        }
    }

    private void logProfilingData(long startTime, Overlay overlay) {
        long endTime = System.currentTimeMillis();
        int timeSpent = (int)(endTime - startTime);
        int allTime = this.profilingTimes.getOrDefault(overlay.getClass(), 0);
        this.profilingTimes.put(overlay.getClass(), allTime + timeSpent);
        int allCount = this.profilingCounts.getOrDefault(overlay.getClass(), 0);
        this.profilingCounts.put(overlay.getClass(), allCount + 1);
    }

    public Map<Class<?>, Integer> getProfilingTimes() {
        return this.profilingTimes;
    }

    public Map<Class<?>, Integer> getProfilingCounts() {
        return this.profilingCounts;
    }

    public void resetProfiling() {
        this.profilingTimes.clear();
        this.profilingCounts.clear();
    }

    @SubscribeEvent
    public void onResizeEvent(DisplayResizeEvent event) {
        this.calculateSections();
    }

    @SubscribeEvent
    public void gameInitEvent(TitleScreenInitEvent.Post event) {
        this.calculateSections();
    }

    private void calculateSections() {
        class_1041 window = McUtils.window();
        int width = window.method_4486();
        int height = window.method_4502();
        int wT = width / 3;
        int hT = height / 3;
        this.sections.clear();
        for (int h = 0; h < 3; ++h) {
            for (int w = 0; w < 3; ++w) {
                this.sections.add(new SectionCoordinates(w * wT, h * hT, (w + 1) * wT, (h + 1) * hT));
            }
        }
    }

    private void addCrashCallbacks() {
        Managers.CrashReport.registerCrashContext("Loaded Overlays", () -> {
            StringBuilder result = new StringBuilder();
            for (Overlay overlay : this.enabledOverlays) {
                result.append("\n\t\t").append(overlay.getTranslatedName());
            }
            return result.toString();
        });
    }

    public SectionCoordinates getSection(OverlayPosition.AnchorSection section) {
        return this.sections.get(section.getIndex());
    }

    public List<SectionCoordinates> getSections() {
        return this.sections;
    }

    public Set<Overlay> getOverlays() {
        return this.overlayInfoMap.keySet();
    }

    public <T extends Overlay> T getOverlay(Class<T> overlayClass) {
        return (T)((Overlay)this.overlayInfoMap.keySet().stream().filter(overlayClass::isInstance).findFirst().orElse(null));
    }

    public Feature getOverlayParent(Overlay overlay) {
        return this.overlayInfoMap.get(overlay).parent();
    }

    public boolean isEnabled(Overlay overlay) {
        return this.enabledOverlays.contains(overlay);
    }

    public boolean isEnabledByDefault(Overlay overlay) {
        return this.overlayInfoMap.get(overlay).enabledByDefault();
    }

    public List<OverlayGroupHolder> getOverlayGroups() {
        return this.overlayGroupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Overlay> getFeatureOverlays(Feature feature) {
        return this.overlayParentMap.getOrDefault(feature, List.of());
    }

    public List<OverlayGroupHolder> getFeatureOverlayGroups(Feature feature) {
        return this.overlayGroupMap.getOrDefault(feature, List.of());
    }

    private record OverlayInfoContainer(Feature parent, RenderEvent.ElementType elementType, RenderState renderState, boolean enabledByDefault) {
    }
}

