/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.mod;

import com.wynntils.core.components.Manager;
import com.wynntils.mc.event.TickAlwaysEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class TickSchedulerManager
extends Manager {
    private final Map<ScheduledTask, Integer> tasks = new ConcurrentHashMap<ScheduledTask, Integer>();

    public TickSchedulerManager() {
        super(List.of());
    }

    public ScheduledTask scheduleLater(Runnable runnable, int ticksDelay) {
        ScheduledTask task = new ScheduledTask(runnable);
        this.tasks.put(task, ticksDelay);
        return task;
    }

    public ScheduledTask scheduleNextTick(Runnable runnable) {
        return this.scheduleLater(runnable, 0);
    }

    public void cancel(ScheduledTask task) {
        this.tasks.remove(task);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickAlwaysEvent e) {
        Iterator<Map.Entry<ScheduledTask, Integer>> it = this.tasks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ScheduledTask, Integer> entry = it.next();
            int ticksLeft = entry.getValue();
            if (ticksLeft == 0) {
                entry.getKey().task.run();
                it.remove();
                continue;
            }
            entry.setValue(ticksLeft - 1);
        }
    }

    public record ScheduledTask(Runnable task) {
    }
}

