/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.CoreComponent;
import com.wynntils.core.net.Dependency;
import com.wynntils.core.net.UrlId;
import java.io.Reader;
import java.util.Objects;
import java.util.function.Consumer;

public class QueuedDownload {
    private static final Consumer<Throwable> DEFAULT_ERROR_HANDLER = exception -> WynntilsMod.error("Error while processing download request; ignored");
    private final CoreComponent callerComponent;
    private final UrlId urlId;
    private final Dependency dependency;
    private Consumer<Reader> onCompletionReader;
    private Consumer<JsonObject> onCompletionJsonObject;
    private Consumer<JsonArray> onCompletionJsonArray;

    QueuedDownload(CoreComponent callerComponent, UrlId urlId, Dependency dependency) {
        this.callerComponent = callerComponent;
        this.urlId = urlId;
        this.dependency = dependency;
    }

    public void handleReader(Consumer<Reader> readerConsume) {
        this.onCompletionReader = readerConsume;
        this.onCompletionJsonObject = null;
        this.onCompletionJsonArray = null;
    }

    public void handleJsonObject(Consumer<JsonObject> jsonObjectConsume) {
        this.onCompletionJsonObject = jsonObjectConsume;
        this.onCompletionReader = null;
        this.onCompletionJsonArray = null;
    }

    public void handleJsonArray(Consumer<JsonArray> jsonArrayConsume) {
        this.onCompletionJsonArray = jsonArrayConsume;
        this.onCompletionReader = null;
        this.onCompletionJsonObject = null;
    }

    public CoreComponent callerComponent() {
        return this.callerComponent;
    }

    public UrlId urlId() {
        return this.urlId;
    }

    public Dependency dependency() {
        return this.dependency;
    }

    public Consumer<Reader> onCompletionReader() {
        return this.onCompletionReader;
    }

    public Consumer<JsonObject> onCompletionJsonObject() {
        return this.onCompletionJsonObject;
    }

    public Consumer<JsonArray> onCompletionJsonArray() {
        return this.onCompletionJsonArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueuedDownload that = (QueuedDownload)o;
        return Objects.equals(this.callerComponent, that.callerComponent) && this.urlId == that.urlId && Objects.equals(this.dependency, that.dependency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.callerComponent, this.urlId, this.dependency});
    }

    public String toString() {
        return "QueuedDownload{callerComponent=" + String.valueOf(this.callerComponent) + ", urlId=" + String.valueOf((Object)this.urlId) + ", dependency=" + String.valueOf(this.dependency) + "}";
    }
}

