/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.upfixers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.persisted.PersistedValue;
import com.wynntils.core.persisted.upfixers.Upfixer;
import com.wynntils.core.persisted.upfixers.UpfixerType;
import com.wynntils.core.persisted.upfixers.config.CombatXpGainToXpGainUpfixer;
import com.wynntils.core.persisted.upfixers.config.CustomBankQuickJumpsBankNameUpfixer;
import com.wynntils.core.persisted.upfixers.config.CustomBankQuickJumpsUpfixer;
import com.wynntils.core.persisted.upfixers.config.CustomCommandKeybindSlashStartUpfixer;
import com.wynntils.core.persisted.upfixers.config.CustomPoiIconEnumBugUpfixer;
import com.wynntils.core.persisted.upfixers.config.CustomPoiVisbilityUpfixer;
import com.wynntils.core.persisted.upfixers.config.DurabilityArcToDurabilityOverlayUpfixer;
import com.wynntils.core.persisted.upfixers.config.EnumNamingUpfixer;
import com.wynntils.core.persisted.upfixers.config.GameBarOverlayMoveUpfixer;
import com.wynntils.core.persisted.upfixers.config.HideDamageLabelsToHideLabelsUpfixer;
import com.wynntils.core.persisted.upfixers.config.ItemHighlightFeatureCosmeticToStoreUpfixer;
import com.wynntils.core.persisted.upfixers.config.MapToMainMapRenamedConfigsUpfixer;
import com.wynntils.core.persisted.upfixers.config.MobTotemTimerOverlayFeatureToBonusTotemTimerOverlayFeature;
import com.wynntils.core.persisted.upfixers.config.MythicBlockerToChestBlockerUpfixer;
import com.wynntils.core.persisted.upfixers.config.MythicFoundToValuableFoundUpfixer;
import com.wynntils.core.persisted.upfixers.config.NpcDialoguesOverlayConfigsMovedUpfixer;
import com.wynntils.core.persisted.upfixers.config.NpcDialoguesRenamedUpfixer;
import com.wynntils.core.persisted.upfixers.config.OverlayConfigsIntegrationUpfixer;
import com.wynntils.core.persisted.upfixers.config.OverlayRestructuringUpfixer;
import com.wynntils.core.persisted.upfixers.config.ProfessionBadgesToLeaderboardBadgesUpfixer;
import com.wynntils.core.persisted.upfixers.config.QuestBookToContentRenamedConfigsUpfixer;
import com.wynntils.core.persisted.upfixers.config.SacredSurgeToHolyPowerUpfixer;
import com.wynntils.core.persisted.upfixers.config.TowerAuraVignetteAndOverlayMovedToCommonFeature;
import com.wynntils.core.persisted.upfixers.config.TowerAuraVignetteNameUpfixer;
import com.wynntils.core.persisted.upfixers.config.TradeMarketAutoOpenChatToTradeMarketQuickSearchUpfixer;
import com.wynntils.core.persisted.upfixers.config.UniversalBarOverlayColorToColorTemplateUpfixer;
import com.wynntils.core.persisted.upfixers.config.WynntilsContentBookReplaceToShiftBehaviourUpfixer;
import com.wynntils.core.persisted.upfixers.storage.BankToAccountBankUpfixer;
import com.wynntils.core.persisted.upfixers.storage.UpdateChangelogToModelUpfixer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UpfixerManager
extends Manager {
    public static final String UPFIXER_JSON_MEMBER_NAME = "wynntils.upfixers";
    private final List<Upfixer> configUpfixers = new ArrayList<Upfixer>();
    private final List<Upfixer> storageUpfixers = new ArrayList<Upfixer>();

    public UpfixerManager() {
        super(List.of());
        this.registerConfigUpfixer(new CustomPoiVisbilityUpfixer());
        this.registerConfigUpfixer(new CustomCommandKeybindSlashStartUpfixer());
        this.registerConfigUpfixer(new GameBarOverlayMoveUpfixer());
        this.registerConfigUpfixer(new EnumNamingUpfixer());
        this.registerConfigUpfixer(new CustomPoiIconEnumBugUpfixer());
        this.registerConfigUpfixer(new QuestBookToContentRenamedConfigsUpfixer());
        this.registerConfigUpfixer(new MapToMainMapRenamedConfigsUpfixer());
        this.registerConfigUpfixer(new OverlayRestructuringUpfixer());
        this.registerConfigUpfixer(new OverlayConfigsIntegrationUpfixer());
        this.registerConfigUpfixer(new CustomBankQuickJumpsUpfixer());
        this.registerConfigUpfixer(new CustomBankQuickJumpsBankNameUpfixer());
        this.registerConfigUpfixer(new NpcDialoguesRenamedUpfixer());
        this.registerConfigUpfixer(new NpcDialoguesOverlayConfigsMovedUpfixer());
        this.registerConfigUpfixer(new TowerAuraVignetteNameUpfixer());
        this.registerConfigUpfixer(new TowerAuraVignetteAndOverlayMovedToCommonFeature());
        this.registerConfigUpfixer(new CombatXpGainToXpGainUpfixer());
        this.registerConfigUpfixer(new ProfessionBadgesToLeaderboardBadgesUpfixer());
        this.registerConfigUpfixer(new TradeMarketAutoOpenChatToTradeMarketQuickSearchUpfixer());
        this.registerConfigUpfixer(new SacredSurgeToHolyPowerUpfixer());
        this.registerConfigUpfixer(new UniversalBarOverlayColorToColorTemplateUpfixer());
        this.registerConfigUpfixer(new WynntilsContentBookReplaceToShiftBehaviourUpfixer());
        this.registerConfigUpfixer(new DurabilityArcToDurabilityOverlayUpfixer());
        this.registerConfigUpfixer(new MobTotemTimerOverlayFeatureToBonusTotemTimerOverlayFeature());
        this.registerConfigUpfixer(new ItemHighlightFeatureCosmeticToStoreUpfixer());
        this.registerConfigUpfixer(new HideDamageLabelsToHideLabelsUpfixer());
        this.registerConfigUpfixer(new MythicFoundToValuableFoundUpfixer());
        this.registerConfigUpfixer(new MythicBlockerToChestBlockerUpfixer());
        this.registerStorageUpfixer(new BankToAccountBankUpfixer());
        this.registerStorageUpfixer(new UpdateChangelogToModelUpfixer());
    }

    private void registerConfigUpfixer(Upfixer upfixer) {
        this.configUpfixers.add(upfixer);
    }

    private void registerStorageUpfixer(Upfixer upfixer) {
        this.storageUpfixers.add(upfixer);
    }

    public boolean runUpfixers(JsonObject persistedObject, Set<PersistedValue<?>> persistedValues, UpfixerType upfixerType) {
        List<Upfixer> missingUpfixers = this.getMissingUpfixers(persistedObject, upfixerType);
        boolean anyChange = false;
        for (Upfixer upfixer : missingUpfixers) {
            try {
                if (!upfixer.apply(persistedObject, persistedValues)) continue;
                anyChange = true;
                this.addUpfixerToPersistedFile(persistedObject, upfixer);
                WynntilsMod.info("Applied upfixer \"" + upfixer.getUpfixerName() + "\" to " + upfixerType.name().toLowerCase(Locale.ROOT) + " file.");
            }
            catch (Throwable t) {
                WynntilsMod.warn("Failed to apply upfixer \"" + upfixer.getUpfixerName() + "\" to " + upfixerType.name().toLowerCase(Locale.ROOT) + " file!", t);
            }
        }
        return anyChange;
    }

    private void addUpfixerToPersistedFile(JsonObject configObject, Upfixer upfixer) {
        JsonElement upfixers = configObject.get(UPFIXER_JSON_MEMBER_NAME);
        if (upfixers == null || upfixers.isJsonNull()) {
            upfixers = new JsonArray();
            configObject.add(UPFIXER_JSON_MEMBER_NAME, upfixers);
        } else if (!upfixers.isJsonArray()) {
            WynntilsMod.warn("Invalid upfixer JSON member in config file! Expected array, got " + upfixers.getClass().getSimpleName());
            upfixers = new JsonArray();
            configObject.add(UPFIXER_JSON_MEMBER_NAME, upfixers);
        }
        upfixers.getAsJsonArray().add(upfixer.getUpfixerName());
    }

    private List<Upfixer> getMissingUpfixers(JsonObject persistedObject, UpfixerType type) {
        List<Upfixer> typeUpfixers;
        List<Upfixer> list = typeUpfixers = type == UpfixerType.CONFIG ? this.configUpfixers : this.storageUpfixers;
        if (!persistedObject.has(UPFIXER_JSON_MEMBER_NAME)) {
            return typeUpfixers;
        }
        JsonElement upfixersJson = persistedObject.get(UPFIXER_JSON_MEMBER_NAME);
        if (upfixersJson == null || upfixersJson.isJsonNull()) {
            return typeUpfixers;
        }
        if (!upfixersJson.isJsonArray()) {
            WynntilsMod.warn("Invalid upfixer JSON member in " + type.name().toLowerCase(Locale.ROOT) + " file! Expected array, got " + upfixersJson.getClass().getSimpleName());
            return typeUpfixers;
        }
        ArrayList<String> appliedUpfixers = new ArrayList<String>();
        for (JsonElement upfixer2 : upfixersJson.getAsJsonArray()) {
            appliedUpfixers.add(upfixer2.getAsString());
        }
        return typeUpfixers.stream().filter(upfixer -> !appliedUpfixers.contains(upfixer.getUpfixerName())).toList();
    }
}

