/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.upfixers.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.wynntils.core.persisted.PersistedValue;
import com.wynntils.core.persisted.upfixers.Upfixer;
import java.util.Set;

public class UniversalBarOverlayColorToColorTemplateUpfixer
implements Upfixer {
    private static final String OVERLAY_GROUPS_KEY = "overlayGroups";
    private static final String UNIVERSAL_BAR_IDS_KEY = "customBarsOverlayFeature.groupedOverlay.customUniversalBarOverlays.ids";
    private static final String UNIVERSAL_BAR_COLOR_KEY = "customBarsOverlayFeature.universalTexturedCustomBarOverlay%s.color";
    private static final String UNIVERSAL_BAR_COLOR_TEMPLATE_KEY = "customBarsOverlayFeature.universalTexturedCustomBarOverlay%s.colorTemplate";

    @Override
    public boolean apply(JsonObject configObject, Set<PersistedValue<?>> persisteds) {
        JsonObject overlayGroups;
        if (configObject.has(OVERLAY_GROUPS_KEY) && (overlayGroups = configObject.getAsJsonObject(OVERLAY_GROUPS_KEY)).has(UNIVERSAL_BAR_IDS_KEY)) {
            JsonArray ids = overlayGroups.getAsJsonArray(UNIVERSAL_BAR_IDS_KEY);
            ids.forEach(id -> {
                String barColorKey = String.format(UNIVERSAL_BAR_COLOR_KEY, id.getAsString());
                if (configObject.has(barColorKey)) {
                    String value = configObject.get(barColorKey).getAsString();
                    String barColorTemplateKey = String.format(UNIVERSAL_BAR_COLOR_TEMPLATE_KEY, id.getAsString());
                    configObject.addProperty(barColorTemplateKey, "from_hex(\"" + value + "\")");
                }
            });
        }
        return true;
    }
}

