/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.wynn.WynnUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public final class StyledTextPart {
    private final String text;
    private final PartStyle style;
    private final StyledText parent;

    public StyledTextPart(String text, class_2583 style, StyledText parent, class_2583 parentStyle) {
        this.parent = parent;
        this.text = text;
        this.style = PartStyle.fromStyle(style, this, parentStyle);
    }

    StyledTextPart(StyledTextPart part, StyledText parent) {
        this.text = part.text;
        this.style = new PartStyle(part.style, this);
        this.parent = parent;
    }

    private StyledTextPart(StyledTextPart part, PartStyle style, StyledText parent) {
        this.text = part.text;
        this.style = style;
        this.parent = parent;
    }

    static List<StyledTextPart> fromCodedString(String codedString, class_2583 style, StyledText parent, class_2583 parentStyle) {
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        class_2583 currentStyle = style;
        StringBuilder currentString = new StringBuilder();
        boolean nextIsFormatting = false;
        StringBuilder hexColorFormatting = new StringBuilder();
        boolean clickEventPrefix = false;
        boolean hoverEventPrefix = false;
        Object eventIndexString = "";
        for (char current : codedString.toCharArray()) {
            if (nextIsFormatting) {
                nextIsFormatting = false;
                if (parent != null) {
                    if (current == '[') {
                        clickEventPrefix = true;
                        continue;
                    }
                    if (current == '<') {
                        hoverEventPrefix = true;
                        continue;
                    }
                }
                if (current == '#') {
                    hexColorFormatting.append(current);
                    continue;
                }
                class_124 formatting = class_124.method_544((char)current);
                if (formatting == null) {
                    currentString.append('\u00a7');
                    currentString.append(current);
                    continue;
                }
                if (!currentString.isEmpty()) {
                    if (style != class_2583.field_24360) {
                        currentStyle = currentStyle.method_10958(style.method_10970()).method_10949(style.method_10969());
                    }
                    parts.add(new StyledTextPart(currentString.toString(), currentStyle, null, parentStyle));
                    currentString = new StringBuilder();
                }
                if (formatting.method_543()) {
                    currentStyle = class_2583.field_24360.method_10977(formatting);
                    continue;
                }
                currentStyle = currentStyle.method_27706(formatting);
                continue;
            }
            if (clickEventPrefix || hoverEventPrefix) {
                class_2568 hoverEvent;
                class_2558 clickEvent;
                if (Character.isDigit(current)) {
                    eventIndexString = (String)eventIndexString + current;
                    continue;
                }
                class_2583 oldStyle = null;
                if (clickEventPrefix && current == ']' && (clickEvent = parent.getClickEvent(Integer.parseInt((String)eventIndexString))) != null) {
                    oldStyle = currentStyle;
                    currentStyle = currentStyle.method_10958(clickEvent);
                    clickEventPrefix = false;
                    eventIndexString = "";
                }
                if (hoverEventPrefix && current == '>' && (hoverEvent = parent.getHoverEvent(Integer.parseInt((String)eventIndexString))) != null) {
                    oldStyle = currentStyle;
                    currentStyle = currentStyle.method_10949(hoverEvent);
                    hoverEventPrefix = false;
                    eventIndexString = "";
                }
                if (oldStyle != null) {
                    if (currentString.isEmpty()) continue;
                    if (style != class_2583.field_24360) {
                        currentStyle = currentStyle.method_10958(style.method_10970()).method_10949(style.method_10969());
                    }
                    parts.add(new StyledTextPart(currentString.toString(), oldStyle, null, parentStyle));
                    currentString = new StringBuilder();
                    continue;
                }
                currentString.append(clickEventPrefix ? (char)'[' : '<');
                currentString.append((String)eventIndexString);
                currentString.append(current);
                clickEventPrefix = false;
                hoverEventPrefix = false;
                eventIndexString = "";
                continue;
            }
            if (!hexColorFormatting.isEmpty()) {
                hexColorFormatting.append(current);
                if (hexColorFormatting.length() != 9) continue;
                CustomColor customColor = CustomColor.fromHexString(hexColorFormatting.toString());
                if (customColor == CustomColor.NONE) {
                    currentString.append((CharSequence)hexColorFormatting);
                } else if (!currentString.isEmpty()) {
                    if (style != class_2583.field_24360) {
                        currentStyle = currentStyle.method_10958(style.method_10970()).method_10949(style.method_10969());
                    }
                    parts.add(new StyledTextPart(currentString.toString(), currentStyle, null, parentStyle));
                    currentString = new StringBuilder();
                }
                currentStyle = currentStyle.method_36139(customColor.asInt());
                hexColorFormatting = new StringBuilder();
                continue;
            }
            if (current == '\u00a7') {
                nextIsFormatting = true;
                continue;
            }
            currentString.append(current);
        }
        if (!currentString.isEmpty()) {
            if (style != class_2583.field_24360) {
                currentStyle = currentStyle.method_10958(style.method_10970()).method_10949(style.method_10969());
            }
            parts.add(new StyledTextPart(currentString.toString(), currentStyle, null, parentStyle));
        }
        return parts;
    }

    static List<StyledTextPart> fromJson(JsonArray jsonArray) {
        if (jsonArray.isEmpty()) {
            return List.of(new StyledTextPart("", class_2583.field_24360, null, class_2583.field_24360));
        }
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        for (JsonElement element : jsonArray) {
            if (!element.isJsonObject()) continue;
            class_2583 style = class_2583.field_24360;
            JsonObject jsonObject = element.getAsJsonObject();
            Object text = jsonObject.get("text").getAsString();
            if (jsonObject.has("bold")) {
                style = style.method_10982(Boolean.valueOf(true));
            }
            if (jsonObject.has("italic")) {
                style = style.method_10978(Boolean.valueOf(true));
            }
            if (jsonObject.has("underline")) {
                style = style.method_30938(Boolean.valueOf(true));
            }
            if (jsonObject.has("strikethrough")) {
                style = style.method_36140(Boolean.valueOf(true));
            }
            if (jsonObject.has("font")) {
                style = style.method_27704(class_2960.method_60656((String)jsonObject.get("font").getAsString()));
            }
            if (jsonObject.has("color")) {
                style = style.method_36139(CustomColor.fromHexString(jsonObject.get("color").getAsString()).asInt());
            }
            if (jsonObject.has("margin-left")) {
                String marginType = jsonObject.get("margin-left").getAsString();
                if (marginType.equals("thin")) {
                    text = "\u00c0" + (String)text;
                } else if (marginType.equals("large")) {
                    text = "\u00c0\u00c0\u00c0\u00c0" + (String)text;
                }
            }
            parts.add(new StyledTextPart((String)text, style, null, class_2583.field_24360));
        }
        return parts;
    }

    public String getString(PartStyle previousStyle, PartStyle.StyleType type) {
        return this.style.asString(previousStyle, type) + this.text;
    }

    public StyledText getParent() {
        return this.parent;
    }

    public PartStyle getPartStyle() {
        return this.style;
    }

    public StyledTextPart withStyle(PartStyle style) {
        return new StyledTextPart(this, style, this.parent);
    }

    public StyledTextPart withStyle(Function<PartStyle, PartStyle> function) {
        return this.withStyle(function.apply(this.style));
    }

    public class_5250 getComponent() {
        return class_2561.method_43470((String)this.text).method_27696(this.style.getStyle());
    }

    StyledTextPart asNormalized() {
        return new StyledTextPart(WynnUtils.normalizeBadString(this.text), this.style.getStyle(), this.parent, null);
    }

    StyledTextPart stripLeading() {
        return new StyledTextPart(this.text.stripLeading(), this.style.getStyle(), this.parent, null);
    }

    StyledTextPart stripTrailing() {
        return new StyledTextPart(this.text.stripTrailing(), this.style.getStyle(), this.parent, null);
    }

    boolean isEmpty() {
        return this.text.isEmpty();
    }

    boolean isBlank() {
        return this.text.isBlank();
    }

    public int length() {
        return this.text.length();
    }

    public String toString() {
        return "StyledTextPart[text=" + this.text + ", style=" + String.valueOf(this.style) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyledTextPart that = (StyledTextPart)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.style, that.style);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.style);
    }
}

