/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.KeyInputEvent;
import com.wynntils.mc.mixin.accessors.ChatScreenAccessor;
import com.wynntils.mc.mixin.accessors.ItemStackInfoAccessor;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.models.items.properties.ShinyItemProperty;
import com.wynntils.screens.itemsharing.ItemSharingScreen;
import com.wynntils.screens.itemsharing.SavedItemsScreen;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.IterationDecision;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.CHAT)
public class ChatItemFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind shareItemKeybind = new KeyBind("Share Item", 292, true, null, slot -> this.shareItem((class_1735)slot, true));
    @RegisterKeyBind
    private final KeyBind saveItemKeybind = new KeyBind("Save Item to Item Record", 295, true, null, slot -> this.shareItem((class_1735)slot, false));
    @RegisterKeyBind
    private final KeyBind itemRecordKeybind = new KeyBind("Open Item Record", -1, true, () -> McUtils.mc().method_1507(SavedItemsScreen.create()));
    @Persisted
    private final Config<Boolean> showSharingScreen = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showPerfectOrDefective = new Config<Boolean>(true);
    private final Map<String, String> chatItems = new HashMap<String, String>();

    @SubscribeEvent
    public void onKeyTyped(KeyInputEvent e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        class_437 class_4372 = McUtils.mc().field_1755;
        if (!(class_4372 instanceof class_408)) {
            return;
        }
        class_408 chatScreen = (class_408)class_4372;
        class_342 chatInput = ((ChatScreenAccessor)chatScreen).getChatInput();
        if (!(this.chatItems.isEmpty() || e.getKey() != 257 && e.getKey() != 335)) {
            for (Map.Entry<String, String> item : this.chatItems.entrySet()) {
                chatInput.method_1852(chatInput.method_1882().replace("<" + item.getKey() + ">", item.getValue()));
            }
            this.chatItems.clear();
            return;
        }
        Matcher matcher = Models.ItemEncoding.getEncodedDataPattern().matcher(chatInput.method_1882());
        while (matcher.find()) {
            String itemName = matcher.group("name");
            EncodedByteBuffer encodedByteBuffer = EncodedByteBuffer.fromUtf16String(matcher.group("data"));
            ErrorOr<WynnItem> errorOrDecodedItem = Models.ItemEncoding.decodeItem(encodedByteBuffer, itemName);
            String name = this.getItemName(errorOrDecodedItem);
            chatInput.method_1852(chatInput.method_1882().replace(matcher.group(), "<" + name + ">"));
            this.chatItems.put(name, matcher.group());
        }
    }

    private String getItemName(ErrorOr<WynnItem> errorOrDecodedItem) {
        Object name;
        if (errorOrDecodedItem.hasError()) {
            name = "encoding_error";
        } else {
            WynnItem decodedItem = errorOrDecodedItem.getValue();
            name = decodedItem.getClass().getSimpleName();
            if (decodedItem instanceof NamedItemProperty) {
                NamedItemProperty namedItemProperty = (NamedItemProperty)((Object)decodedItem);
                name = namedItemProperty.getName();
            }
        }
        while (this.chatItems.containsKey(name)) {
            name = (String)name + "_";
        }
        return name;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatReceived(ChatMessageEvent.Edit e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        StyledText message = e.getMessage();
        StyledText unwrapped = StyledTextUtils.unwrap(message);
        StyledText modified = unwrapped.iterate((part, changes) -> {
            this.decodeChatEncoding((List<StyledTextPart>)changes, (StyledTextPart)part);
            return IterationDecision.CONTINUE;
        });
        if (modified.equals(unwrapped)) {
            return;
        }
        e.setMessage(modified);
    }

    private void shareItem(class_1735 hoveredSlot, boolean share) {
        if (hoveredSlot == null) {
            return;
        }
        Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(hoveredSlot.method_7677(), GearItem.class);
        if (gearItemOpt.isPresent() && gearItemOpt.get().isUnidentified()) {
            WynntilsMod.warn("Cannot make chat link of unidentified gear");
            McUtils.sendErrorToClient(class_1074.method_4662((String)"feature.wynntils.chatItem.chatItemUnidentifiedError", (Object[])new Object[0]));
            return;
        }
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(hoveredSlot.method_7677());
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        if (!Models.ItemEncoding.canEncodeItem(wynnItemOpt.get())) {
            return;
        }
        if (share) {
            if (((Boolean)this.showSharingScreen.get()).booleanValue()) {
                McUtils.mc().method_1507(ItemSharingScreen.create(wynnItemOpt.get(), hoveredSlot.method_7677()));
            } else {
                this.makeChatPrompt(wynnItemOpt.get());
            }
        } else {
            class_1799 itemStackToSave = hoveredSlot.method_7677();
            WynnItem wynnItem = wynnItemOpt.get();
            if (wynnItem instanceof GearItem) {
                GearItem gearItem = (GearItem)wynnItem;
                itemStackToSave = new FakeItemStack(gearItem, "From " + McUtils.playerName() + "'s Item Record");
            }
            Services.ItemRecord.saveItem(wynnItemOpt.get(), itemStackToSave, hoveredSlot.method_7677().method_7964());
        }
    }

    private void decodeChatEncoding(List<StyledTextPart> changes, StyledTextPart partToReplace) {
        Matcher matcher = Models.ItemEncoding.getEncodedDataPattern().matcher(partToReplace.getString(null, PartStyle.StyleType.NONE));
        while (matcher.find()) {
            String itemName = matcher.group("name");
            EncodedByteBuffer encodedByteBuffer = EncodedByteBuffer.fromUtf16String(matcher.group("data"));
            ErrorOr<WynnItem> errorOrDecodedItem = Models.ItemEncoding.decodeItem(encodedByteBuffer, itemName);
            String unformattedString = partToReplace.getString(null, PartStyle.StyleType.NONE);
            String firstPart = unformattedString.substring(0, matcher.start());
            String lastPart = unformattedString.substring(matcher.end());
            PartStyle partStyle = partToReplace.getPartStyle();
            StyledTextPart first = new StyledTextPart(firstPart, partStyle.getStyle(), null, class_2583.field_24360);
            List<StyledTextPart> replacedParts = errorOrDecodedItem.hasError() ? List.of(this.createErrorPart(matcher.group(), errorOrDecodedItem.getError())) : this.createItemPart(errorOrDecodedItem.getValue());
            StyledTextPart last = new StyledTextPart(lastPart, partStyle.getStyle(), null, class_2583.field_24360);
            changes.remove(partToReplace);
            changes.add(first);
            changes.addAll(replacedParts);
            changes.add(last);
            partToReplace = last;
            matcher = Models.ItemEncoding.getEncodedDataPattern().matcher(lastPart);
        }
    }

    private StyledTextPart createErrorPart(String originalString, String error) {
        class_2583 style = class_2583.field_24360.method_27706(class_124.field_1073).method_10977(class_124.field_1061);
        class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)error).method_27692(class_124.field_1061));
        style = style.method_10949(hoverEvent);
        return new StyledTextPart(originalString, style, null, class_2583.field_24360);
    }

    private List<StyledTextPart> createItemPart(WynnItem wynnItem) {
        ShinyItemProperty shinyItemProperty;
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        StyledText nameText = StyledText.fromString(wynnItem.getClass().getSimpleName());
        if (wynnItem instanceof NamedItemProperty) {
            NamedItemProperty namedItemProperty = (NamedItemProperty)((Object)wynnItem);
            nameText = StyledText.fromString(namedItemProperty.getName());
            if (((Boolean)this.showPerfectOrDefective.get()).booleanValue() && wynnItem instanceof IdentifiableItemProperty) {
                IdentifiableItemProperty identifiableItemProperty = (IdentifiableItemProperty)((Object)wynnItem);
                if (identifiableItemProperty.isPerfect()) {
                    nameText = StyledText.fromComponent((class_2561)ComponentUtils.makeRainbowStyle("Perfect " + nameText.getString(), true));
                } else if (identifiableItemProperty.isDefective()) {
                    nameText = StyledText.fromComponent((class_2561)ComponentUtils.makeObfuscated("Defective " + nameText.getString(), 0.0f, 0.0f));
                }
            }
        }
        if (wynnItem instanceof ShinyItemProperty && (shinyItemProperty = (ShinyItemProperty)((Object)wynnItem)).getShinyStat().isPresent()) {
            parts.add(new StyledTextPart("\u2b21 ", class_2583.field_24360.method_10977(class_124.field_1068), null, class_2583.field_24360));
        }
        class_2583 style = class_2583.field_24360.method_27706(class_124.field_1073).method_10977(class_124.field_1065);
        if (wynnItem instanceof GearTierItemProperty) {
            GearTierItemProperty tierItemProperty = (GearTierItemProperty)((Object)wynnItem);
            style = style.method_10977(tierItemProperty.getGearTier().getChatFormatting());
        }
        FakeItemStack itemStack = new FakeItemStack(wynnItem, "From chat");
        class_2568.class_5249 itemHoverEvent = new class_2568.class_5249((class_1799)itemStack);
        ((ItemStackInfoAccessor)itemHoverEvent).setItemStack(itemStack);
        style = style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)itemHoverEvent));
        StyledText appenedNameText = StyledText.fromComponent((class_2561)class_2561.method_43473().method_27696(style).method_10852((class_2561)nameText.getComponent()));
        parts.addAll(Arrays.stream(appenedNameText.getPartsAsTextArray()).map(StyledText::getFirstPart).map(part -> part.withStyle(part.getPartStyle().withUnderlined(true))).toList());
        return parts;
    }

    private void makeChatPrompt(WynnItem wynnItem) {
        EncodingSettings encodingSettings = new EncodingSettings((Boolean)Models.ItemEncoding.extendedIdentificationEncoding.get(), false);
        ErrorOr<EncodedByteBuffer> errorOrEncodedByteBuffer = Models.ItemEncoding.encodeItem(wynnItem, encodingSettings);
        if (errorOrEncodedByteBuffer.hasError()) {
            WynntilsMod.error("Failed to encode item: " + errorOrEncodedByteBuffer.getError());
            McUtils.sendErrorToClient(class_1074.method_4662((String)"feature.wynntils.chatItem.chatItemErrorEncode", (Object[])new Object[]{errorOrEncodedByteBuffer.getError()}));
            return;
        }
        if (WynntilsMod.isDevelopmentEnvironment()) {
            WynntilsMod.info("Encoded item: " + String.valueOf(errorOrEncodedByteBuffer.getValue()));
            WynntilsMod.info("Encoded item UTF-16: " + errorOrEncodedByteBuffer.getValue().toUtf16String());
        }
        McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"feature.wynntils.chatItem.chatItemMessage").method_27692(class_124.field_1077).method_27692(class_124.field_1073).method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_21462, Models.ItemEncoding.makeItemString(wynnItem, (EncodedByteBuffer)errorOrEncodedByteBuffer.getValue())))).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"feature.wynntils.chatItem.chatItemTooltip").method_27692(class_124.field_1062)))));
    }
}

