/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.google.common.collect.Sets;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.mc.event.ChatScreenKeyTypedEvent;
import com.wynntils.mc.event.ChatScreenSendEvent;
import com.wynntils.mc.event.ScreenFocusEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.ScreenRenderEvent;
import com.wynntils.mc.event.SystemMessageEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.screens.chattabs.widgets.ChatTabButton;
import com.wynntils.screens.chattabs.widgets.ChatTabSettingsButton;
import com.wynntils.services.chat.ChatTab;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.CHAT)
public class ChatTabsFeature
extends Feature {
    @Persisted
    public final HiddenConfig<List<ChatTab>> chatTabs = new HiddenConfig<ArrayList<ChatTab>>(new ArrayList<ChatTab>(List.of(new ChatTab("All", false, null, null, null), new ChatTab("Global", false, null, Sets.newHashSet((Object[])new RecipientType[]{RecipientType.GLOBAL}), null), new ChatTab("Local", false, null, Sets.newHashSet((Object[])new RecipientType[]{RecipientType.LOCAL}), null), new ChatTab("Guild", false, "/g  ", Sets.newHashSet((Object[])new RecipientType[]{RecipientType.GUILD}), null), new ChatTab("Party", false, "/p  ", Sets.newHashSet((Object[])new RecipientType[]{RecipientType.PARTY}), null), new ChatTab("Private", false, "/r  ", Sets.newHashSet((Object[])new RecipientType[]{RecipientType.PRIVATE}), null), new ChatTab("Shout", false, null, Sets.newHashSet((Object[])new RecipientType[]{RecipientType.SHOUT}), null))));
    @Persisted
    private final Config<Boolean> oldTabHotkey = new Config<Boolean>(false);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChatReceived(ChatMessageEvent.Discard event) {
        event.setCanceled(true);
        Services.ChatTab.handleIncomingMessage(event.getRecipientType(), event.getMessage(), event.getMessage());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientsideChat(SystemMessageEvent.ChatReceivedEvent event) {
        if (Services.ChatTab.getFocusedTab() == null) {
            return;
        }
        event.setCanceled(true);
        boolean isRenderThread = McUtils.mc().method_18854();
        if (isRenderThread) {
            Services.ChatTab.handleIncomingMessage(RecipientType.CLIENTSIDE, event.getOriginalStyledText(), event.getStyledText());
        } else {
            Managers.TickScheduler.scheduleNextTick(() -> Services.ChatTab.handleIncomingMessage(RecipientType.CLIENTSIDE, event.getOriginalStyledText(), event.getStyledText()));
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_408) {
            class_408 chatScreen = (class_408)class_4372;
            int xOffset = 0;
            chatScreen.method_37063((class_364)new ChatTabSettingsButton(xOffset + 2, chatScreen.field_22790 - 35, 12, 13));
            xOffset += 15;
            for (ChatTab chatTab : Services.ChatTab.getTabs().toList()) {
                chatScreen.method_37063((class_364)new ChatTabButton(xOffset + 2, chatScreen.field_22790 - 35, 40, 13, chatTab));
                xOffset += 43;
            }
        }
    }

    @SubscribeEvent
    public void onScreenFocusChange(ScreenFocusEvent event) {
        if (!(event.getScreen() instanceof class_408)) {
            return;
        }
        class_364 guiEventListener = event.getGuiEventListener();
        if (guiEventListener instanceof ChatTabButton || guiEventListener instanceof ChatTabSettingsButton) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.NOT_CONNECTED) {
            Services.ChatTab.resetFocusedTab();
            return;
        }
        if (Services.ChatTab.getFocusedTab() == null) {
            Services.ChatTab.refocusFirstTab();
        }
    }

    @SubscribeEvent
    public void onScreenRender(ScreenRenderEvent event) {
        class_437 class_4372 = event.getScreen();
        if (!(class_4372 instanceof class_408)) {
            return;
        }
        class_408 chatScreen = (class_408)class_4372;
        chatScreen.field_21616.method_23923(event.getGuiGraphics(), event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public void onChatScreenKeyTyped(ChatScreenKeyTypedEvent event) {
        if (!(McUtils.mc().field_1755 instanceof class_408)) {
            return;
        }
        int keyCode = event.getKeyCode();
        if (keyCode == 258) {
            int newTab = -1;
            if (((Boolean)this.oldTabHotkey.get()).booleanValue()) {
                if (KeyboardUtils.isShiftDown()) {
                    newTab = Services.ChatTab.getNextFocusedTab();
                }
            } else if (KeyboardUtils.isControlDown()) {
                int n = newTab = KeyboardUtils.isShiftDown() ? Services.ChatTab.getPreviousFocusedTab() : Services.ChatTab.getNextFocusedTab();
            }
            if (newTab == -1) {
                return;
            }
            Services.ChatTab.setFocusedTab(newTab);
            event.setCanceled(true);
            return;
        }
        if (KeyboardUtils.isControlDown() && keyCode >= 49 && keyCode <= 57) {
            ChatTab newTab = Services.ChatTab.getTab(keyCode - 49);
            if (newTab != null) {
                Services.ChatTab.setFocusedTab(newTab);
            }
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChatScreenSend(ChatScreenSendEvent event) {
        Services.ChatTab.sendChat(event.getInput());
        event.setCanceled(true);
    }

    @Override
    public void onEnable() {
        Services.ChatTab.refocusFirstTab();
    }

    @Override
    public void onDisable() {
        Services.ChatTab.resetFocusedTab();
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        if (!this.isEnabled()) {
            return;
        }
        Services.ChatTab.refocusFirstTab();
        class_437 class_4372 = McUtils.mc().field_1755;
        if (class_4372 instanceof class_408) {
            class_408 chatScreen = (class_408)class_4372;
            chatScreen.method_25423(McUtils.mc(), McUtils.window().method_4486(), McUtils.window().method_4502());
        }
    }
}

