/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.IterationDecision;
import java.util.ArrayList;
import java.util.regex.Matcher;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.CHAT)
public class RevealNicknamesFeature
extends Feature {
    private static final String NICKNAME_HOVER_TEXT = "\u00a7f%s\u00a77's nickname is \u00a7f%s";
    @Persisted
    private final Config<NicknameReplaceOption> nicknameReplaceOption = new Config<NicknameReplaceOption>(NicknameReplaceOption.PREPEND_USERNAME);

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerChat(ChatMessageEvent.Edit event) {
        StyledText styledText = event.getMessage().iterate((currentPart, changes) -> {
            class_2568 hoverEvent = currentPart.getPartStyle().getStyle().method_10969();
            if (hoverEvent == null || hoverEvent.method_10892() != class_2568.class_5247.field_24342) {
                return IterationDecision.CONTINUE;
            }
            StyledText[] partTexts = StyledText.fromComponent((class_2561)hoverEvent.method_10891(class_2568.class_5247.field_24342)).split("\n");
            ArrayList<StyledText> newHoverTexts = new ArrayList<StyledText>();
            String nickname = null;
            String username = null;
            for (StyledText partText : partTexts) {
                Matcher nicknameMatcher = partText.getMatcher(StyledTextUtils.NICKNAME_PATTERN);
                if (nicknameMatcher.matches()) {
                    nickname = nicknameMatcher.group("nick");
                    username = nicknameMatcher.group("username");
                    continue;
                }
                newHoverTexts.add(partText);
            }
            if (nickname == null || username == null) {
                return IterationDecision.CONTINUE;
            }
            if (!currentPart.getString(null, PartStyle.StyleType.NONE).startsWith(nickname)) {
                return IterationDecision.CONTINUE;
            }
            newHoverTexts.add(StyledText.fromComponent((class_2561)class_2561.method_43470((String)NICKNAME_HOVER_TEXT.formatted(username, nickname))));
            switch (((NicknameReplaceOption)((Object)((Object)this.nicknameReplaceOption.get()))).ordinal()) {
                case 0: {
                    changes.remove(currentPart);
                    String currentText = currentPart.getString(null, PartStyle.StyleType.NONE);
                    boolean hasColon = currentText.trim().endsWith(":");
                    String newText = username + (hasColon ? ": " : "");
                    class_2583 newStyle = currentPart.getPartStyle().withItalic(false).withHoverEvent(new class_2568(class_2568.class_5247.field_24342, (Object)StyledText.join("\n", newHoverTexts).getComponent())).getStyle();
                    StyledTextPart newPart = new StyledTextPart(newText, newStyle, null, class_2583.field_24360);
                    changes.add(newPart);
                    break;
                }
                case 1: {
                    class_2583 newStyle = currentPart.getPartStyle().withItalic(false).withHoverEvent(new class_2568(class_2568.class_5247.field_24342, (Object)StyledText.join("\n", newHoverTexts).getComponent())).getStyle();
                    StyledTextPart newPart = new StyledTextPart(username + "/", newStyle, null, class_2583.field_24360);
                    StyledTextPart oldPart = new StyledTextPart(currentPart.getString(null, PartStyle.StyleType.NONE), newStyle.method_10978(Boolean.valueOf(true)), null, class_2583.field_24360);
                    changes.remove(currentPart);
                    changes.add(newPart);
                    changes.add(oldPart);
                }
            }
            return IterationDecision.CONTINUE;
        });
        event.setMessage(styledText);
    }

    public static enum NicknameReplaceOption {
        REPLACE,
        PREPEND_USERNAME;

    }
}

