/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.UseItemEvent;
import com.wynntils.models.items.items.game.HorseItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.MouseUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2824;
import net.minecraft.class_2868;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_746;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class HorseMountFeature
extends Feature {
    private static final class_2960 HORSE_WHISTLE_ID = class_2960.method_60655((String)"wynntils", (String)"horse.whistle");
    private static final class_3414 HORSE_WHISTLE_SOUND = class_3414.method_47908((class_2960)HORSE_WHISTLE_ID);
    private static final int SEARCH_RADIUS = 6;
    private static final int SUMMON_DELAY_TICKS = 6;
    private static final List<String> HORSE_ERROR_MESSAGES = List.of("There is no room for a horse.", "Your horse is scared to come out right now, too many mobs are nearby.", "You cannot interact with your horse at the moment.", "You cannot use your horse here!", "Your horse spawn was disabled (in vanish)!", "You can not use a horse while in war.", "You cannot use your vehicle here!");
    private int prevItem = -1;
    private boolean alreadySetPrevItem = false;
    private boolean cancelMountingHorse = false;
    @RegisterKeyBind
    private final KeyBind mountHorseKeyBind = new KeyBind("Mount Horse", 82, true, this::mountHorse);
    @Persisted
    private final Config<Boolean> guaranteedMount = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> summonAttempts = new Config<Integer>(8);
    @Persisted
    private final Config<Boolean> playWhistle = new Config<Boolean>(true);

    @SubscribeEvent
    public void onUseItem(UseItemEvent event) {
        if (!((Boolean)this.guaranteedMount.get()).booleanValue()) {
            return;
        }
        class_1799 itemStack = McUtils.player().method_6047();
        Optional<HorseItem> horseItemOpt = Models.Item.asWynnItem(itemStack, HorseItem.class);
        if (horseItemOpt.isEmpty()) {
            return;
        }
        this.mountHorse();
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatReceived(ChatMessageEvent.Match e) {
        this.cancelMountingHorse = HORSE_ERROR_MESSAGES.stream().anyMatch(msg -> e.getMessage().getString().contains((CharSequence)msg));
    }

    private void mountHorse() {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        class_746 player = McUtils.player();
        if (player.method_5854() != null) {
            this.postHorseErrorMessage(MountHorseStatus.ALREADY_RIDING);
            return;
        }
        class_1496 horse = Models.Horse.searchForHorseNearby((class_1657)player, 6);
        if (horse == null) {
            int horseInventorySlot = Models.Horse.findHorseSlotNum();
            if (horseInventorySlot > 8 || horseInventorySlot == -1) {
                this.postHorseErrorMessage(MountHorseStatus.NO_HORSE);
                return;
            }
            this.trySummonAndMountHorse(horseInventorySlot, (Integer)this.summonAttempts.get());
        } else {
            this.mountHorse((class_1297)horse);
        }
    }

    private void mountHorse(class_1297 horse) {
        int nonConflictingSlot;
        if (((Boolean)this.playWhistle.get()).booleanValue()) {
            McUtils.playSoundAmbient(HORSE_WHISTLE_SOUND);
        }
        if ((nonConflictingSlot = this.findNonConflictingSlot()) == -1) {
            this.postHorseErrorMessage(MountHorseStatus.CONFLICTING_SLOTS);
            return;
        }
        McUtils.sendPacket(new class_2868(nonConflictingSlot));
        McUtils.sendPacket(class_2824.method_34207((class_1297)horse, (boolean)false, (class_1268)class_1268.field_5808));
        McUtils.sendPacket(new class_2868(this.prevItem));
    }

    private int findNonConflictingSlot() {
        for (int i = 0; i < 9; ++i) {
            class_1799 itemStack = McUtils.inventory().method_5438(i);
            if (itemStack.method_7960()) {
                return i;
            }
            Optional<HorseItem> horseItemOpt = Models.Item.asWynnItem(itemStack, HorseItem.class);
            if (!horseItemOpt.isPresent()) continue;
            return i;
        }
        return -1;
    }

    private void trySummonAndMountHorse(int horseInventorySlot, int attempts) {
        if (attempts <= 0) {
            this.postHorseErrorMessage(MountHorseStatus.NO_HORSE);
            McUtils.sendPacket(new class_2868(this.prevItem));
            return;
        }
        if (this.cancelMountingHorse) {
            McUtils.sendPacket(new class_2868(this.prevItem));
            this.cancelMountingHorse = false;
            return;
        }
        if (!this.alreadySetPrevItem) {
            this.prevItem = McUtils.inventory().field_7545;
            this.alreadySetPrevItem = true;
        }
        Managers.TickScheduler.scheduleLater(() -> {
            class_746 player = McUtils.player();
            if (player == null) {
                return;
            }
            class_1496 horse = Models.Horse.searchForHorseNearby((class_1657)player, 6);
            if (horse != null) {
                McUtils.sendPacket(new class_2868(this.prevItem));
                this.alreadySetPrevItem = false;
                this.mountHorse((class_1297)horse);
                return;
            }
            McUtils.sendPacket(new class_2868(horseInventorySlot));
            MouseUtils.sendRightClickInput();
            this.trySummonAndMountHorse(horseInventorySlot, attempts - 1);
        }, 6);
    }

    private void postHorseErrorMessage(MountHorseStatus status) {
        Managers.Notification.queueMessage((class_2561)class_2561.method_43471((String)status.getTcString()).method_27692(class_124.field_1079));
    }

    private static enum MountHorseStatus {
        NO_HORSE("feature.wynntils.horseMount.noHorse"),
        ALREADY_RIDING("feature.wynntils.horseMount.alreadyRiding"),
        CONFLICTING_SLOTS("feature.wynntils.horseMount.conflictingSlots");

        private final String tcString;

        private MountHorseStatus(String tcString) {
            this.tcString = tcString;
        }

        private String getTcString() {
            return this.tcString;
        }
    }
}

