/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.Optional;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class LowHealthVignetteFeature
extends Feature {
    private static final float INTENSITY = 0.3f;
    @Persisted
    private final Config<Integer> lowHealthPercentage = new Config<Integer>(25);
    @Persisted
    private final Config<Float> animationSpeed = new Config<Float>(Float.valueOf(0.6f));
    @Persisted
    private final Config<HealthVignetteEffect> healthVignetteEffect = new Config<HealthVignetteEffect>(HealthVignetteEffect.PULSE);
    @Persisted
    private final Config<CustomColor> color = new Config<CustomColor>(new CustomColor(255, 0, 0));
    private float animation = 10.0f;
    private float value = 0.3f;
    private boolean shouldRender = false;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderGui(RenderEvent.Post event) {
        if (!this.shouldRender || event.getType() != RenderEvent.ElementType.GUI) {
            return;
        }
        if (!Models.WorldState.onWorld()) {
            return;
        }
        RenderUtils.renderVignetteOverlay(event.getPoseStack(), (CustomColor)this.color.get(), this.value);
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        float threshold;
        this.shouldRender = false;
        Optional<CappedValue> healthOpt = Models.CharacterStats.getHealth();
        if (healthOpt.isEmpty()) {
            return;
        }
        float healthProgress = (float)healthOpt.get().getProgress();
        if (healthProgress > (threshold = (float)((Integer)this.lowHealthPercentage.get()).intValue() / 100.0f)) {
            return;
        }
        this.shouldRender = true;
        switch (((HealthVignetteEffect)((Object)this.healthVignetteEffect.get())).ordinal()) {
            case 0: {
                this.animation = (this.animation + ((Float)this.animationSpeed.get()).floatValue()) % 40.0f;
                this.value = threshold - healthProgress * 0.3f + 0.01f * Math.abs(20.0f - this.animation);
                break;
            }
            case 1: {
                this.value = MathUtils.map(healthProgress, 0.0f, threshold, 0.3f, 0.1f);
                break;
            }
            case 2: {
                this.value = 0.3f;
            }
        }
    }

    public static enum HealthVignetteEffect {
        PULSE,
        GROWING,
        STATIC;

    }
}

