/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.debug;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterCommand;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.utils.mc.McUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

@StartDisabled
@ConfigCategory(value=Category.DEBUG)
public class FunctionDumpFeature
extends Feature {
    private static final String FUNCTION_NAME = "wynntilsFunction";
    private static final String ARGUMENT_NAME = "wynntilsArgument";
    private static final Map<String, String> FUNCTION_MAP = new LinkedHashMap<String, String>();
    private static final Map<String, String> ARGUMENT_MAP = new LinkedHashMap<String, String>();
    @RegisterCommand
    private final LiteralCommandNode<class_2168> dumpCommand = ((LiteralArgumentBuilder)class_2170.method_9247((String)"dumpFunctions").executes(ctx -> {
        FUNCTION_MAP.put("id", "serial PRIMARY KEY");
        FUNCTION_MAP.put("name", "VARCHAR(255) UNIQUE NOT NULL");
        FUNCTION_MAP.put("description", "TEXT NOT NULL");
        FUNCTION_MAP.put("aliases", "VARCHAR(255)[]");
        FUNCTION_MAP.put("returntype", "type NOT NULL");
        ARGUMENT_MAP.put("id", "serial PRIMARY KEY");
        ARGUMENT_MAP.put("name", "VARCHAR(255) NOT NULL");
        ARGUMENT_MAP.put("description", "TEXT NOT NULL");
        ARGUMENT_MAP.put("required", "BOOLEAN NOT NULL");
        ARGUMENT_MAP.put("functionid", "INTEGER REFERENCES wynntilsFunction(id)");
        ARGUMENT_MAP.put("type", "type NOT NULL");
        ARGUMENT_MAP.put("defaultvalue", "VARCHAR(255)");
        this.dumpFunctionsToCSV();
        this.dumpArgumentsToCSV();
        this.copyPreparationStatement();
        return 0;
    })).build();

    private void dumpFunctionsToCSV() {
        ArrayList<String[]> dataLines = new ArrayList<String[]>();
        dataLines.add(new String[]{String.join((CharSequence)",", FUNCTION_MAP.keySet())});
        for (Function<?> function : Managers.Function.getFunctions()) {
            String aliases = "{" + String.join((CharSequence)",", function.getAliasList()) + "}";
            String[] dataLine = new String[]{String.valueOf(dataLines.size()), function.getName(), function.getDescription(), aliases, function.getReturnTypeName()};
            dataLines.add(dataLine);
        }
        this.writeToCSV(dataLines, FUNCTION_NAME);
    }

    private void dumpArgumentsToCSV() {
        ArrayList<String[]> dataLines = new ArrayList<String[]>();
        dataLines.add(new String[]{String.join((CharSequence)",", ARGUMENT_MAP.keySet())});
        for (int i = 0; i < Managers.Function.getFunctions().size(); ++i) {
            Function<?> function = Managers.Function.getFunctions().get(i);
            for (Argument<?> argument : function.getArgumentsBuilder().getArguments()) {
                String[] dataLine = new String[]{String.valueOf(dataLines.size()), argument.getName(), function.getArgumentDescription(argument.getName()), String.valueOf(function.getArgumentsBuilder() instanceof FunctionArguments.RequiredArgumentBuilder), String.valueOf(i + 1), argument.getType().getSimpleName(), String.valueOf(argument.getDefaultValue())};
                dataLines.add(dataLine);
            }
        }
        this.writeToCSV(dataLines, ARGUMENT_NAME);
    }

    private void writeToCSV(List<String[]> dataLines, String name) {
        File csvOutputFile = new File(name + ".csv");
        try (PrintWriter pw = new PrintWriter(csvOutputFile, StandardCharsets.UTF_8);){
            dataLines.stream().map(line -> Stream.of(line).map(d -> {
                String value = String.valueOf(d);
                Object escapedData = value.replaceAll("\\R", " ");
                if (value.contains(",") || value.contains("\"") || value.contains("'")) {
                    value = value.replace("\"", "\"\"");
                    escapedData = "\"" + value + "\"";
                }
                return escapedData;
            }).collect(Collectors.joining(","))).forEach(pw::println);
        }
        catch (IOException e) {
            McUtils.sendErrorToClient("Failed to write " + name + " to CSV");
        }
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "Wrote " + name + " to CSV at " + csvOutputFile.getAbsolutePath())));
    }

    private void copyPreparationStatement() {
        String clearDatabase = "DROP SCHEMA public CASCADE; CREATE SCHEMA public;";
        Set typeNames = Managers.Function.getFunctions().stream().map(function -> function.getReturnTypeName()).collect(Collectors.toSet());
        String makeTypeEnum = "CREATE TYPE type AS ENUM (" + typeNames.stream().map(name -> "'" + name + "'").collect(Collectors.joining(",")) + ");";
        String makeFunctionTable = "CREATE TABLE wynntilsFunction (" + FUNCTION_MAP.entrySet().stream().map(entry -> (String)entry.getKey() + " " + (String)entry.getValue()).collect(Collectors.joining(",")) + ");";
        String makeArgumentTable = "CREATE TABLE wynntilsArgument (" + ARGUMENT_MAP.entrySet().stream().map(entry -> (String)entry.getKey() + " " + (String)entry.getValue()).collect(Collectors.joining(",")) + ");";
        McUtils.mc().field_1774.method_1455(clearDatabase + makeTypeEnum + makeFunctionTable + makeArgumentTable);
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "Copied database preparation statement to clipboard.\n"))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "Run this statement before importing new CSVs.\n"))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "Import CSVs using pgAdmin 4 ensuring Header option is checked and encoding is UTF-8.\n"))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "Import functions before arguments."))));
    }
}

