/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.debug;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.PacketEvent;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10264;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2649;
import net.minecraft.class_2651;
import net.minecraft.class_2653;
import net.minecraft.class_2666;
import net.minecraft.class_2670;
import net.minecraft.class_2672;
import net.minecraft.class_2675;
import net.minecraft.class_2676;
import net.minecraft.class_2684;
import net.minecraft.class_2703;
import net.minecraft.class_2716;
import net.minecraft.class_2726;
import net.minecraft.class_2739;
import net.minecraft.class_2743;
import net.minecraft.class_2744;
import net.minecraft.class_2752;
import net.minecraft.class_2761;
import net.minecraft.class_2767;
import net.minecraft.class_2777;
import net.minecraft.class_2779;
import net.minecraft.class_2781;
import net.minecraft.class_2811;
import net.minecraft.class_2813;
import net.minecraft.class_2815;
import net.minecraft.class_2827;
import net.minecraft.class_2828;
import net.minecraft.class_4282;
import net.minecraft.class_7439;
import net.minecraft.class_9836;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@StartDisabled
@ConfigCategory(value=Category.DEBUG)
public class PacketDebuggerFeature
extends Feature {
    private static final List<Class<? extends class_2596<?>>> IGNORE_LIST = List.of(class_2827.class, class_9836.class, class_2670.class, class_2761.class, class_2779.class, class_2781.class, class_2675.class, class_2703.class, class_2744.class, class_2666.class, class_2676.class, class_4282.class, class_2672.class, class_2637.class, class_2626.class, class_2604.class, class_2684.class_2685.class, class_2684.class_2686.class, class_2684.class_2687.class, class_2726.class, class_2739.class, class_2743.class, class_2777.class, class_10264.class, class_2752.class, class_2828.class_2829.class, class_2828.class_2830.class, class_2828.class_2831.class);
    private static final List<Class<? extends class_2596<?>>> EXTENDED_IGNORE_LIST = List.of(class_2767.class, class_7439.class);
    private static final List<Class<? extends class_2596<?>>> CONTAINER_PACKETS = List.of(class_2649.class, class_2653.class, class_2651.class, class_2653.class, class_2813.class, class_2813.class, class_2811.class, class_2815.class);
    private static final Class<? extends class_2596<?>> PARTICLE_PACKET_CLASS = class_2675.class;
    private static final List<Class<? extends class_2596<?>>> ENTITY_PACKETS = List.of(class_2604.class, class_2716.class, class_2684.class_2685.class, class_2684.class_2686.class, class_2684.class_2687.class, class_2726.class, class_2739.class, class_2743.class, class_2777.class);
    @Persisted
    private final Config<PacketFilterType> packetFilterType = new Config<PacketFilterType>(PacketFilterType.FILTERED);

    private String describePacket(class_2596<?> packet) {
        return ReflectionToStringBuilder.toString(packet, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).replaceFirst("net\\.minecraft\\.network\\.protocol\\..*\\.", "");
    }

    @SubscribeEvent
    public void onPacketSent(PacketEvent.PacketSentEvent<?> e) {
        Object packet = e.getPacket();
        if (((PacketFilterType)((Object)this.packetFilterType.get())).isPacketExcluded(packet.getClass())) {
            return;
        }
        WynntilsMod.info("SENT packet: " + this.describePacket((class_2596<?>)packet));
    }

    @SubscribeEvent
    public void onPacketReceived(PacketEvent.PacketReceivedEvent<?> e) {
        Object packet = e.getPacket();
        if (((PacketFilterType)((Object)this.packetFilterType.get())).isPacketExcluded(packet.getClass())) {
            return;
        }
        WynntilsMod.info("RECV packet: " + this.describePacket((class_2596<?>)packet));
    }

    private static enum PacketFilterType {
        ALL(packetClass -> false),
        FILTERED(IGNORE_LIST::contains),
        EXTENDED_FILTERED(packetClass -> IGNORE_LIST.contains(packetClass) || EXTENDED_IGNORE_LIST.contains(packetClass)),
        CONTAINER_ONLY(packetClass -> !CONTAINER_PACKETS.contains(packetClass)),
        PARTICLE_ONLY(packetClass -> !PARTICLE_PACKET_CLASS.equals(packetClass)),
        ENTITY_ONLY(packetClass -> !ENTITY_PACKETS.contains(packetClass));

        private final Predicate<Class<? extends class_2596>> filterPredicate;

        private PacketFilterType(Predicate<Class<? extends class_2596>> filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        public boolean isPacketExcluded(Class<? extends class_2596> packetClass) {
            return this.filterPredicate.test(packetClass);
        }
    }
}

