/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.HotbarSlotRenderEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.items.properties.DurableItemProperty;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.CappedValue;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class DurabilityOverlayFeature
extends Feature {
    @Persisted
    private final Config<Boolean> renderDurabilityOverlayInventories = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> renderDurabilityOverlayHotbar = new Config<Boolean>(true);
    @Persisted
    private final Config<DurabilityRenderMode> durabilityRenderMode = new Config<DurabilityRenderMode>(DurabilityRenderMode.ARC);

    @SubscribeEvent
    public void onRenderHotbarSlot(HotbarSlotRenderEvent.CountPre e) {
        if (!((Boolean)this.renderDurabilityOverlayHotbar.get()).booleanValue()) {
            return;
        }
        switch (((DurabilityRenderMode)((Object)this.durabilityRenderMode.get())).ordinal()) {
            case 0: {
                this.drawDurabilityArc(e.getPoseStack(), e.getItemStack(), e.getX(), e.getY());
                break;
            }
            case 1: {
                this.drawDurabilityBar(e.getPoseStack(), e.getItemStack(), e.getX(), e.getY());
                break;
            }
            case 2: {
                this.drawDurabilityPercentage(e.getPoseStack(), e.getItemStack(), e.getX(), e.getY());
            }
        }
    }

    @SubscribeEvent
    public void onRenderSlot(SlotRenderEvent.CountPre e) {
        if (!((Boolean)this.renderDurabilityOverlayInventories.get()).booleanValue()) {
            return;
        }
        switch (((DurabilityRenderMode)((Object)this.durabilityRenderMode.get())).ordinal()) {
            case 0: {
                this.drawDurabilityArc(e.getPoseStack(), e.getSlot().method_7677(), e.getSlot().field_7873, e.getSlot().field_7872);
                break;
            }
            case 1: {
                this.drawDurabilityBar(e.getPoseStack(), e.getSlot().method_7677(), e.getSlot().field_7873, e.getSlot().field_7872);
                break;
            }
            case 2: {
                this.drawDurabilityPercentage(e.getPoseStack(), e.getSlot().method_7677(), e.getSlot().field_7873, e.getSlot().field_7872);
            }
        }
    }

    private void drawDurabilityArc(class_4587 poseStack, class_1799 itemStack, int slotX, int slotY) {
        Optional<DurableItemProperty> durableItemOpt = Models.Item.asWynnItemProperty(itemStack, DurableItemProperty.class);
        if (durableItemOpt.isEmpty()) {
            return;
        }
        CappedValue durability = durableItemOpt.get().getDurability();
        float durabilityFraction = (float)durability.current() / (float)durability.max();
        int colorInt = class_3532.method_15369((float)(Math.max(0.0f, durabilityFraction) / 3.0f), (float)1.0f, (float)1.0f);
        CustomColor color = CustomColor.fromInt(colorInt).withAlpha(160);
        RenderSystem.enableDepthTest();
        RenderUtils.drawArc(poseStack, color, slotX, slotY, 100.0f, durabilityFraction, 6, 8);
        RenderSystem.disableDepthTest();
    }

    private void drawDurabilityBar(class_4587 poseStack, class_1799 itemStack, int slotX, int slotY) {
        Optional<DurableItemProperty> durableItemProperty = Models.Item.asWynnItemProperty(itemStack, DurableItemProperty.class);
        if (durableItemProperty.isEmpty()) {
            return;
        }
        CappedValue durability = durableItemProperty.get().getDurability();
        if (durability.isAtCap()) {
            return;
        }
        int width = class_3532.method_15340((int)Math.round(13.0f * (float)durability.getProgress()), (int)0, (int)13);
        float hue = Math.max(0.0f, (float)durability.getProgress()) / 3.0f;
        int i = slotX + 2;
        int j = slotY + 13;
        RenderUtils.drawRect(poseStack, CustomColor.fromInt(-16777216), i, j, 200.0f, 13.0f, 2.0f);
        RenderUtils.drawRect(poseStack, CustomColor.fromHSV(hue, 1.0f, 1.0f, 1.0f), i, j, 200.0f, width, 1.0f);
    }

    private void drawDurabilityPercentage(class_4587 poseStack, class_1799 itemStack, int slotX, int slotY) {
        Optional<DurableItemProperty> durableItemOpt = Models.Item.asWynnItemProperty(itemStack, DurableItemProperty.class);
        if (durableItemOpt.isEmpty()) {
            return;
        }
        CappedValue durability = durableItemOpt.get().getDurability();
        float durabilityFraction = (float)durability.current() / (float)durability.max();
        CustomColor color = CustomColor.fromHSV(Math.max(0.0f, durabilityFraction) / 3.0f, 1.0f, 1.0f, 1.0f);
        StyledText text = StyledText.fromString(Math.round(durabilityFraction * 100.0f) + "%");
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 300.0f);
        FontRenderer.getInstance().renderText(poseStack, text, (float)slotX + 8.0f, (float)slotY + 16.0f, color, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL, 0.5f, class_327.class_6415.field_33993);
        poseStack.method_22909();
    }

    private static enum DurabilityRenderMode {
        ARC,
        BAR,
        PERCENTAGE;

    }
}

