/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.inventory.PersonalStorageUtilitiesFeature;
import com.wynntils.mc.event.ContainerRenderEvent;
import com.wynntils.models.containers.containers.CharacterInfoContainer;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.screens.bulkbuy.widgets.BulkBuyWidget;
import com.wynntils.screens.itemsharing.SavedItemsScreen;
import com.wynntils.screens.playerviewer.PlayerViewerScreen;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class InventoryEmeraldCountFeature
extends Feature {
    private static final int TEXTURE_SIZE = 28;
    @Persisted
    private final Config<EmeraldCountType> emeraldCountType = new Config<EmeraldCountType>(EmeraldCountType.TEXTURE);
    @Persisted
    private final Config<TextDisplaySide> textDisplaySide = new Config<TextDisplaySide>(TextDisplaySide.LEFT);
    @Persisted
    private final Config<Boolean> showInventoryEmeraldCount = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showContainerEmeraldCount = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showZerosInEmeraldCount = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> combineInventoryAndContainer = new Config<Boolean>(false);

    @SubscribeEvent
    public void onContainerRender(ContainerRenderEvent event) {
        boolean displayBottom;
        int textX;
        int topEmeralds;
        boolean isInventory;
        class_437 screen = McUtils.mc().field_1755;
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 containerScreen = (class_465)screen;
        if (this.isExcludedContainer(screen)) {
            return;
        }
        boolean bl = isInventory = event.getScreen().method_17577().field_7763 == 0;
        if (isInventory) {
            if (!((Boolean)this.showInventoryEmeraldCount.get()).booleanValue()) {
                return;
            }
            topEmeralds = Models.Emerald.getAmountInInventory();
        } else {
            topEmeralds = 0;
            if (((Boolean)this.showContainerEmeraldCount.get()).booleanValue()) {
                topEmeralds += Models.Emerald.getAmountInContainer();
            }
            if (((Boolean)this.combineInventoryAndContainer.get()).booleanValue() && ((Boolean)this.showInventoryEmeraldCount.get()).booleanValue()) {
                topEmeralds += Models.Emerald.getAmountInInventory();
            }
        }
        int topTextureX = containerScreen.field_2776;
        int bottomTextureX = containerScreen.field_2776;
        int n = textX = this.textDisplaySide.get() == TextDisplaySide.LEFT ? containerScreen.field_2776 + 2 : screen.field_22789 - containerScreen.field_2776 - 2;
        if (Models.Container.getCurrentContainer() instanceof PersonalStorageContainer && Managers.Feature.getFeatureInstance(PersonalStorageUtilitiesFeature.class).isEnabled()) {
            topTextureX -= Texture.BANK_PANEL.width() + 10;
        }
        for (class_4068 r : event.getScreen().field_33816) {
            if (!(r instanceof BulkBuyWidget)) continue;
            BulkBuyWidget bulkBuyWidget = (BulkBuyWidget)r;
            topTextureX -= (int)((double)(Texture.BULK_BUY_PANEL.width() + 1) * bulkBuyWidget.getAnimationPercentage().getAnimationWithoutUpdate());
            break;
        }
        int bottomEmeralds = Models.Emerald.getAmountInInventory();
        boolean bl2 = displayBottom = !isInventory && (Boolean)this.combineInventoryAndContainer.get() == false && (Boolean)this.showInventoryEmeraldCount.get() != false && bottomEmeralds != 0;
        if (topEmeralds != 0) {
            int y = isInventory ? containerScreen.field_2800 - 9 : containerScreen.field_2800;
            switch (((EmeraldCountType)((Object)this.emeraldCountType.get())).ordinal()) {
                case 0: {
                    this.renderTextCount(event.getPoseStack(), textX, y, topEmeralds);
                    break;
                }
                case 1: {
                    if (displayBottom) {
                        int topDisplayedTextureCount = (int)Arrays.stream(this.getRenderableEmeraldAmounts(topEmeralds)).filter(s -> (Boolean)this.showZerosInEmeraldCount.get() != false || !s.equals("0")).count();
                        int textureVerticalSize = topDisplayedTextureCount * 28 + 2;
                        int bottomStartY = containerScreen.field_2800 + containerScreen.field_2779 - 84 - 2;
                        y = Math.min(bottomStartY - textureVerticalSize, y);
                    }
                    this.renderTexturedCount(event.getGuiGraphics(), topTextureX, y, topEmeralds);
                }
            }
        }
        if (displayBottom) {
            int y = containerScreen.field_2800 + containerScreen.field_2779;
            switch (((EmeraldCountType)((Object)this.emeraldCountType.get())).ordinal()) {
                case 0: {
                    this.renderTextCount(event.getPoseStack(), textX, y + 11, bottomEmeralds);
                    break;
                }
                case 1: {
                    this.renderTexturedCount(event.getGuiGraphics(), bottomTextureX, y - 84 - 2, bottomEmeralds);
                }
            }
        }
    }

    private void renderTextCount(class_4587 poseStack, int x, int y, int emeralds) {
        HorizontalAlignment emeraldTextAlignment = this.textDisplaySide.get() == TextDisplaySide.LEFT ? HorizontalAlignment.LEFT : HorizontalAlignment.RIGHT;
        int emeraldTextOffsetX = this.textDisplaySide.get() == TextDisplaySide.LEFT ? 1 : -1;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 200.0f);
        Object emeraldText = KeyboardUtils.isKeyDown(340) ? emeralds + EmeraldUnits.EMERALD.getSymbol() : Models.Emerald.getFormattedString(emeralds, (Boolean)this.showZerosInEmeraldCount.get());
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((String)emeraldText), (float)(x + emeraldTextOffsetX), (float)(y - 10), 0.0f, CommonColors.WHITE, emeraldTextAlignment, VerticalAlignment.TOP, TextShadow.NORMAL);
        poseStack.method_22909();
    }

    private void renderTexturedCount(class_332 guiGraphics, int x, int y, int emeralds) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)x, (float)y, 0.0f);
        String[] emeraldAmounts = this.getRenderableEmeraldAmounts(emeralds);
        int renderedCount = 0;
        for (int i = emeraldAmounts.length - 1; i >= 0; --i) {
            String emeraldAmount = emeraldAmounts[i];
            if (!((Boolean)this.showZerosInEmeraldCount.get()).booleanValue() && emeraldAmount.equals("0")) continue;
            int renderX = -28;
            int renderY = renderedCount * 28;
            RenderUtils.drawTexturedRect(poseStack, Texture.EMERALD_COUNT_BACKGROUND.resource(), -28.0f, renderY, 0.0f, 28.0f, 28.0f, 0, 0, Texture.EMERALD_COUNT_BACKGROUND.width(), Texture.EMERALD_COUNT_BACKGROUND.height(), Texture.EMERALD_COUNT_BACKGROUND.width(), Texture.EMERALD_COUNT_BACKGROUND.height());
            guiGraphics.method_51427(EmeraldUnits.values()[i].getItemStack(), -22, renderY + 6);
            if (EmeraldUnits.values()[i].getSymbol().equals("stx")) {
                guiGraphics.method_51427(EmeraldUnits.values()[i].getItemStack(), -25, renderY + 4);
                guiGraphics.method_51427(EmeraldUnits.values()[i].getItemStack(), -22, renderY + 6);
                guiGraphics.method_51427(EmeraldUnits.values()[i].getItemStack(), -19, renderY + 8);
            } else {
                guiGraphics.method_51427(EmeraldUnits.values()[i].getItemStack(), -22, renderY + 6);
            }
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 200.0f);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(emeraldAmount), -28.0f, -2.0f, renderY, renderY + 28 - 2, 0.0f, CommonColors.WHITE, HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM, TextShadow.OUTLINE);
            poseStack.method_22909();
            ++renderedCount;
        }
        poseStack.method_22909();
    }

    private String[] getRenderableEmeraldAmounts(int emeralds) {
        String[] emeraldAmounts = new String[4];
        if (KeyboardUtils.isKeyDown(340)) {
            emeraldAmounts[0] = StringUtils.formatAmount(emeralds);
            emeraldAmounts[1] = StringUtils.formatAmount((double)emeralds / 64.0);
            emeraldAmounts[2] = StringUtils.formatAmount((double)emeralds / 4096.0);
            emeraldAmounts[3] = StringUtils.formatAmount((double)emeralds / 262144.0);
        } else {
            emeraldAmounts = (String[])Arrays.stream(Models.Emerald.emeraldsPerUnit(emeralds)).mapToObj(String::valueOf).toArray(String[]::new);
        }
        return emeraldAmounts;
    }

    private boolean isExcludedContainer(class_437 screen) {
        return Models.Container.getCurrentContainer() instanceof CharacterInfoContainer || screen instanceof PlayerViewerScreen || screen instanceof SavedItemsScreen;
    }

    public static enum EmeraldCountType {
        TEXT,
        TEXTURE;

    }

    private static enum TextDisplaySide {
        RIGHT,
        LEFT;

    }
}

