/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.map;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.mc.event.RenderLevelEvent;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.services.map.pois.WaypointPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_2374;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@ConfigCategory(value=Category.MAP)
public class WorldWaypointDistanceFeature
extends Feature {
    private static final class_4597.class_4598 BUFFER_SOURCE = class_4597.method_22991((class_9799)new class_9799(256));
    private static final WaypointPoi DUMMY_WAYPOINT = new WaypointPoi(() -> null, "");
    @Persisted
    private final Config<Float> backgroundOpacity = new Config<Float>(Float.valueOf(0.2f));
    @Persisted
    private final Config<Float> scale = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.NONE);
    @Persisted
    private final Config<Float> bottomBoundingDistance = new Config<Float>(Float.valueOf(100.0f));
    @Persisted
    private final Config<Float> topBoundingDistance = new Config<Float>(Float.valueOf(40.0f));
    @Persisted
    private final Config<Float> horizontalBoundingDistance = new Config<Float>(Float.valueOf(30.0f));
    @Persisted
    private final Config<Integer> maxWaypointTextDistance = new Config<Integer>(5000);
    @Persisted
    public final Config<Boolean> showAdditionalTextInWorld = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showAdditonalTextAbove = new Config<Boolean>(false);
    private final List<RenderedMarkerInfo> renderedMarkers = new ArrayList<RenderedMarkerInfo>();

    @SubscribeEvent
    public void onRenderLevelPost(RenderLevelEvent.Post event) {
        this.renderedMarkers.clear();
        List<MarkerInfo> markers = Models.Marker.getAllMarkers().toList();
        if (markers.isEmpty()) {
            return;
        }
        for (MarkerInfo marker : markers) {
            Location location = marker.location();
            Matrix4f projection = new Matrix4f((Matrix4fc)event.getProjectionMatrix());
            class_4184 camera = event.getCamera();
            class_243 cameraPos = camera.method_19326();
            Vector3f xp = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f yp = new Vector3f(0.0f, 1.0f, 0.0f);
            Quaternionf xRotation = new Quaternionf().rotationAxis((float)Math.toRadians(camera.method_19329()), (Vector3fc)xp);
            Quaternionf yRotation = new Quaternionf().rotationAxis((float)Math.toRadians(camera.method_19330() + 180.0f), (Vector3fc)yp);
            projection.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)xRotation));
            projection.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)yRotation));
            float dx = (float)((double)location.x + 0.5 - cameraPos.method_10216());
            float dy = (float)((double)location.y + 0.5 - cameraPos.method_10214());
            float dz = (float)((double)location.z + 0.5 - cameraPos.method_10215());
            if (location.y <= 0 || location.y > 255) {
                dy = 0.0f;
            }
            double squaredDistance = dx * dx + dy * dy + dz * dz;
            double distance = Math.sqrt(squaredDistance);
            int maxDistance = (Integer)McUtils.options().method_42503().method_41753() * 16;
            String distanceText = Math.round((float)distance) + "m";
            if (distance > (double)maxDistance) {
                double posScale = (double)maxDistance / distance;
                dx = (float)((double)dx * posScale);
                dz = (float)((double)dz * posScale);
            }
            this.renderedMarkers.add(new RenderedMarkerInfo(distance, distanceText, marker, this.worldToScreen(new Vector3f(dx, dy, dz), projection), marker.additionalText()));
        }
    }

    @SubscribeEvent
    public void onRenderGuiPost(RenderEvent.Post event) {
        for (RenderedMarkerInfo renderedMarker : this.renderedMarkers) {
            float displayPositionY;
            float displayPositionX;
            if ((Integer)this.maxWaypointTextDistance.get() != 0 && (double)((Integer)this.maxWaypointTextDistance.get()).intValue() < renderedMarker.distance) continue;
            Objects.requireNonNull(FontRenderer.getInstance().getFont());
            float backgroundHeight = 9.0f;
            class_241 intersectPoint = this.getBoundingIntersectPoint(renderedMarker.screenCoordinates, event.getWindow());
            Texture icon = renderedMarker.markerInfo.texture();
            float[] color = renderedMarker.markerInfo.textureColor().asFloatArray();
            RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            if (intersectPoint == null) {
                float backgroundWidth;
                displayPositionX = (float)renderedMarker.screenCoordinates.field_1352;
                displayPositionY = (float)renderedMarker.screenCoordinates.field_1351;
                RenderUtils.drawScalingTexturedRect(event.getPoseStack(), icon.resource(), displayPositionX - ((Float)this.scale.get()).floatValue() * (float)icon.width() / 2.0f, displayPositionY - ((Float)this.scale.get()).floatValue() * ((float)icon.height() + backgroundHeight / 2.0f + 3.0f), 0.0f, ((Float)this.scale.get()).floatValue() * (float)icon.width(), ((Float)this.scale.get()).floatValue() * (float)icon.height(), icon.width(), icon.height());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!((Boolean)this.showAdditonalTextAbove.get()).booleanValue() && renderedMarker.additionalText != null) {
                    backgroundWidth = FontRenderer.getInstance().getFont().method_1727(renderedMarker.additionalText);
                    RenderUtils.drawRect(event.getPoseStack(), CommonColors.BLACK.withAlpha(((Float)this.backgroundOpacity.get()).floatValue()), displayPositionX - ((Float)this.scale.get()).floatValue() * (backgroundWidth / 2.0f + 2.0f), displayPositionY - ((Float)this.scale.get()).floatValue() * (backgroundHeight / 2.0f), 0.0f, ((Float)this.scale.get()).floatValue() * (backgroundWidth + 3.0f), ((Float)this.scale.get()).floatValue() * (backgroundHeight + 2.0f));
                    FontRenderer.getInstance().renderAlignedTextInBox(event.getPoseStack(), StyledText.fromString(renderedMarker.additionalText), displayPositionX - ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionX + ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionY - ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), displayPositionY + ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), 0.0f, renderedMarker.markerInfo.textColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, (TextShadow)this.textShadow.get(), ((Float)this.scale.get()).floatValue());
                    displayPositionY += ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue();
                }
                backgroundWidth = FontRenderer.getInstance().getFont().method_1727(renderedMarker.distanceText);
                RenderUtils.drawRect(event.getPoseStack(), CommonColors.BLACK.withAlpha(((Float)this.backgroundOpacity.get()).floatValue()), displayPositionX - ((Float)this.scale.get()).floatValue() * (backgroundWidth / 2.0f + 2.0f), displayPositionY - ((Float)this.scale.get()).floatValue() * (backgroundHeight / 2.0f), 0.0f, ((Float)this.scale.get()).floatValue() * (backgroundWidth + 3.0f), ((Float)this.scale.get()).floatValue() * (backgroundHeight + 2.0f));
                FontRenderer.getInstance().renderAlignedTextInBox(event.getPoseStack(), StyledText.fromString(renderedMarker.distanceText), displayPositionX - ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionX + ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionY - ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), displayPositionY + ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), 0.0f, renderedMarker.markerInfo.textColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, (TextShadow)this.textShadow.get(), ((Float)this.scale.get()).floatValue());
                if (!((Boolean)this.showAdditonalTextAbove.get()).booleanValue() || renderedMarker.additionalText == null) continue;
                backgroundWidth = FontRenderer.getInstance().getFont().method_1727(renderedMarker.additionalText);
                RenderUtils.drawRect(event.getPoseStack(), CommonColors.BLACK.withAlpha(((Float)this.backgroundOpacity.get()).floatValue()), displayPositionX - ((Float)this.scale.get()).floatValue() * (backgroundWidth / 2.0f + 2.0f), displayPositionY - ((Float)this.scale.get()).floatValue() * (backgroundHeight / 2.0f) - 35.0f * ((Float)this.scale.get()).floatValue(), 0.0f, ((Float)this.scale.get()).floatValue() * (backgroundWidth + 2.0f), ((Float)this.scale.get()).floatValue() * (backgroundHeight + 2.0f));
                FontRenderer.getInstance().renderAlignedTextInBox(event.getPoseStack(), StyledText.fromString(renderedMarker.additionalText), displayPositionX - ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionX + ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionY - ((Float)this.scale.get()).floatValue() * backgroundHeight - 33.0f * ((Float)this.scale.get()).floatValue(), displayPositionY + ((Float)this.scale.get()).floatValue() * backgroundHeight - 33.0f * ((Float)this.scale.get()).floatValue(), 0.0f, renderedMarker.markerInfo.textColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, (TextShadow)this.textShadow.get(), ((Float)this.scale.get()).floatValue());
                continue;
            }
            displayPositionX = intersectPoint.field_1343;
            displayPositionY = intersectPoint.field_1342;
            double angle = Math.toDegrees(StrictMath.atan2(displayPositionY - (float)(event.getWindow().method_4502() / 2), displayPositionX - (float)(event.getWindow().method_4486() / 2))) + 90.0;
            float radius = (float)(icon.width() / 2) + 8.0f;
            float pointerOffsetX = radius * (float)StrictMath.cos((angle - 90.0) * 3.0 / 180.0);
            float pointerOffsetY = radius * (float)StrictMath.sin((angle - 90.0) * 3.0 / 180.0);
            float pointerDisplayPositionX = displayPositionX + pointerOffsetX;
            float pointerDisplayPositionY = displayPositionY + pointerOffsetY;
            RenderUtils.drawScalingTexturedRect(event.getPoseStack(), icon.resource(), displayPositionX - ((Float)this.scale.get()).floatValue() * (float)icon.width() / 2.0f + pointerOffsetX * (1.0f - ((Float)this.scale.get()).floatValue()), displayPositionY - ((Float)this.scale.get()).floatValue() * (float)icon.height() / 2.0f + pointerOffsetY * (1.0f - ((Float)this.scale.get()).floatValue()), 0.0f, ((Float)this.scale.get()).floatValue() * (float)icon.width(), ((Float)this.scale.get()).floatValue() * (float)icon.height(), icon.width(), icon.height());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_4587 poseStack = event.getPoseStack();
            poseStack.method_22903();
            poseStack.method_46416(pointerDisplayPositionX, pointerDisplayPositionY, 0.0f);
            poseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.toRadians(angle)));
            poseStack.method_46416(-pointerDisplayPositionX, -pointerDisplayPositionY, 0.0f);
            DUMMY_WAYPOINT.getPointerPoi().renderAt(poseStack, (class_4597)BUFFER_SOURCE, pointerDisplayPositionX, pointerDisplayPositionY, false, ((Float)this.scale.get()).floatValue(), 1.0f, 50.0f, true);
            BUFFER_SOURCE.method_22993();
            poseStack.method_22909();
        }
    }

    private class_243 worldToScreen(Vector3f delta, Matrix4f projection) {
        Vector4f clipCoords = new Vector4f(delta.x(), delta.y(), delta.z(), 1.0f);
        projection.transform(clipCoords);
        Vector3d ndc = new Vector3d((double)(clipCoords.x() / clipCoords.w()), (double)(clipCoords.y() / clipCoords.w()), (double)(clipCoords.z() / clipCoords.w()));
        class_1041 window = McUtils.window();
        return new class_243((double)((float)((ndc.x + 1.0) / 2.0) * (float)window.method_4486()), (double)((float)((1.0 - ndc.y) / 2.0) * (float)window.method_4502()), (double)((float)ndc.z));
    }

    private class_241 getBoundingIntersectPoint(class_243 position, class_1041 window) {
        if (this.isInBound((class_2374)position, window)) {
            return null;
        }
        class_243 centerPoint = new class_243((double)(window.method_4486() / 2), (double)(window.method_4502() / 2), 0.0);
        float pointerScaleCorrection = (float)Texture.POINTER.height() / 2.0f * (1.0f - ((Float)this.scale.get()).floatValue());
        float minX = (float)(-(centerPoint.field_1352 - (double)((Float)this.horizontalBoundingDistance.get()).floatValue() + (double)pointerScaleCorrection));
        float maxX = (float)centerPoint.field_1352 - ((Float)this.horizontalBoundingDistance.get()).floatValue() + pointerScaleCorrection;
        float minY = (float)(-(centerPoint.field_1351 - (double)((Float)this.topBoundingDistance.get()).floatValue() + (double)pointerScaleCorrection));
        float maxY = (float)centerPoint.field_1351 - ((Float)this.bottomBoundingDistance.get()).floatValue() + pointerScaleCorrection;
        class_243 centerRelativePosition = position.method_1020(centerPoint);
        if (centerRelativePosition.field_1350 > 1.0) {
            centerRelativePosition = centerRelativePosition.method_18805(-1.0, -1.0, 1.0);
        }
        double angle = StrictMath.atan2(centerRelativePosition.field_1351, centerRelativePosition.field_1352);
        double m = StrictMath.tan(angle);
        centerRelativePosition = centerRelativePosition.field_1352 > 0.0 ? new class_243((double)maxX, (double)maxX * m, 0.0) : new class_243((double)minX, (double)minX * m, 0.0);
        if (centerRelativePosition.field_1351 > (double)maxY) {
            centerRelativePosition = new class_243((double)maxY / m, (double)maxY, 0.0);
        } else if (centerRelativePosition.field_1351 < (double)minY) {
            centerRelativePosition = new class_243((double)minY / m, (double)minY, 0.0);
        }
        return new class_241((float)(centerRelativePosition.field_1352 + centerPoint.field_1352), (float)(centerRelativePosition.field_1351 + centerPoint.field_1351));
    }

    private boolean isInBound(class_2374 position, class_1041 window) {
        return position.method_10216() > 0.0 && position.method_10216() < (double)window.method_4486() && position.method_10214() > 0.0 && position.method_10214() < (double)window.method_4502() && position.method_10215() < 1.0;
    }

    @Override
    protected void onConfigUpdate(Config<?> unknownConfig) {
        class_1041 window = McUtils.window();
        switch (unknownConfig.getFieldName()) {
            case "topBoundingDistance": 
            case "bottomBoundingDistance": {
                Config<?> config = unknownConfig;
                if (!(((Float)config.get()).floatValue() > (float)window.method_4502() * 0.4f)) break;
                config.setValue(Float.valueOf((float)window.method_4502() * 0.4f));
                break;
            }
            case "horizontalBoundingDistance": {
                Config<?> config = unknownConfig;
                if (!(((Float)config.get()).floatValue() > (float)window.method_4486() * 0.4f)) break;
                config.setValue(Float.valueOf((float)window.method_4486() * 0.4f));
            }
        }
    }

    private record RenderedMarkerInfo(double distance, String distanceText, MarkerInfo markerInfo, class_243 screenCoordinates, String additionalText) {
    }
}

