/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.overlays;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.type.NpcDialogueType;
import com.wynntils.mc.event.PacketEvent;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.npcdialogue.event.NpcDialogueProcessingEvent;
import com.wynntils.models.npcdialogue.type.NpcDialogue;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.overlays.NpcDialogueOverlay;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2848;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.OVERLAYS)
public class NpcDialogueFeature
extends Feature {
    private static final StyledText PRESS_SHIFT_TO_CONTINUE = StyledText.fromString("                   \u00a77Press \u00a7fSHIFT \u00a77to continue");
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    private final NpcDialogueOverlay npcDialogueOverlay = new NpcDialogueOverlay();
    @RegisterKeyBind
    public final KeyBind cancelAutoProgressKeybind = new KeyBind("Cancel Dialog Auto Progress", 89, false, this::cancelAutoProgress);
    @Persisted
    private final Config<NpcDialogueChatDisplayType> chatDisplayType = new Config<NpcDialogueChatDisplayType>(NpcDialogueChatDisplayType.NORMAL);
    @Persisted
    private final Config<Boolean> autoProgress = new Config<Boolean>(false);
    @Persisted
    public final Config<Integer> dialogAutoProgressDefaultTime = new Config<Integer>(1600);
    @Persisted
    public final Config<Integer> dialogAutoProgressAdditionalTimePerWord = new Config<Integer>(300);
    private final ScheduledExecutorService autoProgressExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> scheduledAutoProgressKeyPress = null;
    private List<class_2561> currentlyDisplayedDialogue = null;
    private NpcDialogue currentDialogue = null;
    private List<NpcDialogue> confirmationlessDialogues = new ArrayList<NpcDialogue>();
    private MessageContainer autoProgressContainer = null;
    private List<class_2561> lastDialogue = null;
    private MessageContainer displayedHelperContainer = null;
    private StyledText displayedHelperMessage = null;

    public NpcDialogueFeature() {
        Models.NpcDialogue.addNpcDialogExtractionDependent(this);
    }

    @SubscribeEvent
    public void onNpcDialogue(NpcDialogueProcessingEvent.Pre event) {
        NpcDialogue dialogue = event.getDialogue();
        NpcDialogueType dialogueType = dialogue.dialogueType();
        if (dialogueType == NpcDialogueType.CONFIRMATIONLESS) {
            return;
        }
        if (((Boolean)this.autoProgress.get()).booleanValue() && dialogueType == NpcDialogueType.NORMAL && !dialogue.isEmpty()) {
            this.scheduledAutoProgressKeyPress = this.scheduledSneakPress(dialogue.currentDialogue());
            this.updateAutoProgressNotification();
        }
    }

    @SubscribeEvent
    public void onNpcDialoguePost(NpcDialogueProcessingEvent.Post event) {
        NpcDialogue dialogue = event.getDialogue();
        if (!Managers.Overlay.isEnabled(this.npcDialogueOverlay) && this.chatDisplayType.get() == NpcDialogueChatDisplayType.LEGACY) {
            this.printLegacyDialogueInChat(event.getPostProcessedDialogueComponent(), dialogue.dialogueType(), dialogue.isProtected());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (Managers.Overlay.isEnabled(this.npcDialogueOverlay)) {
            return;
        }
        this.updateAutoProgressNotification();
        if (this.chatDisplayType.get() == NpcDialogueChatDisplayType.NORMAL) {
            this.updateDialogueScreen();
        }
        if (this.chatDisplayType.get() == NpcDialogueChatDisplayType.LEGACY) {
            if (!Models.NpcDialogue.isInDialogue()) {
                this.lastDialogue = null;
                this.removeHelperMessage();
                this.resetAutoProgressContainer();
                return;
            }
            this.displayHelperMessage();
        }
    }

    @SubscribeEvent
    public void onPacketSent(PacketEvent.PacketSentEvent<?> e) {
        if (this.scheduledAutoProgressKeyPress == null) {
            return;
        }
        Object t = e.getPacket();
        if (!(t instanceof class_2848)) {
            return;
        }
        class_2848 packet = (class_2848)t;
        if (packet.method_12365() != class_2848.class_2849.field_12979) {
            return;
        }
        this.scheduledAutoProgressKeyPress.cancel(true);
        this.autoProgressExecutor.schedule(() -> McUtils.sendPacket(new class_2848((class_1297)McUtils.player(), class_2848.class_2849.field_12984)), 100L, TimeUnit.MILLISECONDS);
        this.scheduledAutoProgressKeyPress = null;
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent e) {
        this.cancelAutoProgress();
        this.currentlyDisplayedDialogue = null;
        this.currentDialogue = null;
        this.confirmationlessDialogues = new ArrayList<NpcDialogue>();
        this.autoProgressContainer = null;
        this.lastDialogue = null;
        this.displayedHelperMessage = null;
        this.displayedHelperContainer = null;
    }

    private void cancelAutoProgress() {
        if (this.scheduledAutoProgressKeyPress == null) {
            return;
        }
        this.scheduledAutoProgressKeyPress.cancel(true);
        this.resetAutoProgressContainer();
    }

    public ScheduledFuture<?> getScheduledAutoProgressKeyPress() {
        return this.scheduledAutoProgressKeyPress;
    }

    private ScheduledFuture<?> scheduledSneakPress(List<StyledText> dialogue) {
        long delay = Models.NpcDialogue.calculateMessageReadTime(dialogue);
        return this.autoProgressExecutor.schedule(() -> McUtils.sendPacket(new class_2848((class_1297)McUtils.player(), class_2848.class_2849.field_12979)), delay, TimeUnit.MILLISECONDS);
    }

    private void printLegacyDialogueInChat(List<class_2561> dialogues, NpcDialogueType type, boolean isProtected) {
        if (!Objects.equals(dialogues, this.lastDialogue)) {
            this.lastDialogue = dialogues;
            dialogues.forEach(McUtils::sendMessageToClient);
        }
        if (type == NpcDialogueType.SELECTION) {
            this.displayedHelperMessage = StyledText.fromComponent((class_2561)class_2561.method_43471((String)"feature.wynntils.npcDialogue.selectAnOption").method_27692(class_124.field_1061));
            this.displayHelperMessage();
        } else if (type == NpcDialogueType.NORMAL) {
            this.displayedHelperMessage = StyledText.fromComponent((class_2561)class_2561.method_43471((String)"feature.wynntils.npcDialogue.shiftToProgress").method_27692(class_124.field_1060));
            this.displayHelperMessage();
        }
    }

    private void updateDialogueScreen() {
        List<NpcDialogue> confirmationlessDialogues = Models.NpcDialogue.getConfirmationlessDialogues();
        NpcDialogue currentDialogue = Models.NpcDialogue.getCurrentDialogue();
        if (currentDialogue == null || currentDialogue.isEmpty() && confirmationlessDialogues.isEmpty()) {
            this.clearLastDialogue();
            return;
        }
        if (Objects.equals(currentDialogue, this.currentDialogue) && Objects.equals(confirmationlessDialogues, this.confirmationlessDialogues)) {
            return;
        }
        this.currentDialogue = currentDialogue;
        this.confirmationlessDialogues = confirmationlessDialogues;
        ArrayList<class_2561> screenLines = new ArrayList<class_2561>();
        for (NpcDialogue confirmationlessDialogue : confirmationlessDialogues) {
            screenLines.add((class_2561)class_2561.method_43473());
            screenLines.addAll(confirmationlessDialogue.dialogueComponent());
        }
        if (!currentDialogue.isEmpty()) {
            screenLines.add((class_2561)class_2561.method_43473());
            screenLines.addAll(currentDialogue.currentDialogue().stream().map(StyledText::getComponent).toList());
            screenLines.add((class_2561)class_2561.method_43473());
            screenLines.add((class_2561)PRESS_SHIFT_TO_CONTINUE.getComponent());
            screenLines.add((class_2561)class_2561.method_43473());
        } else {
            screenLines.add((class_2561)class_2561.method_43473());
        }
        this.clearLastDialogue();
        screenLines.forEach(McUtils::sendMessageToClient);
        this.currentlyDisplayedDialogue = screenLines;
    }

    private void updateAutoProgressNotification() {
        if (!((Boolean)this.autoProgress.get()).booleanValue()) {
            return;
        }
        if (this.getScheduledAutoProgressKeyPress() == null) {
            return;
        }
        if (this.getScheduledAutoProgressKeyPress().isCancelled()) {
            return;
        }
        long timeUntilProgress = this.getScheduledAutoProgressKeyPress().getDelay(TimeUnit.MILLISECONDS);
        StyledText autoProgressStyledText = StyledText.fromString(String.valueOf(class_124.field_1060) + "Auto-progress: " + Math.max(0, Math.round((float)timeUntilProgress / 1000.0f)) + " seconds (Press " + StyledText.fromComponent(this.cancelAutoProgressKeybind.getKeyMapping().method_16007()).getStringWithoutFormatting() + " to cancel)");
        this.autoProgressContainer = this.autoProgressContainer != null ? Managers.Notification.editMessage(this.autoProgressContainer, autoProgressStyledText) : Managers.Notification.queueMessage(autoProgressStyledText);
    }

    private void clearLastDialogue() {
        if (this.currentlyDisplayedDialogue != null) {
            this.currentlyDisplayedDialogue.forEach(McUtils::removeMessageFromChat);
            this.currentlyDisplayedDialogue = null;
        }
        this.resetAutoProgressContainer();
    }

    private void resetAutoProgressContainer() {
        if (this.autoProgressContainer != null) {
            Managers.Notification.removeMessage(this.autoProgressContainer);
            this.autoProgressContainer = null;
        }
    }

    private void displayHelperMessage() {
        if (this.displayedHelperMessage == null) {
            return;
        }
        if (this.displayedHelperContainer == null) {
            this.displayedHelperContainer = Managers.Notification.queueMessage(this.displayedHelperMessage);
            return;
        }
        this.displayedHelperContainer = Managers.Notification.editMessage(this.displayedHelperContainer, this.displayedHelperMessage);
    }

    private void removeHelperMessage() {
        this.displayedHelperMessage = null;
        if (this.displayedHelperContainer != null) {
            Managers.Notification.removeMessage(this.displayedHelperContainer);
            this.displayedHelperContainer = null;
        }
    }

    public static enum NpcDialogueChatDisplayType {
        NORMAL,
        LEGACY;

    }
}

