/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.players;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.models.players.event.FriendsEvent;
import com.wynntils.models.players.event.PartyEvent;
import com.wynntils.screens.partymanagement.PartyManagementScreen;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.class_437;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.PLAYERS)
public class PartyManagementScreenFeature
extends Feature {
    private PartyManagementScreen partyManagementScreen;
    @RegisterKeyBind
    private final KeyBind openPartyManagementScreen = new KeyBind("Open Party Management Screen", 79, true, () -> {
        this.partyManagementScreen = (PartyManagementScreen)PartyManagementScreen.create();
        McUtils.mc().method_1507((class_437)this.partyManagementScreen);
    });

    @SubscribeEvent
    public void onScreenClose(ScreenClosedEvent.Post e) {
        this.partyManagementScreen = null;
    }

    @SubscribeEvent
    public void onPartyList(PartyEvent.Listed e) {
        this.reloadScreenWidgets();
    }

    @SubscribeEvent
    public void onPartyMemberJoin(PartyEvent.OtherJoined e) {
        this.reloadScreenWidgets();
    }

    @SubscribeEvent
    public void onPartyMemberLeave(PartyEvent.OtherLeft e) {
        this.reloadScreenWidgets();
    }

    @SubscribeEvent
    public void onPartyMemberDisconnect(PartyEvent.OtherDisconnected e) {
        this.reloadScreenWidgets();
    }

    @SubscribeEvent
    public void onPartyMemberReconnect(PartyEvent.OtherReconnected e) {
        this.reloadScreenWidgets();
    }

    @SubscribeEvent
    public void onPartyPriorityChanged(PartyEvent.PriorityChanged e) {
        this.reloadScreenWidgets();
    }

    @SubscribeEvent
    public void onFriendJoin(FriendsEvent.Joined e) {
        this.reloadScreenWidgets();
    }

    @SubscribeEvent
    public void onFriendLeave(FriendsEvent.Left e) {
        Managers.TickScheduler.scheduleLater(this::reloadScreenWidgets, 3);
    }

    @SubscribeEvent
    public void onFriendsList(FriendsEvent.Listed e) {
        Managers.TickScheduler.scheduleLater(this::reloadScreenWidgets, 2);
    }

    @SubscribeEvent
    public void onOnlineFriendsList(FriendsEvent.OnlineListed e) {
        Managers.TickScheduler.scheduleLater(this::reloadScreenWidgets, 2);
    }

    private void reloadScreenWidgets() {
        if (this.partyManagementScreen == null) {
            return;
        }
        this.partyManagementScreen.reloadCreateLeaveButton();
        this.partyManagementScreen.reloadMembersWidgets();
        this.partyManagementScreen.reloadSuggestedPlayersWidgets();
    }
}

