/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.redirects;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.SubtitleSetTextEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.REDIRECTS)
public class InventoryRedirectFeature
extends Feature {
    private static final Pattern INGREDIENT_POUCH_PICKUP_PATTERN = Pattern.compile("^\u00a7a\\+\\d+ \u00a77.+\u00a7a to pouch$");
    private static final Pattern EMERALD_POUCH_PICKUP_PATTERN = Pattern.compile("\u00a7a\\+(\\d+)\u00a77 Emeralds? \u00a7ato pouch");
    private static final Pattern POTION_STACK_PATTERN = Pattern.compile("\u00a7a\\+(\\d+)\u00a77 potion \u00a7acharges?");
    private long lastEmeraldPouchPickup = 0L;
    private MessageContainer emeraldPouchMessage = null;
    @Persisted
    private final Config<Boolean> redirectIngredientPouch = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> redirectEmeraldPouch = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> redirectPotionStack = new Config<Boolean>(true);

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        this.lastEmeraldPouchPickup = 0L;
        this.emeraldPouchMessage = null;
    }

    @SubscribeEvent
    public void onSubtitleSetText(SubtitleSetTextEvent event) {
        Matcher matcher;
        if (!(((Boolean)this.redirectEmeraldPouch.get()).booleanValue() || ((Boolean)this.redirectIngredientPouch.get()).booleanValue() || ((Boolean)this.redirectPotionStack.get()).booleanValue())) {
            return;
        }
        class_2561 component = event.getComponent();
        StyledText styledText = StyledText.fromComponent(component);
        if (((Boolean)this.redirectIngredientPouch.get()).booleanValue() && styledText.getMatcher(INGREDIENT_POUCH_PICKUP_PATTERN).matches()) {
            event.setCanceled(true);
            Managers.Notification.queueMessage(styledText);
            return;
        }
        if (((Boolean)this.redirectEmeraldPouch.get()).booleanValue() && (matcher = styledText.getMatcher(EMERALD_POUCH_PICKUP_PATTERN)).matches()) {
            event.setCanceled(true);
            this.emeraldPouchMessage = this.lastEmeraldPouchPickup > System.currentTimeMillis() - 3000L && this.emeraldPouchMessage != null ? Managers.Notification.editMessage(this.emeraldPouchMessage, styledText) : Managers.Notification.queueMessage(styledText);
            this.lastEmeraldPouchPickup = System.currentTimeMillis();
            return;
        }
        if (((Boolean)this.redirectPotionStack.get()).booleanValue() && (matcher = styledText.getMatcher(POTION_STACK_PATTERN)).matches()) {
            event.setCanceled(true);
            String potionCount = matcher.group(1);
            StyledText potionMessage = StyledText.fromString(String.format("\u00a7a+%s Potion Charges", potionCount));
            Managers.Notification.queueMessage(potionMessage);
            return;
        }
    }
}

