/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.tooltips;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.tooltips.TooltipFittingFeature;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.HotbarSlotRenderEvent;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.mc.event.TooltipRenderEvent;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.wynnitem.parsing.WynnItemParser;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.TooltipUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.wynn.InventoryUtils;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Vector2i;
import org.joml.Vector2ic;

@ConfigCategory(value=Category.TOOLTIPS)
public class ItemCompareFeature
extends Feature {
    @Persisted
    private final Config<Integer> maxCompareSelectedCount = new Config<Integer>(4);
    @Persisted
    private final Config<Boolean> removeFlavourText = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> removeSetInfoText = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> displayTag = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> centerItemName = new Config<Boolean>(false);
    @RegisterKeyBind
    private final KeyBind holdToCompareKeyBind = new KeyBind("Hold to compare", 335, false, null, null);
    @RegisterKeyBind
    private final KeyBind selectCompareKeyBind = new KeyBind("Select for comparing", 334, true, null, this::onSelectKeyPress);
    private final List<Pair<WynnItem, class_1799>> selectedItems = new ArrayList<Pair<WynnItem, class_1799>>();
    private static final int COMPARE_ITEM_PAD = 6;
    private static final String EQUIPPED_KEY = "feature.wynntils.itemCompare.tag.equipped";
    private static final String HOVERED_KEY = "feature.wynntils.itemCompare.tag.hovered";
    private static final String SELECTED_KEY = "feature.wynntils.itemCompare.tag.selected";
    private static final String HOVERED_SELECTED_KEY = "feature.wynntils.itemCompare.tag.hovered_selected";
    private int equippedCount = 0;
    private boolean changePositioner = false;

    @SubscribeEvent
    public void onWorldStateChangeEvent(WorldStateEvent event) {
        this.selectedItems.clear();
    }

    @SubscribeEvent
    public void onContainerCloseEvent(ContainerCloseEvent.Post event) {
        this.selectedItems.clear();
    }

    @SubscribeEvent
    public void onInventoryClickEvent(ContainerClickEvent event) {
        this.unselectItemStack(event.getItemStack());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltipRenderEvent(TooltipRenderEvent event) {
        if (!this.changePositioner) {
            return;
        }
        event.setPositioner(PassiveTooltipPositioner.INSTANCE);
    }

    @SubscribeEvent
    public void onSlotRenderEvent(SlotRenderEvent.Pre event) {
        class_1735 slot = event.getSlot();
        this.drawSelectionArc(event.getPoseStack(), slot.method_7677(), slot.field_7873, slot.field_7872, false);
    }

    @SubscribeEvent
    public void onHotbarSlotRenderEvent(HotbarSlotRenderEvent.Pre event) {
        this.drawSelectionArc(event.getPoseStack(), event.getItemStack(), event.getX(), event.getY(), true);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltipRenderEvent(ItemTooltipRenderEvent.Pre event) {
        float scaleFactor;
        class_437 class_4372;
        if (!KeyboardUtils.isKeyDown(this.holdToCompareKeyBind.getKeyMapping().field_1655.method_1444())) {
            return;
        }
        if (McUtils.mc().field_1755 == null || !((class_4372 = McUtils.mc().field_1755) instanceof class_465)) {
            return;
        }
        class_465 abstractContainerScreen = (class_465)class_4372;
        if (abstractContainerScreen.field_2787 == null) {
            return;
        }
        class_1799 hoveredItemStack = abstractContainerScreen.field_2787.method_7677();
        if (event.getItemStack() != hoveredItemStack) {
            return;
        }
        Optional<WynnItem> hoveredWynnItemOpt = Models.Item.getWynnItem(hoveredItemStack);
        if (hoveredWynnItemOpt.isEmpty()) {
            return;
        }
        WynnItem hoveredWynnItem = hoveredWynnItemOpt.get();
        if (!(hoveredWynnItem instanceof GearTypeItemProperty)) {
            return;
        }
        GearTypeItemProperty hoveredGearItemProperty = (GearTypeItemProperty)((Object)hoveredWynnItem);
        ArrayList itemsToCompare = new ArrayList();
        if (!this.isItemStackSelected(hoveredItemStack)) {
            switch (hoveredGearItemProperty.getGearType()) {
                case HELMET: 
                case CHESTPLATE: 
                case LEGGINGS: 
                case BOOTS: {
                    class_2371 armors = McUtils.inventory().field_7548;
                    Optional<class_1799> matchingArmorOpt = armors.stream().filter(itemStack -> this.isMatchingType((class_1799)itemStack, hoveredGearItemProperty)).findFirst();
                    if (!matchingArmorOpt.isPresent()) break;
                    class_1799 armor = matchingArmorOpt.get();
                    Models.Item.getWynnItem(armor).ifPresent(wynnItem -> {
                        if (armor != hoveredItemStack) {
                            itemsToCompare.add(Pair.of(wynnItem, armor));
                            ++this.equippedCount;
                        }
                    });
                    break;
                }
                case RING: 
                case BRACELET: 
                case NECKLACE: {
                    List<class_1799> accessories = InventoryUtils.getAccessories((class_1657)McUtils.player());
                    List<class_1799> matchingAccessories = accessories.stream().filter(itemStack -> this.isMatchingType((class_1799)itemStack, hoveredGearItemProperty)).filter(itemStack -> itemStack != hoveredItemStack).filter(itemStack -> !ItemUtils.isEmptyAccessorySlot(itemStack)).toList();
                    matchingAccessories.forEach(itemStack -> Models.Item.getWynnItem((class_1799)itemStack).ifPresent(wynnItem -> {
                        itemsToCompare.add(Pair.of(wynnItem, itemStack));
                        ++this.equippedCount;
                    }));
                    break;
                }
                case SPEAR: 
                case WAND: 
                case DAGGER: 
                case BOW: 
                case RELIK: {
                    class_1799 inHand = McUtils.player().method_6047();
                    if (inHand == class_1799.field_8037 || inHand == hoveredItemStack) break;
                    Models.Item.getWynnItem(inHand).ifPresent(wynnItem -> {
                        if (this.isMatchingType((WynnItem)wynnItem, hoveredGearItemProperty)) {
                            itemsToCompare.add(Pair.of(wynnItem, inHand));
                            ++this.equippedCount;
                        }
                    });
                }
            }
        }
        List selectedMatchingHovered = this.selectedItems.stream().filter(pair -> this.isMatchingType((WynnItem)pair.a(), hoveredGearItemProperty)).filter(pair -> pair.b() != hoveredItemStack).filter(pair -> !itemsToCompare.contains(pair)).collect(Collectors.toCollection(ArrayList::new));
        while (selectedMatchingHovered.size() > (Integer)this.maxCompareSelectedCount.get()) {
            selectedMatchingHovered.removeLast();
        }
        itemsToCompare.addAll(selectedMatchingHovered);
        if (itemsToCompare.isEmpty()) {
            return;
        }
        class_1041 window = McUtils.mc().method_22683();
        class_332 guiGraphics = event.getGuiGraphics();
        class_327 font = FontRenderer.getInstance().getFont();
        class_4587 poseStack = guiGraphics.method_51448();
        float universalScale = ((Float)Managers.Feature.getFeatureInstance(TooltipFittingFeature.class).universalScale.get()).floatValue();
        int twoPad = 12;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 300.0f);
        ArrayList<class_2561> hoveredLines = new ArrayList<class_2561>(event.getTooltips());
        if (((Boolean)this.removeFlavourText.get()).booleanValue()) {
            this.removeFlavourText(hoveredLines);
        }
        if (((Boolean)this.removeSetInfoText.get()).booleanValue()) {
            this.removeSetInfoText(hoveredLines);
        }
        List<class_5684> hoveredClientComponents = TooltipUtils.getClientTooltipComponent(hoveredLines);
        int hoveredTooltipWidth = TooltipUtils.getTooltipWidth(hoveredClientComponents, font);
        int hoveredTooltipHeight = TooltipUtils.getTooltipHeight(hoveredClientComponents);
        if (((Boolean)this.centerItemName.get()).booleanValue()) {
            this.centerItemName(hoveredLines, hoveredTooltipWidth);
        }
        if (((Boolean)this.displayTag.get()).booleanValue()) {
            if (this.isItemStackSelected(hoveredItemStack)) {
                hoveredLines.addFirst((class_2561)this.getPaddedComponent(this.getTag(HOVERED_SELECTED_KEY), hoveredTooltipWidth));
            } else {
                hoveredLines.addFirst((class_2561)this.getPaddedComponent(this.getTag(HOVERED_KEY), hoveredTooltipWidth));
            }
            Objects.requireNonNull(font);
            hoveredTooltipHeight += 9;
        }
        float hoveredScaleFactor = universalScale;
        if (hoveredTooltipHeight + twoPad > window.method_4502()) {
            scaleFactor = (float)(window.method_4502() - twoPad) / (float)hoveredTooltipHeight;
            hoveredScaleFactor *= scaleFactor;
            hoveredTooltipWidth = (int)((float)hoveredTooltipWidth * scaleFactor);
            hoveredTooltipHeight = (int)((float)hoveredTooltipHeight * scaleFactor);
        }
        if ((float)(hoveredTooltipWidth + twoPad) > (float)window.method_4486() / 3.0f) {
            scaleFactor = ((float)window.method_4486() / 3.0f - (float)twoPad) / (float)hoveredTooltipWidth;
            hoveredScaleFactor *= scaleFactor;
            hoveredTooltipWidth = (int)((float)hoveredTooltipWidth * scaleFactor);
            hoveredTooltipHeight = (int)((float)hoveredTooltipHeight * scaleFactor);
        }
        int hoveredX = window.method_4486() - hoveredTooltipWidth - 6;
        int hoveredY = (int)((float)window.method_4502() / 2.0f - (float)hoveredTooltipHeight / 2.0f);
        ArrayList<Tooltip> tooltips = new ArrayList<Tooltip>();
        int prevX = hoveredX;
        for (Pair pair2 : itemsToCompare) {
            int maxWidth;
            List<class_2561> lines = this.getWynnOrVanillaLines(abstractContainerScreen, (WynnItem)pair2.key(), (class_1799)pair2.value());
            if (((Boolean)this.removeFlavourText.get()).booleanValue()) {
                this.removeFlavourText(lines);
            }
            if (((Boolean)this.removeSetInfoText.get()).booleanValue()) {
                this.removeSetInfoText(lines);
            }
            List<class_5684> clientTooltipComponents = TooltipUtils.getClientTooltipComponent(lines);
            int tooltipWidth = TooltipUtils.getTooltipWidth(clientTooltipComponents, font);
            int tooltipHeight = TooltipUtils.getTooltipHeight(clientTooltipComponents);
            if (((Boolean)this.centerItemName.get()).booleanValue()) {
                this.centerItemName(lines, tooltipWidth);
            }
            if (((Boolean)this.displayTag.get()).booleanValue()) {
                if (this.equippedCount > 0) {
                    lines.addFirst((class_2561)this.getPaddedComponent(this.getTag(EQUIPPED_KEY), tooltipWidth));
                    --this.equippedCount;
                } else {
                    lines.addFirst((class_2561)this.getPaddedComponent(this.getTag(SELECTED_KEY), tooltipWidth));
                }
                Objects.requireNonNull(font);
                tooltipHeight += 9;
            }
            float tooltipScaleFactor = universalScale;
            if (tooltipHeight + twoPad > window.method_4502()) {
                float scaleFactor2 = (float)(window.method_4502() - twoPad) / (float)tooltipHeight;
                tooltipScaleFactor *= scaleFactor2;
                tooltipWidth = (int)((float)tooltipWidth * scaleFactor2);
                tooltipHeight = (int)((float)tooltipHeight * scaleFactor2);
            }
            if (tooltipWidth + twoPad > (maxWidth = Math.round((float)window.method_4486() / 3.0f))) {
                float scaleFactor3 = (float)(maxWidth - twoPad) / (float)tooltipWidth;
                tooltipScaleFactor *= scaleFactor3;
                tooltipWidth = (int)((float)tooltipWidth * scaleFactor3);
                tooltipHeight = (int)((float)tooltipHeight * scaleFactor3);
            }
            int x = prevX - twoPad - tooltipWidth;
            int y = (int)((float)window.method_4502() / 2.0f - (float)tooltipHeight / 2.0f);
            tooltips.add(new Tooltip(lines, x, y, tooltipWidth, tooltipHeight, tooltipScaleFactor, ((class_1799)pair2.value()).method_32347()));
            prevX = x;
        }
        if (!tooltips.isEmpty() && ((Tooltip)tooltips.getLast()).getX() < 0) {
            this.fixTooltipOverflow(tooltips, window.method_4502());
        }
        int d1 = ((Tooltip)tooltips.getLast()).getX();
        int d2 = window.method_4486() - (hoveredX + hoveredTooltipWidth);
        int offsetX = Math.floorDiv(d1 + d2, 2) - Math.max(d1, d2);
        tooltips.forEach(tooltip -> tooltip.offsetX(offsetX));
        event.setCanceled(true);
        this.changePositioner = true;
        poseStack.method_22903();
        poseStack.method_22905(hoveredScaleFactor, hoveredScaleFactor, 1.0f);
        guiGraphics.method_64038(font, hoveredLines, hoveredItemStack.method_32347(), (int)((float)(hoveredX += offsetX) / hoveredScaleFactor), (int)((float)hoveredY / hoveredScaleFactor));
        poseStack.method_22909();
        for (Tooltip tooltip2 : tooltips) {
            poseStack.method_22903();
            float scaleFactor4 = tooltip2.getScaleFactor();
            poseStack.method_22905(scaleFactor4, scaleFactor4, 1.0f);
            guiGraphics.method_64038(font, tooltip2.getLines(), tooltip2.getVisualTooltipComponent(), (int)((float)tooltip2.getX() / scaleFactor4), (int)((float)tooltip2.getY() / scaleFactor4));
            poseStack.method_22909();
        }
        this.changePositioner = false;
        poseStack.method_22909();
    }

    private boolean isMatchingType(WynnItem wynnItem, GearTypeItemProperty gearItemReference) {
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            return gearItem.getGearType() == gearItemReference.getGearType();
        }
        return false;
    }

    private boolean isMatchingType(class_1799 itemStack, GearTypeItemProperty gearItemReference) {
        Optional<GearTypeItemProperty> gearOpt = Models.Item.asWynnItemProperty(itemStack, GearTypeItemProperty.class);
        return gearOpt.isEmpty() ? false : gearOpt.get().getGearType() == gearItemReference.getGearType();
    }

    private void onSelectKeyPress(class_1735 hoveredSlot) {
        if (hoveredSlot == null) {
            return;
        }
        int slot = hoveredSlot.method_34266();
        for (int i : InventoryAccessory.getSlots()) {
            if (slot != i) continue;
            return;
        }
        for (int i : InventoryArmor.getArmorSlots()) {
            if (slot != i + 36) continue;
            return;
        }
        class_1799 itemStack = hoveredSlot.method_7677();
        if (itemStack.method_7960()) {
            return;
        }
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        WynnItem wynnItem = wynnItemOpt.get();
        if (!(wynnItem instanceof GearItem)) {
            return;
        }
        if (!this.unselectItemStack(itemStack)) {
            this.selectedItems.add(Pair.of(wynnItem, itemStack));
        }
    }

    private boolean isItemStackSelected(class_1799 newItem) {
        for (Pair<WynnItem, class_1799> pair : this.selectedItems) {
            if (!ItemUtils.isItemEqual(pair.b(), newItem)) continue;
            return true;
        }
        return false;
    }

    private boolean unselectItemStack(class_1799 newItem) {
        for (int i = 0; i < this.selectedItems.size(); ++i) {
            if (!ItemUtils.isItemEqual(this.selectedItems.get(i).b(), newItem)) continue;
            this.selectedItems.remove(i);
            return true;
        }
        return false;
    }

    private String getTag(String key) {
        return class_1074.method_4662((String)key, (Object[])new Object[0]);
    }

    private void drawSelectionArc(class_4587 poseStack, class_1799 itemStack, int slotX, int slotY, boolean hotbar) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        if (this.isItemStackSelected(itemStack)) {
            RenderUtils.drawArc(poseStack, CommonColors.LIGHT_BLUE, slotX, slotY, hotbar ? 0.0f : 200.0f, 1.0f, 6, 8);
        }
    }

    private List<class_2561> getWynnOrVanillaLines(class_465<?> screen, WynnItem wynnItem, class_1799 itemStack) {
        List wynnTooltip = TooltipUtils.getWynnItemTooltip(itemStack, wynnItem);
        return wynnTooltip.isEmpty() ? class_465.method_25408((class_310)McUtils.mc(), (class_1799)itemStack) : wynnTooltip;
    }

    private class_5250 getPaddedComponent(String string, int tooltipWidth) {
        class_327 font = FontRenderer.getInstance().getFont();
        int count = Math.round((float)(tooltipWidth - font.method_1727(string)) / 2.0f / (float)font.method_1727(" "));
        return class_2561.method_43470((String)(" ".repeat(count) + string));
    }

    private void removeFlavourText(List<class_2561> lines) {
        class_5251 loreColor = class_5251.method_27718((class_124)class_124.field_1063);
        for (int i = lines.size() - 1; i >= 0; --i) {
            class_2561 line = lines.get(i);
            StyledText styledText = StyledText.fromComponent(line);
            if (styledText.getPartCount() <= 0) continue;
            if (styledText.getFirstPart().getComponent().method_10866().method_10973().equals((Object)loreColor)) {
                lines.remove(i);
                continue;
            }
            if (!ItemUtils.ITEM_RARITY_PATTERN.matcher(line.getString()).find()) continue;
            return;
        }
    }

    private void removeSetInfoText(List<class_2561> lines) {
        for (int i = lines.size() - 1; i >= 0; --i) {
            StyledText line = StyledText.fromComponent(lines.get(i)).getNormalized();
            if (line.getMatcher(WynnItemParser.SET_ITEM_PATTERN).matches()) {
                lines.remove(i);
                continue;
            }
            if (!line.getMatcher(WynnItemParser.SET_PATTERN).matches()) continue;
            lines.remove(i);
            lines.remove(i - 1);
            return;
        }
    }

    private void centerItemName(List<class_2561> lines, int tooltipWidth) {
        class_2561 title = lines.removeFirst();
        String string = this.getPaddedComponent(title.getString(), tooltipWidth).getString();
        int count = string.indexOf(string.trim());
        class_5250 newTitle = class_2561.method_43470((String)" ".repeat(count));
        title.method_10855().forEach(arg_0 -> ((class_5250)newTitle).method_10852(arg_0));
        lines.addFirst((class_2561)newTitle);
    }

    private void fixTooltipOverflow(List<Tooltip> tooltips, int screenHeight) {
        ArrayList<Tooltip> overflowTooltips = new ArrayList<Tooltip>();
        while (tooltips.getLast().getX() < 0) {
            overflowTooltips.add(tooltips.removeLast());
        }
        overflowTooltips.sort(Comparator.comparingInt(Tooltip::getHeight));
        ArrayList<Tooltip> heightSortedTooltips = new ArrayList<Tooltip>(tooltips);
        heightSortedTooltips.sort(Comparator.comparingInt(Tooltip::getHeight));
        Collections.reverse(heightSortedTooltips);
        if (heightSortedTooltips.size() > overflowTooltips.size()) {
            heightSortedTooltips.subList(0, heightSortedTooltips.size() - overflowTooltips.size()).clear();
        } else if (heightSortedTooltips.size() < overflowTooltips.size()) {
            overflowTooltips.subList(heightSortedTooltips.size(), overflowTooltips.size() - 1).clear();
        }
        for (int i = 0; i < heightSortedTooltips.size(); ++i) {
            float scaleFactor;
            Tooltip overflow = (Tooltip)overflowTooltips.get(i);
            Tooltip tooltip = (Tooltip)heightSortedTooltips.get(i);
            int index = tooltips.indexOf(tooltip);
            float tooltipScaleFactor = 1.0f;
            float overflowScaleFactor = 1.0f;
            int tooltipHeight = tooltip.getHeight();
            int overflowHeight = overflow.getHeight();
            int tooltipWidth = tooltip.getWidth();
            int overflowWidth = overflow.getWidth();
            if ((float)(tooltipHeight + overflowHeight) + 24.0f > (float)screenHeight) {
                scaleFactor = ((float)screenHeight - 24.0f) / (float)(tooltipHeight + overflowHeight);
                if (scaleFactor < 0.5f) continue;
                tooltipScaleFactor *= scaleFactor;
                overflowScaleFactor *= scaleFactor;
                int offsetX = (int)((float)tooltipWidth * (1.0f - scaleFactor));
                for (int j = index; j < tooltips.size(); ++j) {
                    Tooltip t = tooltips.get(j);
                    t.offsetX(offsetX);
                }
                tooltipHeight = (int)((float)tooltipHeight * scaleFactor);
                overflowHeight = (int)((float)overflowHeight * scaleFactor);
                tooltipWidth = (int)((float)tooltipWidth * scaleFactor);
                overflowWidth = (int)((float)overflowWidth * scaleFactor);
            }
            if (overflowWidth > tooltipWidth) {
                scaleFactor = (float)tooltipWidth / (float)overflowWidth;
                overflowScaleFactor *= scaleFactor;
                overflowHeight = (int)((float)overflowHeight * scaleFactor);
            }
            int tooltipY = 6;
            int overflowY = tooltipY + tooltipHeight + 12;
            int d1 = tooltipY;
            int d2 = screenHeight - overflowY - overflowHeight;
            int offsetY = Math.floorDiv(d1 + d2, 2) - Math.min(d1, d2);
            tooltip.setY(tooltipY += offsetY);
            tooltip.multScaleFactor(tooltipScaleFactor);
            overflow.setX(tooltip.getX());
            overflow.setY(overflowY += offsetY);
            overflow.multScaleFactor(overflowScaleFactor);
            tooltips.add(index, overflow);
        }
    }

    private static final class PassiveTooltipPositioner
    implements class_8000 {
        private static final class_8000 INSTANCE = new PassiveTooltipPositioner();

        private PassiveTooltipPositioner() {
        }

        public Vector2ic method_47944(int screenWidth, int screenHeight, int mouseX, int mouseY, int tooltipWidth, int tooltipHeight) {
            return new Vector2i(mouseX, mouseY);
        }
    }

    private static final class Tooltip {
        private final List<class_2561> lines;
        private int x;
        private int y;
        private final int width;
        private final int height;
        private float scaleFactor;
        private final Optional<class_5632> visualTooltipComponent;

        private Tooltip(List<class_2561> lines, int x, int y, int width, int height, float scaleFactor, Optional<class_5632> visualTooltipComponent) {
            this.lines = lines;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.scaleFactor = scaleFactor;
            this.visualTooltipComponent = visualTooltipComponent;
        }

        public List<class_2561> getLines() {
            return Collections.unmodifiableList(this.lines);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getScaleFactor() {
            return this.scaleFactor;
        }

        public Optional<class_5632> getVisualTooltipComponent() {
            return this.visualTooltipComponent;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void offsetX(int offset) {
            this.x += offset;
        }

        public void multScaleFactor(float k) {
            this.scaleFactor *= k;
        }
    }
}

