/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.TitleScreenInitEvent;
import com.wynntils.models.worlds.type.ServerRegion;
import com.wynntils.screens.downloads.DownloadScreen;
import com.wynntils.screens.update.UpdateScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_4597;
import net.minecraft.class_500;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_644;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.Validate;

@ConfigCategory(value=Category.UI)
public class WynncraftButtonFeature
extends Feature {
    private static final String WYNNCRAFT_DOMAIN = ".wynncraft.com";
    private boolean firstTitleScreenInit = true;
    private boolean hasUsedButton = false;
    @Persisted
    private final Config<ServerType> serverType = new Config<ServerType>(ServerType.GAME);
    @Persisted
    private final Config<ServerRegion> serverRegionOverride = new Config<ServerRegion>(ServerRegion.WC);
    @Persisted
    private final Config<Boolean> autoConnect = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> loadResourcePack = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> cancelAutoJoin = new Config<Boolean>(true);
    @Persisted
    public final Storage<Boolean> ignoreFailedDownloads = new Storage<Boolean>(false);
    @Persisted
    private final Config<Boolean> returnToTitle = new Config<Boolean>(true);

    @SubscribeEvent
    public void onTitleScreenInit(TitleScreenInitEvent.Post event) {
        class_442 titleScreen = event.getTitleScreen();
        this.addWynncraftButton(titleScreen);
    }

    @SubscribeEvent
    public void onScreenOpen(ScreenOpenedEvent.Pre event) {
        if (!this.hasUsedButton) {
            return;
        }
        if (event.getScreen() instanceof class_442) {
            this.hasUsedButton = false;
            return;
        }
        if (event.getScreen() instanceof class_500) {
            this.hasUsedButton = false;
            if (((Boolean)this.returnToTitle.get()).booleanValue()) {
                event.setCanceled(true);
                McUtils.mc().method_1507((class_437)new class_442());
            }
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        class_437 class_4372 = event.getScreen();
        if (!(class_4372 instanceof class_442)) {
            return;
        }
        class_442 titleScreen = (class_442)class_4372;
        if (this.firstTitleScreenInit && ((Boolean)this.autoConnect.get()).booleanValue()) {
            this.firstTitleScreenInit = false;
            if (Managers.Download.graphState().error() && ((Boolean)this.cancelAutoJoin.get()).booleanValue() && !((Boolean)this.ignoreFailedDownloads.get()).booleanValue()) {
                WynntilsMod.warn("Downloads have failed, auto join is cancelled.");
                return;
            }
            if (Services.Update.shouldPromptUpdate()) {
                WynntilsMod.info("Cancelling auto join, update available");
                return;
            }
            class_642 wynncraftServer = this.getWynncraftServer();
            this.connectToServer(wynncraftServer);
            return;
        }
        this.addWynncraftButton(titleScreen);
    }

    private void addWynncraftButton(class_442 titleScreen) {
        if (titleScreen.field_22786.stream().anyMatch(child -> child instanceof WynncraftButton)) {
            return;
        }
        class_642 wynncraftServer = this.getWynncraftServer();
        WarningType warningType = WarningType.NONE;
        if (Managers.Download.graphState().error()) {
            warningType = WarningType.DOWNLOADS;
        } else if (Services.Update.shouldPromptUpdate()) {
            warningType = WarningType.UPDATE;
        }
        WynncraftButton wynncraftButton = new WynncraftButton((class_437)titleScreen, wynncraftServer, titleScreen.field_22789 / 2 + 104, titleScreen.field_22790 / 4 + 48 + 24, warningType, (Boolean)this.ignoreFailedDownloads.get(), this::onPress);
        titleScreen.method_37063((class_364)wynncraftButton);
    }

    private class_642 getWynncraftServer() {
        String ip = (this.serverType.get() == ServerType.GAME && this.serverRegionOverride.get() != ServerRegion.WC ? ((ServerRegion)((Object)this.serverRegionOverride.get())).name().toLowerCase(Locale.ROOT) : ((ServerType)((Object)this.serverType.get())).serverAddressPrefix) + WYNNCRAFT_DOMAIN;
        class_642 wynncraftServer = new class_642("Wynncraft", ip, class_642.class_8678.field_45611);
        wynncraftServer.method_2995((Boolean)this.loadResourcePack.get() != false ? class_642.class_643.field_3768 : class_642.class_643.field_3764);
        return wynncraftServer;
    }

    private void connectToServer(class_642 serverData) {
        this.hasUsedButton = true;
        class_412.method_36877((class_437)McUtils.mc().field_1755, (class_310)McUtils.mc(), (class_639)class_639.method_2950((String)serverData.field_3761), (class_642)serverData, (boolean)false, null);
    }

    private void onPress(class_4185 button) {
        if (!(button instanceof WynncraftButton)) {
            return;
        }
        WynncraftButton wynncraftButton = (WynncraftButton)button;
        if (!Managers.Download.graphState().finished()) {
            return;
        }
        if (wynncraftButton.warningType == WarningType.UPDATE) {
            McUtils.mc().method_1507(UpdateScreen.create(wynncraftButton.serverData, wynncraftButton.titleScreen));
        } else if (wynncraftButton.warningType == WarningType.DOWNLOADS && !wynncraftButton.ignoreFailedDownloads) {
            McUtils.mc().method_1507(DownloadScreen.create(McUtils.mc().field_1755, wynncraftButton.serverData));
        } else {
            this.connectToServer(wynncraftButton.serverData);
        }
    }

    private static enum ServerType {
        LOBBY("lobby"),
        GAME("play"),
        MEDIA("media"),
        BETA("beta");

        private final String serverAddressPrefix;

        private ServerType(String serverAddressPrefix) {
            this.serverAddressPrefix = serverAddressPrefix;
        }
    }

    private static enum WarningType {
        NONE,
        DOWNLOADS,
        UPDATE;

    }

    private static class WynncraftButton
    extends class_4185 {
        private static final List<class_2561> CONNECT_TOOLTIP = List.of(class_2561.method_43471((String)"feature.wynntils.wynncraftButton.connect"));
        private static final List<class_2561> DOWNLOAD_TOOLTIP = List.of(class_2561.method_43471((String)"feature.wynntils.wynncraftButton.download1"), class_2561.method_43471((String)"feature.wynntils.wynncraftButton.download2"));
        private static final List<class_2561> UPDATE_TOOLTIP = List.of(class_2561.method_43471((String)"feature.wynntils.wynncraftButton.update"));
        private final class_437 titleScreen;
        private final class_642 serverData;
        private final ServerIcon serverIcon;
        private final WarningType warningType;
        private final boolean ignoreFailedDownloads;
        private final List<class_2561> tooltip;

        WynncraftButton(class_437 titleScreen, class_642 serverData, int x, int y, WarningType warningType, boolean ignoreFailedDownloads, class_4185.class_4241 onPress) {
            super(x, y, 20, 20, (class_2561)class_2561.method_43470((String)""), onPress, class_4185.field_40754);
            this.serverData = serverData;
            this.titleScreen = titleScreen;
            this.serverIcon = new ServerIcon(serverData);
            this.serverIcon.loadResource(false);
            this.warningType = warningType;
            this.ignoreFailedDownloads = ignoreFailedDownloads;
            this.tooltip = warningType == WarningType.DOWNLOADS ? DOWNLOAD_TOOLTIP : (warningType == WarningType.UPDATE ? UPDATE_TOOLTIP : CONNECT_TOOLTIP);
        }

        public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.serverIcon == null || this.serverIcon.getServerIconLocation() == null) {
                return;
            }
            BufferedRenderUtils.drawScalingTexturedRect(guiGraphics.method_51448(), (class_4597)guiGraphics.field_44658, this.serverIcon.getServerIconLocation(), this.method_46426() + 3, this.method_46427() + 3, 0.0f, this.field_22758 - 6, this.field_22759 - 6, 64, 64);
            if (this.warningType == WarningType.DOWNLOADS) {
                FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString("\u26a0"), this.method_46426() + 20, this.method_46427(), CommonColors.RED, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
            } else if (this.warningType == WarningType.UPDATE) {
                FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString("\u27f3"), (float)(this.method_46426() + 2), (float)this.method_46427(), CommonColors.YELLOW, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE, 1.5f);
            }
            if (this.field_22762) {
                McUtils.mc().field_1755.method_47414(Lists.transform(this.tooltip, class_2561::method_30937));
            }
        }
    }

    private static final class ServerIcon {
        private static final class_2960 FALLBACK = Texture.WYNNCRAFT_ICON.resource();
        private final class_642 server;
        private class_2960 serverIconLocation;
        private final Consumer<ServerIcon> onDone;

        private ServerIcon(class_642 server, Consumer<ServerIcon> onDone) {
            this.server = server;
            this.onDone = onDone;
            this.serverIconLocation = FALLBACK;
        }

        private void loadResource(boolean allowStale) {
            class_2960 destination = class_2960.method_60656((String)("servers/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)this.server.field_3761)) + "/icon"));
            if (allowStale && McUtils.mc().method_1531().method_4619(destination) != null) {
                this.serverIconLocation = destination;
                this.onDone();
                return;
            }
            try {
                class_644 pinger = new class_644();
                pinger.method_3003(this.server, () -> {}, this::onDone);
            }
            catch (Exception e) {
                WynntilsMod.warn("Failed to ping server", e);
                this.onDone();
            }
        }

        private ServerIcon(class_642 server) {
            this(server, null);
        }

        public boolean isSuccess() {
            return !FALLBACK.equals((Object)this.serverIconLocation);
        }

        public class_642 getServer() {
            return this.server;
        }

        private synchronized class_2960 getServerIconLocation() {
            return this.serverIconLocation;
        }

        private void onDone() {
            if (this.onDone != null) {
                this.onDone.accept(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadServerIcon(class_2960 destination) {
            byte[] iconBytes = this.server.method_49306();
            if (iconBytes == null) {
                WynntilsMod.warn("Unable to load icon");
                this.serverIconLocation = FALLBACK;
                return;
            }
            ByteBuffer iconBytesBuffer = ByteBuffer.wrap(iconBytes);
            try (class_1011 nativeImage = class_1011.method_4324((ByteBuffer)iconBytesBuffer);){
                Validate.validState((nativeImage.method_4307() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((nativeImage.method_4323() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ServerIcon serverIcon = this;
                synchronized (serverIcon) {
                    RenderSystem.recordRenderCall(() -> {
                        McUtils.mc().method_1531().method_4616(destination, (class_1044)new class_1043(nativeImage));
                        this.serverIconLocation = destination;
                    });
                }
            }
            catch (IOException e) {
                WynntilsMod.error("Unable to read server image: " + this.server.field_3752, e);
                this.serverIconLocation = FALLBACK;
            }
        }
    }
}

