/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class PerCharacterGuildContributionFeature
extends Feature {
    private static final Pattern CONTRIBUTION_PATTERN = Pattern.compile("\u00a73You will now contribute \u00a7b(\\d+)%\u00a73 of your XP to \u00a7b.*\u00a73.");
    @Persisted
    private final HiddenConfig<Map<String, Integer>> characterContributions = new HiddenConfig(new TreeMap());
    @Persisted
    private final Config<Boolean> hideContributionMessage = new Config<Boolean>(true);
    private boolean waitingForCommandResponse = false;

    @SubscribeEvent
    public void onCharacterChange(CharacterUpdateEvent e) {
        if (Models.Guild.getGuildName().isEmpty()) {
            return;
        }
        int amountToContribute = ((Map)this.characterContributions.get()).getOrDefault(Models.Character.getId(), -1);
        if (amountToContribute != -1) {
            this.waitingForCommandResponse = true;
            Handlers.Command.queueCommand("guild xp " + amountToContribute);
        }
    }

    @SubscribeEvent
    public void onChatReceived(ChatMessageEvent.Match event) {
        if (Models.Guild.getGuildName().isEmpty()) {
            return;
        }
        if (!Models.Character.hasCharacter()) {
            return;
        }
        StyledText message = event.getMessage();
        Matcher contributionMatcher = message.getMatcher(CONTRIBUTION_PATTERN);
        if (contributionMatcher.matches()) {
            event.setCanceled(true);
            if (this.waitingForCommandResponse) {
                this.waitingForCommandResponse = false;
                if (!((Boolean)this.hideContributionMessage.get()).booleanValue()) {
                    this.sendContributionMessage((Integer)((Map)this.characterContributions.get()).get(Models.Character.getId()));
                }
                return;
            }
            int contributionAmount = Integer.parseInt(contributionMatcher.group(1));
            if (contributionAmount < 0 || contributionAmount > 100) {
                return;
            }
            ((Map)this.characterContributions.get()).put(Models.Character.getId(), contributionAmount);
            this.characterContributions.touched();
            this.sendContributionMessage(contributionAmount);
        }
    }

    private void sendContributionMessage(int contributionAmount) {
        class_5250 contributionMessage = class_2561.method_43470((String)(String.valueOf(class_124.field_1062) + "You will now contribute " + String.valueOf(class_124.field_1075) + contributionAmount + "%" + String.valueOf(class_124.field_1062) + " of your XP to " + String.valueOf(class_124.field_1075) + Models.Guild.getGuildName() + String.valueOf(class_124.field_1062) + ".\n"));
        contributionMessage.method_10852((class_2561)class_2561.method_43470((String)"This will only apply to your current character.\n").method_27692(class_124.field_1062));
        contributionMessage.method_10852((class_2561)class_2561.method_43470((String)"Click here").method_27692(class_124.field_1075).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils feature disable " + this.getShortName()))));
        contributionMessage.method_10852((class_2561)class_2561.method_43470((String)" to disable this functionality.").method_27692(class_124.field_1062));
        McUtils.sendMessageToClient((class_2561)contributionMessage);
    }
}

